/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.idea.npw.WizardUtils;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.utils.SparseArray;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.ide.impl.ProjectPaneSelectInTarget;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEngine;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.uipreview.AndroidEditorSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemplateUtils {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.templates.DomUtilities");

    @Nullable
    public static String extractClassName(@NotNull String string) {
        char c;
        int i;
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/android/tools/idea/templates/TemplateUtils", "extractClassName"));
        }
        StringBuilder sb = new StringBuilder(string.length());
        int n = string.length();
        for (i = 0; i < n; ++i) {
            c = Character.toUpperCase(string.charAt(i));
            if (!Character.isJavaIdentifierStart(c)) continue;
            sb.append(c);
            ++i;
            break;
        }
        if (sb.length() > 0) {
            while (i < n) {
                c = string.charAt(i);
                if (Character.isJavaIdentifierPart(c)) {
                    sb.append(c);
                }
                ++i;
            }
            return sb.toString();
        }
        return null;
    }

    public static File stripSuffix(@NotNull File file, @NotNull String suffix) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/TemplateUtils", "stripSuffix"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suffix", "com/android/tools/idea/templates/TemplateUtils", "stripSuffix"));
        }
        if (file.getName().endsWith(suffix)) {
            String name = file.getName();
            name = name.substring(0, name.length() - suffix.length());
            File parent = file.getParentFile();
            if (parent != null) {
                return new File(parent, name);
            }
            return new File(name);
        }
        return file;
    }

    public static String camelCaseToUnderlines(String string) {
        if (string.isEmpty()) {
            return string;
        }
        StringBuilder sb = new StringBuilder(2 * string.length());
        int n = string.length();
        boolean lastWasUpperCase = Character.isUpperCase(string.charAt(0));
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            boolean isUpperCase = Character.isUpperCase(c);
            if (isUpperCase && !lastWasUpperCase) {
                sb.append('_');
            }
            lastWasUpperCase = isUpperCase;
            c = Character.toLowerCase(c);
            sb.append(c);
        }
        return sb.toString();
    }

    public static String underlinesToCamelCase(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        int n = string.length();
        boolean upcaseNext = true;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '_') {
                upcaseNext = true;
                continue;
            }
            if (upcaseNext) {
                c = Character.toUpperCase(c);
            }
            upcaseNext = false;
            sb.append(c);
        }
        return sb.toString();
    }

    @NotNull
    public static String[] getKnownVersions() {
        AndroidSdkData sdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        assert (sdkData != null);
        int max = 25;
        IAndroidTarget[] targets = sdkData.getTargets();
        SparseArray apiTargets = null;
        for (IAndroidTarget target : targets) {
            AndroidVersion version;
            if (!target.isPlatform() || (version = target.getVersion()).isPreview()) continue;
            int apiLevel = version.getApiLevel();
            max = Math.max(max, apiLevel);
            if (apiLevel <= 25) continue;
            if (apiTargets == null) {
                apiTargets = new SparseArray();
            }
            apiTargets.put(apiLevel, (Object)target);
        }
        String[] versions = new String[max];
        for (int api = 1; api <= max; ++api) {
            String name = SdkVersionInfo.getAndroidName((int)api);
            if (name == null) {
                IAndroidTarget target;
                if (apiTargets != null && (target = (IAndroidTarget)apiTargets.get(api)) != null) {
                    name = AndroidSdkUtils.getTargetLabel(target);
                }
                if (name == null) {
                    name = String.format("API %1$d", api);
                }
            }
            versions[api - 1] = name;
        }
        if (versions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TemplateUtils", "getKnownVersions"));
        }
        return versions;
    }

    @NotNull
    public static File[] listFiles(@Nullable File dir) {
        File[] fileArray = WizardUtils.listFiles(dir);
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TemplateUtils", "listFiles"));
        }
        return fileArray;
    }

    @NotNull
    public static List<Element> getChildren(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/templates/TemplateUtils", "getChildren"));
        }
        NodeList children = element.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>(children.getLength());
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            Element child = (Element)node;
            result.add(child);
        }
        ArrayList<Element> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TemplateUtils", "getChildren"));
        }
        return arrayList;
    }

    public static void reformatAndRearrange(final @NotNull Project project, final @NotNull Iterable<File> files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/TemplateUtils", "reformatAndRearrange"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/templates/TemplateUtils", "reformatAndRearrange"));
        }
        WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

            @Override
            public void run() {
                LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                for (File file : files) {
                    if (!file.isFile()) continue;
                    VirtualFile virtualFile = localFileSystem.findFileByIoFile(file);
                    assert (virtualFile != null);
                    TemplateUtils.reformatAndRearrange(project, virtualFile);
                }
            }
        });
    }

    public static void reformatAndRearrange(@NotNull Project project, @NotNull PsiElement psiElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/TemplateUtils", "reformatAndRearrange"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/android/tools/idea/templates/TemplateUtils", "reformatAndRearrange"));
        }
        TemplateUtils.reformatAndRearrange(project, psiElement.getContainingFile().getVirtualFile(), psiElement, true);
    }

    public static void reformatAndRearrange(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/TemplateUtils", "reformatAndRearrange"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/android/tools/idea/templates/TemplateUtils", "reformatAndRearrange"));
        }
        TemplateUtils.reformatAndRearrange(project, virtualFile, null, false);
    }

    private static void reformatAndRearrange(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable PsiElement psiElement, boolean keepDocumentLocked) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/TemplateUtils", "reformatAndRearrange"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/android/tools/idea/templates/TemplateUtils", "reformatAndRearrange"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return;
        }
        psiDocumentManager.commitDocument(document);
        PsiFile psiFile = psiDocumentManager.getPsiFile(document);
        if (psiFile != null) {
            TextRange textRange = psiElement == null ? psiFile.getTextRange() : psiElement.getTextRange();
            CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)psiFile, textRange.getStartOffset(), textRange.getEndOffset());
            textRange = psiElement == null ? psiFile.getTextRange() : psiElement.getTextRange();
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
            ((ArrangementEngine)ServiceManager.getService((Project)project, ArrangementEngine.class)).arrange(psiFile, Collections.singleton(textRange));
            if (keepDocumentLocked) {
                psiDocumentManager.commitDocument(document);
            }
        }
    }

    public static boolean openEditors(@NotNull Project project, @NotNull Collection<File> files, boolean select) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/TemplateUtils", "openEditors"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/android/tools/idea/templates/TemplateUtils", "openEditors"));
        }
        if (files.size() > 0) {
            boolean result = true;
            VirtualFile last = null;
            for (File file : files) {
                if (!file.exists()) continue;
                VirtualFile vFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
                if (vFile != null) {
                    result &= TemplateUtils.openEditor(project, vFile);
                    last = vFile;
                    continue;
                }
                result = false;
            }
            if (select && last != null) {
                TemplateUtils.selectEditor(project, last);
            }
            return result;
        }
        return false;
    }

    public static boolean openEditor(@NotNull Project project, @NotNull VirtualFile vFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/TemplateUtils", "openEditor"));
        }
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/android/tools/idea/templates/TemplateUtils", "openEditor"));
        }
        OpenFileDescriptor descriptor = vFile.getFileType() == StdFileTypes.XML && AndroidEditorSettings.getInstance().getGlobalState().isPreferXmlEditor() ? new OpenFileDescriptor(project, vFile, 0) : new OpenFileDescriptor(project, vFile);
        return !FileEditorManager.getInstance((Project)project).openEditor(descriptor, true).isEmpty();
    }

    public static void selectEditor(Project project, VirtualFile file) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile != null) {
            ProjectPaneSelectInTarget selectAction = new ProjectPaneSelectInTarget(project);
            selectAction.select((PsiElement)psiFile, false);
        }
    }

    @Nullable
    public static String readTextFromDisk(@NotNull File file, boolean warnIfNotExists) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/TemplateUtils", "readTextFromDisk"));
        }
        assert (file.isAbsolute());
        try {
            return Files.toString((File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            if (warnIfNotExists) {
                LOG.warn((Throwable)e);
            }
            return null;
        }
    }

    @Nullable
    public static String readTextFromDisk(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/TemplateUtils", "readTextFromDisk"));
        }
        return TemplateUtils.readTextFromDisk(file, true);
    }

    @Nullable
    public static String readTextFromDocument(@NotNull Project project, @NotNull File file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/TemplateUtils", "readTextFromDocument"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/TemplateUtils", "readTextFromDocument"));
        }
        assert (project.isInitialized());
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        if (vFile == null) {
            LOG.debug("Cannot find file " + file.getPath() + " in the VFS");
            return null;
        }
        return TemplateUtils.readTextFromDocument(project, vFile);
    }

    @Nullable
    public static String readTextFromDocument(@NotNull Project project, final @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/TemplateUtils", "readTextFromDocument"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/TemplateUtils", "readTextFromDocument"));
        }
        assert (project.isInitialized());
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            @Nullable
            public String compute() {
                Document document = FileDocumentManager.getInstance().getDocument(file);
                return document != null ? document.getText() : null;
            }
        });
    }

    public static void writeTextFile(@NotNull Object requestor, @Nullable String contents, @NotNull File to) throws IOException {
        Document document;
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/android/tools/idea/templates/TemplateUtils", "writeTextFile"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/android/tools/idea/templates/TemplateUtils", "writeTextFile"));
        }
        if (contents == null) {
            return;
        }
        VirtualFile vf = LocalFileSystem.getInstance().findFileByIoFile(to);
        if (vf == null) {
            VirtualFile parentDir = TemplateUtils.checkedCreateDirectoryIfMissing(to.getParentFile());
            vf = parentDir.createChildData(requestor, to.getName());
        }
        if ((document = FileDocumentManager.getInstance().getDocument(vf)) != null) {
            document.setText((CharSequence)contents.replaceAll("\r\n", "\n"));
            FileDocumentManager.getInstance().saveDocument(document);
        } else {
            vf.setBinaryContent(contents.getBytes(Charsets.UTF_8), -1L, -1L, requestor);
        }
    }

    @NotNull
    public static VirtualFile checkedCreateDirectoryIfMissing(final @NotNull File directory) throws IOException {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/android/tools/idea/templates/TemplateUtils", "checkedCreateDirectoryIfMissing"));
        }
        VirtualFile virtualFile = (VirtualFile)WriteCommandAction.runWriteCommandAction(null, (ThrowableComputable)new ThrowableComputable<VirtualFile, IOException>(){

            public VirtualFile compute() throws IOException {
                VirtualFile dir = VfsUtil.createDirectoryIfMissing((String)directory.getAbsolutePath());
                if (dir == null) {
                    throw new IOException("Unable to create " + directory.getAbsolutePath());
                }
                return dir;
            }
        });
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/TemplateUtils", "checkedCreateDirectoryIfMissing"));
        }
        return virtualFile;
    }

    public static void checkDirectoryIsWriteable(@NotNull File directory) throws IOException {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/android/tools/idea/templates/TemplateUtils", "checkDirectoryIsWriteable"));
        }
        while (!directory.exists() || !directory.isDirectory()) {
            directory = directory.getParentFile();
        }
        if (!directory.canWrite()) {
            throw new IOException("Cannot write to folder: " + directory.getAbsolutePath());
        }
    }

    public static boolean hasExtension(File file, String extension) {
        String noDotExtension = extension.startsWith(".") ? extension.substring(1) : extension;
        return Files.getFileExtension((String)file.getName()).equalsIgnoreCase(noDotExtension);
    }
}

