/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.android.builder.model.JavaArtifact;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.testartifacts.scopes.FileRootSearchScope;
import com.android.tools.idea.testartifacts.scopes.TestArtifactSearchScopes;
import com.intellij.execution.JUnitPatcher;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJunitPatcher
extends JUnitPatcher {
    public void patchJavaParameters(@Nullable Module module, @NotNull JavaParameters javaParameters) {
        if (javaParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaParameters", "com/android/tools/idea/testartifacts/scopes/AndroidJunitPatcher", "patchJavaParameters"));
        }
        if (module == null || !Projects.isBuildWithGradle(module.getProject())) {
            return;
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(module);
        if (androidModel == null) {
            return;
        }
        JavaArtifact testArtifact = androidModel.getUnitTestArtifactInSelectedVariant();
        if (testArtifact == null) {
            return;
        }
        PathsList classPath = javaParameters.getClassPath();
        TestArtifactSearchScopes testScopes = TestArtifactSearchScopes.get(module);
        if (testScopes == null) {
            return;
        }
        FileRootSearchScope excludeScope = testScopes.getUnitTestExcludeScope();
        for (String path : classPath.getPathList()) {
            if (!excludeScope.accept(new File(path))) continue;
            classPath.remove(path);
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform == null) {
            return;
        }
        String originalClassPath = classPath.getPathsString();
        try {
            AndroidJunitPatcher.handlePlatformJar(classPath, platform, testArtifact);
            AndroidJunitPatcher.handleJavaResources(module, androidModel, classPath);
        }
        catch (RuntimeException e) {
            throw new RuntimeException(String.format("Error patching the JUnit class path. Original class path:%n%s", originalClassPath), e);
        }
    }

    private static void handlePlatformJar(@NotNull PathsList classPath, @NotNull AndroidPlatform platform, @NotNull JavaArtifact artifact) {
        if (classPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classPath", "com/android/tools/idea/testartifacts/scopes/AndroidJunitPatcher", "handlePlatformJar"));
        }
        if (platform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platform", "com/android/tools/idea/testartifacts/scopes/AndroidJunitPatcher", "handlePlatformJar"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/testartifacts/scopes/AndroidJunitPatcher", "handlePlatformJar"));
        }
        String androidJarPath = platform.getTarget().getPath(1);
        for (Object entry : classPath.getPathList()) {
            if (!FileUtil.pathsEqual((String)androidJarPath, (String)entry)) continue;
            classPath.remove((String)entry);
        }
        List mockableJars = ContainerUtil.newSmartList();
        for (String path : classPath.getPathList()) {
            if (!new File(FileUtil.toSystemDependentName((String)path)).getName().startsWith("mockable-")) continue;
            mockableJars.add(path);
        }
        for (String mockableJar : mockableJars) {
            classPath.remove(mockableJar);
        }
        File mockableJar = AndroidJunitPatcher.getMockableJarFromModel(artifact);
        if (mockableJar != null) {
            classPath.addTail(mockableJar.getPath());
        } else {
            for (String mockableJarPath : mockableJars) {
                if (!mockableJarPath.endsWith("-" + platform.getApiLevel() + ".jar")) continue;
                classPath.addTail(mockableJarPath);
                return;
            }
        }
    }

    @Nullable
    private static File getMockableJarFromModel(@NotNull JavaArtifact model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/testartifacts/scopes/AndroidJunitPatcher", "getMockableJarFromModel"));
        }
        try {
            return model.getMockablePlatformJar();
        }
        catch (UnsupportedMethodException e) {
            return null;
        }
    }

    private static void handleJavaResources(@NotNull Module module, @NotNull AndroidModuleModel androidModel, @NotNull PathsList classPath) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/testartifacts/scopes/AndroidJunitPatcher", "handleJavaResources"));
        }
        if (androidModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidModel", "com/android/tools/idea/testartifacts/scopes/AndroidJunitPatcher", "handleJavaResources"));
        }
        if (classPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classPath", "com/android/tools/idea/testartifacts/scopes/AndroidJunitPatcher", "handleJavaResources"));
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)module.getProject());
        CompileScope scope = compilerManager.createModulesCompileScope(new Module[]{module}, true, true);
        JavaArtifact testArtifact = androidModel.getUnitTestArtifactInSelectedVariant();
        if (testArtifact != null) {
            try {
                classPath.add(testArtifact.getJavaResourcesFolder());
            }
            catch (UnsupportedMethodException unsupportedMethodException) {
                // empty catch block
            }
        }
        FileRootSearchScope excludeScope = null;
        TestArtifactSearchScopes testScopes = TestArtifactSearchScopes.get(module);
        if (testScopes != null) {
            excludeScope = testScopes.getUnitTestExcludeScope();
        }
        for (Module affectedModule : scope.getAffectedModules()) {
            AndroidModuleModel affectedAndroidModel;
            AndroidFacet facet = AndroidFacet.getInstance(affectedModule);
            if (facet == null || (affectedAndroidModel = AndroidModuleModel.get(facet)) == null) continue;
            try {
                File resourceFolder = affectedAndroidModel.getMainArtifact().getJavaResourcesFolder();
                if (excludeScope != null && excludeScope.accept(resourceFolder)) continue;
                classPath.add(resourceFolder);
            }
            catch (UnsupportedMethodException unsupportedMethodException) {
                // empty catch block
            }
        }
    }
}

