/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public final class TableUtils {
    private TableUtils() {
    }

    public static void paste(@NotNull JTable table, @NotNull Transferable transferable) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/android/tools/idea/ui/TableUtils", "paste"));
        }
        if (transferable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transferable", "com/android/tools/idea/ui/TableUtils", "paste"));
        }
        if (table.getSelectedRowCount() != 1 || table.getSelectedColumnCount() != 1) {
            return;
        }
        if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return;
        }
        int row = table.getSelectedRow();
        int rowCount = table.getRowCount();
        int selectedColumn = table.getSelectedColumn();
        int columnCount = table.getColumnCount();
        for (String values : TableUtils.getTransferDataAsString(transferable).split("\n")) {
            if (row >= rowCount) break;
            int column = selectedColumn;
            for (String value : values.split("\t")) {
                if (column >= columnCount) break;
                table.setValueAt(value, row, column++);
            }
            ++row;
        }
    }

    @NotNull
    private static String getTransferDataAsString(@NotNull Transferable transferable) {
        String string;
        if (transferable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transferable", "com/android/tools/idea/ui/TableUtils", "getTransferDataAsString"));
        }
        try {
            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            Logger.getInstance(TableUtils.class).warn((Throwable)exception);
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/TableUtils", "getTransferDataAsString"));
            }
            return "";
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/TableUtils", "getTransferDataAsString"));
        }
        return string;
    }

    public static void selectCellAt(@NotNull JTable table, int row, int column) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/android/tools/idea/ui/TableUtils", "selectCellAt"));
        }
        table.setRowSelectionInterval(row, row);
        table.setColumnSelectionInterval(column, column);
    }
}

