/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.properties.swing;

import com.android.tools.idea.ui.properties.core.OptionalProperty;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

public final class IconProperty
extends OptionalProperty<Icon>
implements PropertyChangeListener {
    @NotNull
    private final JComponent myComponent;

    public IconProperty(@NotNull JLabel label) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/idea/ui/properties/swing/IconProperty", "<init>"));
        }
        this.myComponent = label;
        label.addPropertyChangeListener("icon", this);
    }

    public IconProperty(@NotNull AbstractButton button) {
        if (button == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/android/tools/idea/ui/properties/swing/IconProperty", "<init>"));
        }
        this.myComponent = button;
        button.addPropertyChangeListener("icon", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.notifyInvalidated();
    }

    @Override
    protected void setDirectly(@NotNull Optional<Icon> value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/ui/properties/swing/IconProperty", "setDirectly"));
        }
        if (this.myComponent instanceof JLabel) {
            ((JLabel)this.myComponent).setIcon(value.orElse(null));
        } else if (this.myComponent instanceof AbstractButton) {
            ((AbstractButton)this.myComponent).setIcon(value.orElse(null));
        } else {
            throw new IllegalStateException("Unexpected icon component type: " + this.myComponent.getClass().getSimpleName());
        }
    }

    @Override
    @NotNull
    public Optional<Icon> get() {
        if (this.myComponent instanceof JLabel) {
            Optional<Icon> optional = Optional.ofNullable(((JLabel)this.myComponent).getIcon());
            if (optional == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/swing/IconProperty", "get"));
            }
            return optional;
        }
        if (this.myComponent instanceof AbstractButton) {
            Optional<Icon> optional = Optional.ofNullable(((AbstractButton)this.myComponent).getIcon());
            if (optional == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/properties/swing/IconProperty", "get"));
            }
            return optional;
        }
        throw new IllegalStateException("Unexpected icon component type: " + this.myComponent.getClass().getSimpleName());
    }
}

