/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.validation;

import com.intellij.icons.AllIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Validator<T> {
    @NotNull
    public Result validate(@NotNull T var1);

    public static final class Result {
        public static final Result OK = new Result(Severity.OK, "");
        private final Severity mySeverity;
        private final String myMessage;

        public Result(@NotNull Severity severity, @NotNull String message) {
            if (severity == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/android/tools/idea/ui/validation/Validator$Result", "<init>"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/ui/validation/Validator$Result", "<init>"));
            }
            this.mySeverity = severity;
            this.myMessage = message;
        }

        @NotNull
        public Severity getSeverity() {
            Severity severity = this.mySeverity;
            if (severity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/Validator$Result", "getSeverity"));
            }
            return severity;
        }

        @NotNull
        public String getMessage() {
            String string = this.myMessage;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/Validator$Result", "getMessage"));
            }
            return string;
        }

        @NotNull
        public static Result fromNullableMessage(@Nullable String errorMessage) {
            Result result = errorMessage == null ? OK : new Result(Severity.ERROR, errorMessage);
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/validation/Validator$Result", "fromNullableMessage"));
            }
            return result;
        }
    }

    public static enum Severity {
        OK(null),
        INFO(AllIcons.General.BalloonInformation),
        WARNING(AllIcons.General.BalloonWarning),
        ERROR(AllIcons.General.BalloonError);

        @Nullable
        private final Icon myIcon;

        private Severity(Icon icon) {
            this.myIcon = icon;
        }

        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }
    }
}

