/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.XmlBuilder;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.handlers.ImageViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FloatingActionButtonHandler
extends ImageViewHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        ImmutableList immutableList = ImmutableList.of((Object)"src", (Object)"backgroundTint", (Object)"rippleColor", (Object)"tint", (Object)"fabSize", (Object)"layout_anchor", (Object)"layout_anchorGravity", (Object)"elevation");
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/FloatingActionButtonHandler", "getInspectorProperties"));
        }
        return immutableList;
    }

    @Override
    @NotNull
    @Language(value="XML")
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/android/tools/idea/uibuilder/handlers/FloatingActionButtonHandler", "getXml"));
        }
        if (xmlType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlType", "com/android/tools/idea/uibuilder/handlers/FloatingActionButtonHandler", "getXml"));
        }
        XmlBuilder builder = new XmlBuilder().startTag(tagName).androidAttribute("src", this.getSampleImageSrc()).androidAttribute("layout_width", "wrap_content").androidAttribute("layout_height", "wrap_content").androidAttribute("clickable", true);
        if (xmlType.equals((Object)XmlType.PREVIEW_ON_PALETTE)) {
            builder.attribute("app", "elevation", "0dp");
        } else {
            builder.attribute("app", "fabSize", "mini");
        }
        String string = builder.endTag(tagName).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/FloatingActionButtonHandler", "getXml"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getSampleImageSrc() {
        if ("@android:drawable/ic_input_add" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/FloatingActionButtonHandler", "getSampleImageSrc"));
        }
        return "@android:drawable/ic_input_add";
    }

    @Override
    public double getPreviewScale(@NotNull String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/android/tools/idea/uibuilder/handlers/FloatingActionButtonHandler", "getPreviewScale"));
        }
        return 0.8;
    }

    @Override
    public boolean acceptsParent(@NotNull NlComponent layout, @NotNull NlComponent newChild) {
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/android/tools/idea/uibuilder/handlers/FloatingActionButtonHandler", "acceptsParent"));
        }
        if (newChild == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newChild", "com/android/tools/idea/uibuilder/handlers/FloatingActionButtonHandler", "acceptsParent"));
        }
        NlComponent appBar = FloatingActionButtonHandler.getAppBar(layout);
        if (appBar == null) {
            return super.acceptsParent(layout, newChild);
        }
        return layout == appBar.getParent();
    }

    @Nullable
    private static NlComponent getAppBar(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/FloatingActionButtonHandler", "getAppBar"));
        }
        NlComponent parent = component.getParent();
        while (parent != null) {
            component = parent;
            parent = component.getParent();
        }
        if (!component.getTagName().equals("android.support.design.widget.CoordinatorLayout")) {
            return null;
        }
        for (NlComponent child : component.getChildren()) {
            if (!child.getTagName().equals("android.support.design.widget.AppBarLayout")) continue;
            return child;
        }
        return null;
    }
}

