/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.XmlBuilder;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

public class TextViewHandler
extends ViewHandler {
    private static final Set<String> HAVE_REDUCED_SCALE_IN_PREVIEW = ImmutableSet.of((Object)"AutoCompleteTextView", (Object)"EditText", (Object)"MultiAutoCompleteTextView");

    @Override
    @NotNull
    public String getTitleAttributes(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/handlers/TextViewHandler", "getTitleAttributes"));
        }
        String text = component.getAttribute("http://schemas.android.com/apk/res/android", "text");
        if (!StringUtil.isEmpty((String)text)) {
            String string = String.format("- \"%1$s\"", text);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/TextViewHandler", "getTitleAttributes"));
            }
            return string;
        }
        String string = super.getTitleAttributes(component);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/TextViewHandler", "getTitleAttributes"));
        }
        return string;
    }

    @Override
    @Language(value="XML")
    @NotNull
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/android/tools/idea/uibuilder/handlers/TextViewHandler", "getXml"));
        }
        if (xmlType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlType", "com/android/tools/idea/uibuilder/handlers/TextViewHandler", "getXml"));
        }
        String string = new XmlBuilder().startTag(tagName).androidAttribute("text", tagName).androidAttribute("layout_width", "wrap_content").androidAttribute("layout_height", "wrap_content").endTag(tagName).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/TextViewHandler", "getXml"));
        }
        return string;
    }

    @Override
    public double getPreviewScale(@NotNull String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/android/tools/idea/uibuilder/handlers/TextViewHandler", "getPreviewScale"));
        }
        if (HAVE_REDUCED_SCALE_IN_PREVIEW.contains(tagName)) {
            return 0.8;
        }
        return super.getPreviewScale(tagName);
    }

    @Override
    @NotNull
    public String getPreferredProperty() {
        if ("text" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/handlers/TextViewHandler", "getPreferredProperty"));
        }
        return "text";
    }
}

