/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup;

import com.android.tools.idea.uibuilder.mockup.Mockup;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.surface.MockupLayer;
import com.android.tools.pixelprobe.Image;
import com.android.tools.pixelprobe.PixelProbe;
import com.android.tools.pixelprobe.decoder.Decoder;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.WeakHashMap;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockupFileHelper {
    public static final Set<String> VALID_EXTENSION = new HashSet<String>(Arrays.asList("psd", "png", "jpg"));
    public static final Logger LOGGER = Logger.getInstance(MockupFileHelper.class);
    private static final WeakHashMap<String, Image> IMAGE_CACHE = new WeakHashMap();

    @Nullable
    public static Image openImageFile(String path) {
        Image image = null;
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        if (IMAGE_CACHE.containsKey((Object)path)) {
            return (Image)IMAGE_CACHE.get((Object)path);
        }
        try (FileInputStream in = new FileInputStream(file);){
            image = PixelProbe.probe((InputStream)in, (Decoder.Options)Decoder.Options.LAYER_METADATA_ONLY);
            IMAGE_CACHE.put((Object)path, (Object)image);
        }
        catch (IOException e) {
            Logger.getInstance(MockupLayer.class).error((Throwable)e);
        }
        return image;
    }

    public static FileChooserDescriptor getFileChooserDescriptor() {
        return FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withFileFilter(file -> VALID_EXTENSION.contains(file.getExtension())).withTitle("Choose Mockup File").withDescription("PSD, JPEG, PNG are accepted");
    }

    public static void writePositionToXML(final @NotNull Mockup mockup) {
        if (mockup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mockup", "com/android/tools/idea/uibuilder/mockup/MockupFileHelper", "writePositionToXML"));
        }
        final NlComponent component = mockup.getComponent();
        if (component == null) {
            return;
        }
        NlModel model = component.getModel();
        WriteCommandAction action = new WriteCommandAction(model.getProject(), "Edit Mockup Crop", new PsiFile[]{model.getFile()}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/mockup/MockupFileHelper$1", "run"));
                }
                if (mockup.isFullScreen()) {
                    component.removeAttribute("http://schemas.android.com/tools", "mockup_crop");
                } else {
                    String cropping = MockupFileHelper.getPositionString(mockup);
                    component.setAttribute("http://schemas.android.com/tools", "mockup_crop", cropping);
                }
            }
        };
        action.execute();
    }

    public static String getPositionString(@NotNull Mockup mockup) {
        if (mockup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mockup", "com/android/tools/idea/uibuilder/mockup/MockupFileHelper", "getPositionString"));
        }
        Rectangle bounds = mockup.getBounds();
        Rectangle crop = mockup.getCropping();
        String cropping = bounds.equals(new Rectangle(0, 0, -1, -1)) ? String.format(Locale.US, "%d %d %d %d", crop.x, crop.y, crop.width, crop.height) : String.format(Locale.US, "%d %d %d %d %d %d %d %d", crop.x, crop.y, crop.width, crop.height, bounds.x, bounds.y, bounds.width, bounds.height);
        return cropping;
    }

    @Nullable
    public static Path getXMLFilePath(@NotNull Project project, @NotNull String filePath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/mockup/MockupFileHelper", "getXMLFilePath"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/android/tools/idea/uibuilder/mockup/MockupFileHelper", "getXMLFilePath"));
        }
        String basePath = project.getBasePath();
        if (basePath == null) {
            return null;
        }
        Path path = null;
        Path projectDirectory = Paths.get(basePath, new String[0]).normalize();
        try {
            path = MockupFileHelper.getFullFilePath(project, filePath);
            if (path != null && path.startsWith(projectDirectory)) {
                return projectDirectory.relativize(path).normalize();
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format("Incorrect File Path : %s", filePath));
        }
        return path;
    }

    @Nullable
    public static Path getFullFilePath(Project project, String filePath) {
        String basePath = project.getBasePath();
        if (filePath == null || filePath.isEmpty() || basePath == null) {
            return null;
        }
        Path projectDirectory = Paths.get(basePath, new String[0]).normalize();
        try {
            Path path = Paths.get(filePath, new String[0]);
            if (!path.isAbsolute()) {
                path = projectDirectory.resolve(path).normalize();
            }
            return path.normalize();
        }
        catch (Exception e) {
            LOGGER.error(String.format("Incorrect File Path : %s", filePath));
            return null;
        }
    }
}

