/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.mockup.editor;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.mockup.MockupFileHelper;
import com.android.tools.idea.uibuilder.mockup.editor.DeviceSelectionPopup;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.pixelprobe.Image;
import com.android.tools.pixelprobe.PixelProbe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TextAccessor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileChooserActionListener
implements ActionListener {
    private static final Logger LOGGER = Logger.getInstance(FileChooserActionListener.class);
    private static VirtualFile ourLastOpenedFile = null;
    @Nullable
    private NlComponent myComponent;
    @Nullable
    private NlProperty myFilePathProperty;
    private NlProperty myCropProperty;

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.myFilePathProperty == null) {
            return;
        }
        FileChooserDescriptor descriptor = MockupFileHelper.getFileChooserDescriptor();
        VirtualFile selectedFile = this.myFilePathProperty.getValue() != null ? VfsUtil.findFileByIoFile((File)new File(FileUtil.toSystemIndependentName((String)this.myFilePathProperty.getValue())), (boolean)false) : ourLastOpenedFile;
        FileChooser.chooseFile((FileChooserDescriptor)descriptor, null, null, (VirtualFile)selectedFile, virtualFile -> {
            ourLastOpenedFile = virtualFile;
            if (this.myComponent != null && this.myComponent.isRoot()) {
                FileChooserActionListener.openDeviceChoiceDialog(virtualFile, this.myFilePathProperty, this.myCropProperty);
            } else {
                TextAccessor textAccessor;
                FileChooserActionListener.saveMockupFile(virtualFile, this.myFilePathProperty, this.myCropProperty);
                if (e == null) {
                    return;
                }
                TextAccessor textAccessor2 = textAccessor = e.getSource() instanceof TextAccessor ? (TextAccessor)e.getSource() : null;
                if (textAccessor != null) {
                    textAccessor.setText(virtualFile.getPath());
                }
            }
        });
    }

    private static void openDeviceChoiceDialog(VirtualFile virtualFile, @NotNull NlProperty fileProperty, @Nullable NlProperty cropProperty) {
        if (fileProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileProperty", "com/android/tools/idea/uibuilder/mockup/editor/FileChooserActionListener", "openDeviceChoiceDialog"));
        }
        if (virtualFile.exists() && !virtualFile.isDirectory()) {
            try {
                Image probe = PixelProbe.probe((InputStream)virtualFile.getInputStream());
                BufferedImage image = probe.getMergedImage();
                if (image == null) {
                    return;
                }
                NlModel model = fileProperty.getModel();
                Configuration configuration = model.getConfiguration();
                Device device = configuration.getDevice();
                if (device == null) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (fileProperty == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileProperty", "com/android/tools/idea/uibuilder/mockup/editor/FileChooserActionListener", "lambda$openDeviceChoiceDialog$1"));
                    }
                    DeviceSelectionPopup deviceSelectionPopup = new DeviceSelectionPopup(model.getProject(), configuration, image);
                    if (deviceSelectionPopup.showAndGet()) {
                        FileChooserActionListener.saveMockupFile(virtualFile, fileProperty, cropProperty);
                    }
                });
            }
            catch (IOException e1) {
                LOGGER.warn("Unable to open this file\n" + e1.getMessage());
            }
        }
    }

    private static void saveMockupFile(@NotNull VirtualFile virtualFile, @NotNull NlProperty filePath, NlProperty cropProperty) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/android/tools/idea/uibuilder/mockup/editor/FileChooserActionListener", "saveMockupFile"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/android/tools/idea/uibuilder/mockup/editor/FileChooserActionListener", "saveMockupFile"));
        }
        if (cropProperty != null) {
            cropProperty.setValue("");
        }
        filePath.setValue(MockupFileHelper.getXMLFilePath(filePath.getModel().getProject(), virtualFile.getPath()));
    }

    public void setFilePathProperty(@Nullable NlProperty filePathProperty) {
        this.myFilePathProperty = filePathProperty;
        if (this.myFilePathProperty == null) {
            this.myComponent = null;
            return;
        }
        List<NlComponent> components = filePathProperty.getComponents();
        if (!components.isEmpty()) {
            this.myComponent = components.get(0);
        }
    }

    public void setCropProperty(@Nullable NlProperty cropProperty) {
        this.myCropProperty = cropProperty;
    }
}

