/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.rendering.AttributeSnapshot;
import com.android.tools.idea.rendering.TagSnapshot;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.AttributesTransaction;
import com.android.tools.idea.uibuilder.model.Insets;
import com.android.tools.idea.uibuilder.model.NlAttributesHolder;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.model.PreferenceUtils;
import com.android.tools.idea.uibuilder.model.Ranges;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlComponent
implements NlAttributesHolder {
    private static final Collection<String> TAGS_THAT_DONT_NEED_DEFAULT_IDS = new ImmutableSet.Builder().add((Object)"requestFocus").add((Object)"Space").add((Object)"item").add((Object)"include").add((Object)"merge").addAll(PreferenceUtils.VALUES).build();
    @Nullable
    public List<NlComponent> children;
    @Nullable
    public ViewInfo viewInfo;
    public int x;
    public int y;
    public int w;
    public int h;
    private NlComponent myParent;
    @NotNull
    private final NlModel myModel;
    @NotNull
    private XmlTag myTag;
    @NotNull
    private String myTagName;
    @Nullable
    private TagSnapshot mySnapshot;
    HashMap<Object, Object> myClientProperties;
    private ArrayList<ChangeListener> myListeners;
    private ChangeEvent myChangeEvent;
    @Nullable
    AttributesTransaction myCurrentTransaction;
    private Insets myMargins;
    private Insets myPadding;

    public NlComponent(@NotNull NlModel model, @NotNull XmlTag tag) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/model/NlComponent", "<init>"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/uibuilder/model/NlComponent", "<init>"));
        }
        this.myClientProperties = new HashMap();
        this.myListeners = new ArrayList();
        this.myChangeEvent = new ChangeEvent(this);
        this.myModel = model;
        this.myTag = tag;
        this.myTagName = tag.getName();
    }

    @NotNull
    public XmlTag getTag() {
        XmlTag xmlTag = this.myTag;
        if (xmlTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlComponent", "getTag"));
        }
        return xmlTag;
    }

    @NotNull
    public NlModel getModel() {
        NlModel nlModel = this.myModel;
        if (nlModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlComponent", "getModel"));
        }
        return nlModel;
    }

    public void setTag(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/uibuilder/model/NlComponent", "setTag"));
        }
        this.myTag = tag;
        this.myTagName = tag.getName();
    }

    @Nullable
    public TagSnapshot getSnapshot() {
        return this.mySnapshot;
    }

    public void setSnapshot(@Nullable TagSnapshot snapshot) {
        this.mySnapshot = snapshot;
    }

    public void setBounds(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public void addChild(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/model/NlComponent", "addChild"));
        }
        this.addChild(component, null);
    }

    public void addChild(@NotNull NlComponent component, @Nullable NlComponent before) {
        int index;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/model/NlComponent", "addChild"));
        }
        if (component == this) {
            throw new IllegalArgumentException();
        }
        if (this.children == null) {
            this.children = Lists.newArrayList();
        }
        int n = index = before != null ? this.children.indexOf(before) : -1;
        if (index != -1) {
            this.children.add(index, component);
        } else {
            this.children.add(component);
        }
        component.setParent(this);
    }

    public void removeChild(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/model/NlComponent", "removeChild"));
        }
        if (component == this) {
            throw new IllegalArgumentException();
        }
        if (this.children != null) {
            this.children.remove(component);
        }
        component.setParent(null);
    }

    public void setChildren(@Nullable List<NlComponent> components) {
        this.children = components;
        if (components != null) {
            for (NlComponent component : components) {
                if (component == this) {
                    throw new IllegalArgumentException();
                }
                component.setParent(this);
            }
        }
    }

    @NotNull
    public List<NlComponent> getChildren() {
        List<NlComponent> list = this.children != null ? this.children : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlComponent", "getChildren"));
        }
        return list;
    }

    public int getChildCount() {
        return this.children != null ? this.children.size() : 0;
    }

    @Nullable
    public NlComponent getChild(int index) {
        return this.children != null && index >= 0 && index < this.children.size() ? this.children.get(index) : null;
    }

    @NotNull
    public Stream<NlComponent> flatten() {
        Stream<NlComponent> stream = Stream.concat(Stream.of(this), this.getChildren().stream().flatMap(NlComponent::flatten));
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlComponent", "flatten"));
        }
        return stream;
    }

    @Nullable
    public NlComponent getNextSibling() {
        if (this.myParent == null) {
            return null;
        }
        for (int index = 0; index < this.myParent.getChildCount(); ++index) {
            if (this.myParent.getChild(index) != this) continue;
            return this.myParent.getChild(index + 1);
        }
        return null;
    }

    @Nullable
    public NlComponent findViewByTag(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/uibuilder/model/NlComponent", "findViewByTag"));
        }
        if (this.myTag == tag) {
            return this;
        }
        if (this.children != null) {
            for (NlComponent child : this.children) {
                NlComponent result = child.findViewByTag(tag);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Nullable
    public List<NlComponent> findViewsByTag(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/android/tools/idea/uibuilder/model/NlComponent", "findViewsByTag"));
        }
        List<NlComponent> result = null;
        if (this.children != null) {
            for (NlComponent child : this.children) {
                List<NlComponent> matches = child.findViewsByTag(tag);
                if (matches == null) continue;
                if (result != null) {
                    result.addAll(matches);
                    continue;
                }
                result = matches;
            }
        }
        if (this.myTag == tag) {
            if (result == null) {
                return Lists.newArrayList((Object[])new NlComponent[]{this});
            }
            result.add(this);
        }
        return result;
    }

    @Nullable
    public NlComponent findImmediateLeafAt(int px, int py) {
        if (this.children != null) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                NlComponent child = this.children.get(i);
                if (child.x > px || child.y > py || child.x + child.w < px || child.y + child.h < py) continue;
                return child;
            }
        }
        return this.x <= px && this.y <= py && this.x + this.w >= px && this.y + this.h >= py ? this : null;
    }

    @Nullable
    public NlComponent findLeafAt(int px, int py) {
        if (this.children != null) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                NlComponent child = this.children.get(i);
                NlComponent result = child.findLeafAt(px, py);
                if (result == null) continue;
                return result;
            }
        }
        return this.x <= px && this.y <= py && this.x + this.w >= px && this.y + this.h >= py ? this : null;
    }

    public boolean containsX(int x) {
        return Ranges.contains(this.x, this.x + this.w, x);
    }

    public boolean containsY(int y) {
        return Ranges.contains(this.y, this.y + this.h, y);
    }

    public int getMidpointX() {
        return this.x + this.w / 2;
    }

    public int getMidpointY() {
        return this.y + this.h / 2;
    }

    public boolean isRoot() {
        return !(this.myTag.getParent() instanceof XmlTag);
    }

    public NlComponent getRoot() {
        NlComponent component;
        for (component = this; component != null && !component.isRoot(); component = component.getParent()) {
        }
        return component;
    }

    @Nullable
    public String getId() {
        String id = this.myCurrentTransaction != null ? this.myCurrentTransaction.getAndroidAttribute("id") : this.getAndroidAttribute("id");
        return NlComponent.stripId(id);
    }

    @Nullable
    public static String stripId(@Nullable String id) {
        if (id != null) {
            if (id.startsWith("@+id/")) {
                return id.substring("@+id/".length());
            }
            if (id.startsWith("@id/")) {
                return id.substring("@id/".length());
            }
        }
        return null;
    }

    public boolean needsDefaultId() {
        if (TAGS_THAT_DONT_NEED_DEFAULT_IDS.contains(this.myTagName)) {
            return false;
        }
        if (this.myTagName.endsWith("Space") && this.myTagName.length() > "Space".length() && this.myTagName.charAt(this.myTagName.length() - "Space".length()) == '.') {
            return false;
        }
        ViewHandler viewHandler = this.getViewHandler();
        return !(viewHandler == null ? this.myTagName.endsWith("Layout") : viewHandler instanceof ViewGroupHandler);
    }

    public String ensureId() {
        String id = this.getId();
        if (id != null) {
            return id;
        }
        return this.assignId();
    }

    public String ensureLiveId() {
        String id = this.getId();
        if (id != null) {
            return id;
        }
        final AttributesTransaction attributes = this.startAttributeTransaction();
        id = this.assignId();
        attributes.apply();
        WriteCommandAction action = new WriteCommandAction(this.getModel().getProject(), "Added id", new PsiFile[]{this.getModel().getFile()}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/model/NlComponent$1", "run"));
                }
                attributes.commit();
            }
        };
        action.execute();
        return id;
    }

    private String assignId() {
        Collection<String> idList = NlComponent.getIds(this.myModel);
        return NlComponent.assignId(this, idList);
    }

    @NotNull
    public static String assignId(@NotNull NlComponent component, @NotNull Collection<String> idList) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/model/NlComponent", "assignId"));
        }
        if (idList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idList", "com/android/tools/idea/uibuilder/model/NlComponent", "assignId"));
        }
        String tagName = component.getTagName();
        tagName = tagName.substring(tagName.lastIndexOf(46) + 1);
        String idValue = StringUtil.decapitalize((String)tagName);
        Module module = component.getModel().getModule();
        Project project = module.getProject();
        String nextIdValue = idValue = ResourceHelper.prependResourcePrefix(module, idValue, ResourceFolderType.LAYOUT);
        int index = 0;
        NamesValidator validator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)JavaLanguage.INSTANCE);
        while (idList.contains(nextIdValue) || validator != null && validator.isKeyword(nextIdValue, project)) {
            if (!(++index != 1 || validator != null && validator.isKeyword(nextIdValue, project))) {
                nextIdValue = idValue;
                continue;
            }
            nextIdValue = idValue + Integer.toString(index);
        }
        String newId = idValue + (index == 0 ? "" : Integer.toString(index));
        NlAttributesHolder attributes = component.myCurrentTransaction != null ? component.myCurrentTransaction : component;
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "id", "@+id/" + newId);
        component.myModel.getPendingIds().add(newId);
        String string = newId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlComponent", "assignId"));
        }
        return string;
    }

    public static Collection<String> getIds(@NotNull NlModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/uibuilder/model/NlComponent", "getIds"));
        }
        AndroidFacet facet = model.getFacet();
        AppResourceRepository resources = AppResourceRepository.getAppResources(facet, true);
        ArrayList ids = resources.getItemsOfType(ResourceType.ID);
        Set<String> pendingIds = model.getPendingIds();
        if (!pendingIds.isEmpty()) {
            ArrayList all = Lists.newArrayListWithCapacity((int)(pendingIds.size() + ids.size()));
            all.addAll(ids);
            all.addAll(pendingIds);
            ids = all;
        }
        return ids;
    }

    public int getBaseline() {
        try {
            if (this.viewInfo != null) {
                Object viewObject = this.viewInfo.getViewObject();
                return (Integer)viewObject.getClass().getMethod("getBaseline", new Class[0]).invoke(viewObject, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }

    public int getMinimumWidth() {
        try {
            if (this.viewInfo != null) {
                Object viewObject = this.viewInfo.getViewObject();
                return (Integer)viewObject.getClass().getMethod("getMinimumWidth", new Class[0]).invoke(viewObject, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    public int getMinimumHeight() {
        try {
            if (this.viewInfo != null) {
                Object viewObject = this.viewInfo.getViewObject();
                return (Integer)viewObject.getClass().getMethod("getMinimumHeight", new Class[0]).invoke(viewObject, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    public int getAndroidViewVisibility() {
        try {
            if (this.viewInfo != null) {
                Object viewObject = this.viewInfo.getViewObject();
                return (Integer)viewObject.getClass().getMethod("getVisibility", new Class[0]).invoke(viewObject, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    private static int fixDefault(int value) {
        return value == Integer.MIN_VALUE ? 0 : value;
    }

    @NotNull
    public Insets getMargins() {
        if (this.myMargins == null) {
            if (this.viewInfo == null) {
                Insets insets = Insets.NONE;
                if (insets == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlComponent", "getMargins"));
                }
                return insets;
            }
            try {
                Object layoutParams = this.viewInfo.getLayoutParamsObject();
                Class<?> layoutClass = layoutParams.getClass();
                int left = NlComponent.fixDefault(layoutClass.getField("leftMargin").getInt(layoutParams));
                int top = NlComponent.fixDefault(layoutClass.getField("topMargin").getInt(layoutParams));
                int right = NlComponent.fixDefault(layoutClass.getField("rightMargin").getInt(layoutParams));
                int bottom = NlComponent.fixDefault(layoutClass.getField("bottomMargin").getInt(layoutParams));
                this.myMargins = left == 0 && top == 0 && right == 0 && bottom == 0 ? Insets.NONE : new Insets(left, top, right, bottom);
            }
            catch (Throwable e) {
                this.myMargins = Insets.NONE;
            }
        }
        Insets insets = this.myMargins;
        if (insets == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlComponent", "getMargins"));
        }
        return insets;
    }

    @NotNull
    public Insets getPadding() {
        Insets insets = this.getPadding(false);
        if (insets == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlComponent", "getPadding"));
        }
        return insets;
    }

    @NotNull
    public Insets getPadding(boolean force) {
        if (this.myPadding == null || force) {
            if (this.viewInfo == null) {
                Insets insets = Insets.NONE;
                if (insets == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlComponent", "getPadding"));
                }
                return insets;
            }
            try {
                Object layoutParams = this.viewInfo.getViewObject();
                Class<?> layoutClass = layoutParams.getClass();
                int left = NlComponent.fixDefault((Integer)layoutClass.getMethod("getPaddingLeft", new Class[0]).invoke(layoutParams, new Object[0]));
                int top = NlComponent.fixDefault((Integer)layoutClass.getMethod("getPaddingTop", new Class[0]).invoke(layoutParams, new Object[0]));
                int right = NlComponent.fixDefault((Integer)layoutClass.getMethod("getPaddingRight", new Class[0]).invoke(layoutParams, new Object[0]));
                int bottom = NlComponent.fixDefault((Integer)layoutClass.getMethod("getPaddingBottom", new Class[0]).invoke(layoutParams, new Object[0]));
                this.myPadding = left == 0 && top == 0 && right == 0 && bottom == 0 ? Insets.NONE : new Insets(left, top, right, bottom);
            }
            catch (Throwable e) {
                this.myPadding = Insets.NONE;
            }
        }
        Insets insets = this.myPadding;
        if (insets == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlComponent", "getPadding"));
        }
        return insets;
    }

    public boolean isOrHasSuperclass(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/android/tools/idea/uibuilder/model/NlComponent", "isOrHasSuperclass"));
        }
        if (this.viewInfo != null) {
            Object viewObject = this.viewInfo.getViewObject();
            if (viewObject == null) {
                return ApplicationManager.getApplication().isUnitTestMode() && this.myTagName.equals(className);
            }
            for (Class<?> viewClass = viewObject.getClass(); viewClass != Object.class; viewClass = viewClass.getSuperclass()) {
                if (!className.equals(viewClass.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public NlComponent getParent() {
        return this.myParent;
    }

    private void setParent(@Nullable NlComponent parent) {
        this.myParent = parent;
    }

    @NotNull
    public String getTagName() {
        String string = this.myTagName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlComponent", "getTagName"));
        }
        return string;
    }

    public String toString() {
        return String.format("<%s> (%s, %s) %s \u00d7 %s", this.myTagName, this.x, this.y, this.w, this.h);
    }

    @Override
    public void setAttribute(@Nullable String namespace, @NotNull String attribute, @Nullable String value) {
        String previous;
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/uibuilder/model/NlComponent", "setAttribute"));
        }
        if (!this.myTag.isValid()) {
            return;
        }
        String prefix = null;
        if (namespace != null && !"http://schemas.android.com/apk/res/android".equals(namespace)) {
            prefix = AndroidResourceUtil.ensureNamespaceImported((XmlFile)this.myTag.getContainingFile(), namespace, null);
        }
        if ((previous = this.getAttribute(namespace, attribute)) != null && previous.equalsIgnoreCase(value) || previous == null && value == null) {
            return;
        }
        this.myTag.setAttribute(attribute, namespace, value);
        if (this.mySnapshot != null) {
            this.mySnapshot.setAttribute(attribute, namespace, prefix, value);
        }
    }

    @NotNull
    public AttributesTransaction startAttributeTransaction() {
        if (this.myCurrentTransaction == null) {
            this.myCurrentTransaction = new AttributesTransaction(this);
        }
        AttributesTransaction attributesTransaction = this.myCurrentTransaction;
        if (attributesTransaction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlComponent", "startAttributeTransaction"));
        }
        return attributesTransaction;
    }

    @Nullable
    public String getLiveAttribute(@Nullable String namespace, @NotNull String attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/uibuilder/model/NlComponent", "getLiveAttribute"));
        }
        if (this.myCurrentTransaction != null) {
            return this.myCurrentTransaction.getAttribute(namespace, attribute);
        }
        return this.getAttribute(namespace, attribute);
    }

    @Override
    @Nullable
    public String getAttribute(@Nullable String namespace, @NotNull String attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/android/tools/idea/uibuilder/model/NlComponent", "getAttribute"));
        }
        if (this.mySnapshot != null) {
            return this.mySnapshot.getAttribute(attribute, namespace);
        }
        if (AndroidPsiUtils.isValid(this.myTag)) {
            return AndroidPsiUtils.getAttributeSafely(this.myTag, namespace, attribute);
        }
        return null;
    }

    @NotNull
    public List<AttributeSnapshot> getAttributes() {
        if (this.mySnapshot != null) {
            List<AttributeSnapshot> list = this.mySnapshot.attributes;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlComponent", "getAttributes"));
            }
            return list;
        }
        if (this.myTag.isValid()) {
            Application application = ApplicationManager.getApplication();
            if (!application.isReadAccessAllowed()) {
                List list = (List)application.runReadAction(() -> AttributeSnapshot.createAttributesForTag(this.myTag));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlComponent", "getAttributes"));
                }
                return list;
            }
            List<AttributeSnapshot> list = AttributeSnapshot.createAttributesForTag(this.myTag);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlComponent", "getAttributes"));
            }
            return list;
        }
        List<AttributeSnapshot> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlComponent", "getAttributes"));
        }
        return list;
    }

    public String ensureNamespace(@NotNull String prefix, @NotNull String namespace) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/android/tools/idea/uibuilder/model/NlComponent", "ensureNamespace"));
        }
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/android/tools/idea/uibuilder/model/NlComponent", "ensureNamespace"));
        }
        return AndroidResourceUtil.ensureNamespaceImported((XmlFile)this.myTag.getContainingFile(), namespace, prefix);
    }

    public boolean isShowing() {
        return this.mySnapshot != null;
    }

    @Nullable
    public ViewHandler getViewHandler() {
        if (!this.myTag.isValid()) {
            return null;
        }
        return ViewHandlerManager.get(this.myTag.getProject()).getHandler(this);
    }

    @Nullable
    public ViewGroupHandler getViewGroupHandler() {
        if (!this.myTag.isValid()) {
            return null;
        }
        return ViewHandlerManager.get(this.myTag.getProject()).findLayoutHandler(this, false);
    }

    public NlComponent createChild(@NotNull ViewEditor editor, @NotNull String fqcn, @Nullable NlComponent before, @NotNull InsertType insertType) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/model/NlComponent", "createChild"));
        }
        if (fqcn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqcn", "com/android/tools/idea/uibuilder/model/NlComponent", "createChild"));
        }
        if (insertType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertType", "com/android/tools/idea/uibuilder/model/NlComponent", "createChild"));
        }
        return this.myModel.createComponent(((ViewEditorImpl)editor).getScreenView(), fqcn, this, before, insertType);
    }

    private static boolean viewNeedsPackage(String fqcn) {
        return !fqcn.startsWith("android.widget.") && !fqcn.startsWith("android.view.") && !fqcn.startsWith("android.webkit.");
    }

    @NotNull
    public static String viewClassToTag(@NotNull String fqcn) {
        if (fqcn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqcn", "com/android/tools/idea/uibuilder/model/NlComponent", "viewClassToTag"));
        }
        if (!NlComponent.viewNeedsPackage(fqcn)) {
            String string = fqcn.substring(fqcn.lastIndexOf(46) + 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlComponent", "viewClassToTag"));
            }
            return string;
        }
        String string = fqcn;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/NlComponent", "viewClassToTag"));
        }
        return string;
    }

    @Nullable
    public static String extractId(@Nullable String str) {
        if (str == null) {
            return null;
        }
        int index = str.lastIndexOf("@id/");
        if (index != -1) {
            return str.substring(index + 4);
        }
        index = str.lastIndexOf("@+id/");
        if (index != -1) {
            return str.substring(index + 5);
        }
        return null;
    }

    public final void putClientProperty(Object key, Object value) {
        this.myClientProperties.put(key, value);
    }

    public final Object getClientProperty(Object key) {
        return this.myClientProperties.get(key);
    }

    public void addLiveChangeListener(ChangeListener listener) {
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void removeLiveChangeListener(ChangeListener listener) {
        this.myListeners.remove(listener);
    }

    public void fireLiveChangeEvent() {
        this.myListeners.forEach(listener -> listener.stateChanged(this.myChangeEvent));
    }
}

