/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.rendering.ImageUtils;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DependencyManager {
    private final Project myProject;
    private final Set<String> myMissingLibraries;
    private Module myModule;
    private Palette myPalette;

    public DependencyManager(@NotNull Project project, @NotNull JComponent paletteUI, @NotNull Disposable parentDisposable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/palette/DependencyManager", "<init>"));
        }
        if (paletteUI == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paletteUI", "com/android/tools/idea/uibuilder/palette/DependencyManager", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/android/tools/idea/uibuilder/palette/DependencyManager", "<init>"));
        }
        this.myProject = project;
        this.myMissingLibraries = new HashSet<String>();
        this.registerDependencyUpdates(paletteUI, parentDisposable);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/DependencyManager", "getProject"));
        }
        return project;
    }

    public void setPalette(@NotNull Palette palette, @NotNull Module module) {
        if (palette == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "palette", "com/android/tools/idea/uibuilder/palette/DependencyManager", "setPalette"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/uibuilder/palette/DependencyManager", "setPalette"));
        }
        this.myPalette = palette;
        this.myModule = module;
        this.checkForNewMissingDependencies();
    }

    public boolean needsLibraryLoad(@NotNull Palette.Item item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/palette/DependencyManager", "needsLibraryLoad"));
        }
        return this.myMissingLibraries.contains(item.getGradleCoordinateId());
    }

    public boolean ensureLibraryIsIncluded(@NotNull Palette.Item item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/palette/DependencyManager", "ensureLibraryIsIncluded"));
        }
        String coordinateId = item.getGradleCoordinateId();
        assert (coordinateId != null);
        assert (this.myModule != null);
        GradleDependencyManager manager = GradleDependencyManager.getInstance(this.myProject);
        return manager.ensureLibraryIsIncluded(this.myModule, DependencyManager.toGradleCoordinatesFromIds(Collections.singletonList(coordinateId)), null);
    }

    @NotNull
    public Icon createItemIcon(@NotNull Palette.Item item, @NotNull Component componentContext) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/palette/DependencyManager", "createItemIcon"));
        }
        if (componentContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentContext", "com/android/tools/idea/uibuilder/palette/DependencyManager", "createItemIcon"));
        }
        Icon icon = this.createItemIcon(item, item.getIcon(), AndroidIcons.NeleIcons.Download, componentContext);
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/DependencyManager", "createItemIcon"));
        }
        return icon;
    }

    @NotNull
    public Icon createLargeItemIcon(@NotNull Palette.Item item, @NotNull Component componentContext) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/palette/DependencyManager", "createLargeItemIcon"));
        }
        if (componentContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentContext", "com/android/tools/idea/uibuilder/palette/DependencyManager", "createLargeItemIcon"));
        }
        Icon icon = this.createItemIcon(item, item.getLargeIcon(), AndroidIcons.NeleIcons.DownloadLarge, componentContext);
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/DependencyManager", "createLargeItemIcon"));
        }
        return icon;
    }

    @NotNull
    private Icon createItemIcon(@NotNull Palette.Item item, @NotNull Icon icon, @NotNull Icon download, @NotNull Component componentContext) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/uibuilder/palette/DependencyManager", "createItemIcon"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/idea/uibuilder/palette/DependencyManager", "createItemIcon"));
        }
        if (download == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "download", "com/android/tools/idea/uibuilder/palette/DependencyManager", "createItemIcon"));
        }
        if (componentContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentContext", "com/android/tools/idea/uibuilder/palette/DependencyManager", "createItemIcon"));
        }
        if (!this.needsLibraryLoad(item)) {
            Icon icon2 = icon;
            if (icon2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/DependencyManager", "createItemIcon"));
            }
            return icon2;
        }
        BufferedImage image = UIUtil.createImage((int)icon.getIconWidth(), (int)icon.getIconHeight(), (int)2);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        icon.paintIcon(componentContext, g2, 0, 0);
        int x = icon.getIconWidth() - download.getIconWidth();
        int y = icon.getIconHeight() - download.getIconHeight();
        download.paintIcon(componentContext, g2, x, y);
        g2.dispose();
        JBImageIcon jBImageIcon = new JBImageIcon((Image)(UIUtil.isRetina() ? ImageUtils.convertToRetinaIgnoringFailures(image) : image));
        if (jBImageIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/DependencyManager", "createItemIcon"));
        }
        return jBImageIcon;
    }

    private boolean checkForNewMissingDependencies() {
        List<GradleCoordinate> coordinates;
        GradleDependencyManager manager;
        Set<Object> missing = Collections.emptySet();
        if (this.myModule != null && this.myMissingLibraries.equals(missing = DependencyManager.fromGradleCoordinatesToIds((manager = GradleDependencyManager.getInstance(this.myProject)).findMissingDependencies(this.myModule, coordinates = DependencyManager.toGradleCoordinatesFromIds(this.myPalette.getGradleCoordinateIds()))))) {
            return false;
        }
        this.myMissingLibraries.clear();
        this.myMissingLibraries.addAll(missing);
        return true;
    }

    private void registerDependencyUpdates(final @NotNull JComponent paletteUI, @NotNull Disposable parentDisposable) {
        if (paletteUI == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paletteUI", "com/android/tools/idea/uibuilder/palette/DependencyManager", "registerDependencyUpdates"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/android/tools/idea/uibuilder/palette/DependencyManager", "registerDependencyUpdates"));
        }
        GradleSyncState.subscribe(this.myProject, new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/palette/DependencyManager$1", "syncSucceeded"));
                }
                if (DependencyManager.this.checkForNewMissingDependencies()) {
                    paletteUI.repaint();
                }
            }
        }, parentDisposable);
    }

    @NotNull
    private static Set<String> fromGradleCoordinatesToIds(@NotNull Collection<GradleCoordinate> coordinates) {
        if (coordinates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coordinates", "com/android/tools/idea/uibuilder/palette/DependencyManager", "fromGradleCoordinatesToIds"));
        }
        Set<String> set = coordinates.stream().map(GradleCoordinate::getId).filter(dependency -> dependency != null).collect(Collectors.toSet());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/DependencyManager", "fromGradleCoordinatesToIds"));
        }
        return set;
    }

    @NotNull
    private static List<GradleCoordinate> toGradleCoordinatesFromIds(@NotNull Collection<String> dependencies) {
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "com/android/tools/idea/uibuilder/palette/DependencyManager", "toGradleCoordinatesFromIds"));
        }
        List<GradleCoordinate> list = dependencies.stream().map(dependency -> GradleCoordinate.parseCoordinateString((String)(dependency + ":+"))).filter(coordinate -> coordinate != null).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/palette/DependencyManager", "toGradleCoordinatesFromIds"));
        }
        return list;
    }
}

