/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.property.NlPropertiesGrouper;
import com.android.tools.idea.uibuilder.property.NlPropertiesManager;
import com.android.tools.idea.uibuilder.property.NlPropertiesSorter;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.ViewAllPropertiesAction;
import com.android.tools.idea.uibuilder.property.editors.NlPropertyEditors;
import com.android.tools.idea.uibuilder.property.inspector.InspectorPanel;
import com.android.tools.idea.uibuilder.property.ptable.PTable;
import com.android.tools.idea.uibuilder.property.ptable.PTableGroupItem;
import com.android.tools.idea.uibuilder.property.ptable.PTableItem;
import com.android.tools.idea.uibuilder.property.ptable.PTableModel;
import com.android.util.PropertiesMap;
import com.google.common.collect.Table;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.RowFilter;
import javax.swing.event.HyperlinkEvent;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPropertiesPanel
extends JPanel
implements ViewAllPropertiesAction.Model,
DataProvider,
DeleteProvider,
CutProvider,
CopyProvider,
PasteProvider {
    private static final String CARD_ADVANCED = "table";
    private static final String CARD_DEFAULT = "default";
    private static final int VERTICAL_SCROLLING_UNIT_INCREMENT = 50;
    private static final int VERTICAL_SCROLLING_BLOCK_INCREMENT = 25;
    private final TableRowSorter<PTableModel> myRowSorter;
    private final MyFilter myFilter;
    private final PTable myTable;
    private final JPanel myTablePanel;
    private final PTableModel myModel;
    private final InspectorPanel myInspectorPanel;
    private final MyFocusTraversalPolicy myFocusTraversalPolicy;
    private final JPanel myCardPanel;
    private List<NlComponent> myComponents;
    private List<NlPropertyItem> myProperties;
    private boolean myAllPropertiesPanelVisible;

    public NlPropertiesPanel(@NotNull NlPropertiesManager propertiesManager, @NotNull Disposable parentDisposable) {
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "<init>"));
        }
        super(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(UIUtil.TRANSPARENT_COLOR);
        this.myRowSorter = new TableRowSorter();
        this.myFilter = new MyFilter();
        this.myModel = new PTableModel();
        this.myTable = new PTable(this.myModel);
        this.myTable.setEditorProvider(NlPropertyEditors.getInstance(propertiesManager.getProject()));
        this.myTable.getEmptyText().setText("No selected component");
        JComponent fewerPropertiesLink = this.createViewAllPropertiesLinkPanel(false);
        fewerPropertiesLink.setBorder(BorderFactory.createEmptyBorder(8, 4, 2, 0));
        this.myTablePanel = new JPanel(new BorderLayout());
        this.myTablePanel.setVisible(false);
        this.myTablePanel.setBackground(this.myTable.getBackground());
        this.myTablePanel.add((Component)((Object)this.myTable), "North");
        this.myTablePanel.add((Component)fewerPropertiesLink, "South");
        this.myInspectorPanel = new InspectorPanel(propertiesManager, parentDisposable, this.createViewAllPropertiesLinkPanel(true));
        this.myCardPanel = new JPanel((LayoutManager)new JBCardLayout());
        this.add((Component)this.myCardPanel, "Center");
        this.myCardPanel.add(CARD_DEFAULT, ScrollPaneFactory.createScrollPane((Component)this.myInspectorPanel, (int)20, (int)31));
        JScrollPane tableScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTablePanel);
        tableScrollPane.getVerticalScrollBar().setUnitIncrement(50);
        tableScrollPane.getVerticalScrollBar().setBlockIncrement(25);
        tableScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.myFocusTraversalPolicy = new MyFocusTraversalPolicy();
        this.myCardPanel.add(CARD_ADVANCED, tableScrollPane);
        this.myCardPanel.setFocusCycleRoot(true);
        this.myCardPanel.setFocusTraversalPolicy(this.myFocusTraversalPolicy);
        this.myComponents = Collections.emptyList();
        this.myProperties = Collections.emptyList();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this::scrollIntoView);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this::scrollIntoView);
    }

    public void setFilter(@NotNull String filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "setFilter"));
        }
        int selectedRow = this.myTable.getSelectedRow();
        PTableItem selectedItem = this.myTable.getSelectedItem();
        if (filter.isEmpty()) {
            this.myTable.setRowSorter(null);
        } else {
            this.myFilter.setPattern(filter);
            this.myRowSorter.setModel(this.myModel);
            this.myRowSorter.setRowFilter(this.myFilter);
            this.myRowSorter.setSortKeys(null);
            this.myTable.setRowSorter(this.myRowSorter);
        }
        this.myTable.restoreSelection(selectedRow, selectedItem);
        this.myInspectorPanel.setFilter(filter);
    }

    public void activatePropertySheet() {
        this.setAllPropertiesPanelVisible(true);
    }

    public void activateInspector() {
        this.setAllPropertiesPanelVisible(false);
    }

    public void setItems(@NotNull List<NlComponent> components, @NotNull Table<String, String, NlPropertyItem> properties, @NotNull NlPropertiesManager propertiesManager) {
        List<PTableItem> groupedProperties;
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "setItems"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "setItems"));
        }
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "setItems"));
        }
        this.myComponents = components;
        this.myProperties = NlPropertiesPanel.extractPropertiesForTable(properties);
        if (components.isEmpty()) {
            groupedProperties = Collections.emptyList();
        } else {
            List<NlPropertyItem> sortedProperties = new NlPropertiesSorter().sort(this.myProperties, components);
            groupedProperties = new NlPropertiesGrouper().group(sortedProperties, components);
        }
        if (this.myTable.isEditing()) {
            this.myTable.removeEditor();
        }
        int selectedRow = this.myTable.getSelectedRow();
        PTableItem selectedItem = this.myTable.getSelectedItem();
        this.myModel.setItems(groupedProperties);
        if (this.myTable.getRowCount() > 0) {
            this.myTable.restoreSelection(selectedRow, selectedItem);
        }
        this.updateDefaultProperties(propertiesManager);
        this.myInspectorPanel.setComponent(components, properties, propertiesManager);
        this.myTablePanel.setVisible(!groupedProperties.isEmpty());
    }

    @NotNull
    private static List<NlPropertyItem> extractPropertiesForTable(@NotNull Table<String, String, NlPropertyItem> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "extractPropertiesForTable"));
        }
        Map androidProperties = properties.row((Object)"http://schemas.android.com/apk/res/android");
        Map autoProperties = properties.row((Object)"http://schemas.android.com/apk/res-auto");
        Map designProperties = properties.row((Object)"http://schemas.android.com/tools");
        Map bareProperties = properties.row((Object)"");
        ArrayList<NlPropertyItem> result = new ArrayList<NlPropertyItem>(properties.size());
        result.addAll(autoProperties.values());
        for (Map.Entry entry : androidProperties.entrySet()) {
            if (autoProperties.containsKey(entry.getKey())) continue;
            result.add((NlPropertyItem)entry.getValue());
        }
        result.addAll(designProperties.values());
        result.addAll(bareProperties.values());
        ArrayList<NlPropertyItem> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "extractPropertiesForTable"));
        }
        return arrayList;
    }

    public void modelRendered(@NotNull NlPropertiesManager propertiesManager) {
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "modelRendered"));
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (propertiesManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "lambda$modelRendered$0"));
            }
            this.updateDefaultProperties(propertiesManager);
            this.myInspectorPanel.refresh();
        });
    }

    private void updateDefaultProperties(@NotNull NlPropertiesManager propertiesManager) {
        if (propertiesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertiesManager", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "updateDefaultProperties"));
        }
        if (this.myComponents.isEmpty() || this.myProperties.isEmpty()) {
            return;
        }
        PropertiesMap defaultValues = propertiesManager.getDefaultProperties(this.myComponents);
        if (defaultValues.isEmpty()) {
            return;
        }
        for (NlPropertyItem property : this.myProperties) {
            property.setDefaultValue(NlPropertiesPanel.getDefaultProperty(defaultValues, property));
        }
    }

    @Nullable
    private static PropertiesMap.Property getDefaultProperty(@NotNull PropertiesMap defaultValues, @NotNull NlProperty property) {
        if (defaultValues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValues", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "getDefaultProperty"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "getDefaultProperty"));
        }
        if ("http://schemas.android.com/apk/res/android".equals(property.getNamespace())) {
            PropertiesMap.Property defaultValue = (PropertiesMap.Property)defaultValues.get((Object)("android:" + property.getName()));
            if (defaultValue != null) {
                return defaultValue;
            }
            return (PropertiesMap.Property)defaultValues.get((Object)("@android:" + property.getName()));
        }
        return (PropertiesMap.Property)defaultValues.get((Object)property.getName());
    }

    @NotNull
    private JComponent createViewAllPropertiesLinkPanel(boolean viewAllProperties) {
        HyperlinkLabel textLink = new HyperlinkLabel();
        textLink.setHyperlinkText(viewAllProperties ? "View all properties" : "View fewer properties");
        textLink.addHyperlinkListener(event -> this.setAllPropertiesPanelVisible(event, viewAllProperties));
        HyperlinkLabel iconLink = new HyperlinkLabel();
        iconLink.setIcon(AndroidIcons.NeleIcons.ToggleProperties);
        iconLink.setFocusable(false);
        iconLink.setUseIconAsLink(true);
        iconLink.addHyperlinkListener(event -> this.setAllPropertiesPanelVisible(event, viewAllProperties));
        JPanel linkPanel = new JPanel(new FlowLayout(0, 0, 0));
        linkPanel.setOpaque(false);
        linkPanel.add((Component)textLink);
        linkPanel.add((Component)iconLink);
        JPanel jPanel = linkPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "createViewAllPropertiesLinkPanel"));
        }
        return jPanel;
    }

    private void setAllPropertiesPanelVisible(@NotNull HyperlinkEvent event, boolean viewAllProperties) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "setAllPropertiesPanelVisible"));
        }
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.setAllPropertiesPanelVisible(viewAllProperties);
        }
    }

    @Override
    public boolean isAllPropertiesPanelVisible() {
        return this.myAllPropertiesPanelVisible;
    }

    @Override
    public void setAllPropertiesPanelVisible(boolean viewAllProperties) {
        this.myAllPropertiesPanelVisible = viewAllProperties;
        JBCardLayout cardLayout = (JBCardLayout)this.myCardPanel.getLayout();
        String name = viewAllProperties ? CARD_ADVANCED : CARD_DEFAULT;
        Object next = viewAllProperties ? this.myTable : this.myInspectorPanel;
        cardLayout.swipe((Container)this.myCardPanel, name, JBCardLayout.SwipeDirection.AUTO, ((Component)next)::requestFocus);
    }

    public boolean activatePreferredEditor(@NotNull String propertyName, boolean afterload) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "activatePreferredEditor"));
        }
        if (this.isAllPropertiesPanelVisible()) {
            this.setAllPropertiesPanelVisible(false);
        }
        return this.myInspectorPanel.activatePreferredEditor(propertyName, afterload);
    }

    private void scrollIntoView(@NotNull PropertyChangeEvent event) {
        Component newFocusedComponent;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "scrollIntoView"));
        }
        if (event.getNewValue() instanceof Component && "focusOwner".equals(event.getPropertyName()) && this.isAncestorOf(newFocusedComponent = (Component)event.getNewValue()) && newFocusedComponent.getParent() instanceof JComponent && this.myFocusTraversalPolicy.isLastFocusRecipient(newFocusedComponent)) {
            JComponent parent1 = (JComponent)newFocusedComponent.getParent();
            Rectangle bounds = newFocusedComponent.getBounds();
            if (newFocusedComponent == this.myTable) {
                bounds = this.myTable.getCellRect(this.myTable.getSelectedRow(), 1, true);
                bounds.x = 0;
            }
            parent1.scrollRectToVisible(bounds);
        }
    }

    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this;
        }
        return null;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "isCopyEnabled"));
        }
        return false;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "isCopyVisible"));
        }
        return false;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "performCopy"));
        }
    }

    public boolean isCutEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "isCutEnabled"));
        }
        return false;
    }

    public boolean isCutVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "isCutVisible"));
        }
        return false;
    }

    public void performCut(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "performCut"));
        }
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "canDeleteElement"));
        }
        return false;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "deleteElement"));
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "isPastePossible"));
        }
        return false;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "isPasteEnabled"));
        }
        return false;
    }

    public void performPaste(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel", "performPaste"));
        }
    }

    public PTable getTable() {
        return this.myTable;
    }

    private static class MyFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private Component myLastFocusRecipient;

        private MyFocusTraversalPolicy() {
        }

        private boolean isLastFocusRecipient(@NotNull Component component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel$MyFocusTraversalPolicy", "isLastFocusRecipient"));
            }
            boolean isLastRecipient = component == this.myLastFocusRecipient;
            this.myLastFocusRecipient = null;
            return isLastRecipient;
        }

        @Override
        protected boolean accept(@NotNull Component component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel$MyFocusTraversalPolicy", "accept"));
            }
            if (!super.accept(component)) {
                return false;
            }
            this.myLastFocusRecipient = component;
            return true;
        }
    }

    static class MyFilter
    extends RowFilter<PTableModel, Integer> {
        private final SpeedSearchComparator myComparator = new SpeedSearchComparator(false);
        private String myPattern;

        MyFilter() {
        }

        void setPattern(@NotNull String pattern) {
            if (pattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel$MyFilter", "setPattern"));
            }
            this.myPattern = pattern;
        }

        @Override
        public boolean include(RowFilter.Entry<? extends PTableModel, ? extends Integer> entry) {
            PTableItem item = (PTableItem)entry.getValue(0);
            if (this.isMatch(item.getName())) {
                return true;
            }
            if (item.getParent() != null && this.isMatch(item.getParent().getName())) {
                return true;
            }
            if (!(item instanceof PTableGroupItem)) {
                return false;
            }
            PTableGroupItem group = (PTableGroupItem)item;
            for (PTableItem child : group.getChildren()) {
                if (!this.isMatch(child.getName())) continue;
                return true;
            }
            return false;
        }

        private boolean isMatch(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/uibuilder/property/NlPropertiesPanel$MyFilter", "isMatch"));
            }
            return this.myComparator.matchingFragments(this.myPattern, text) != null;
        }
    }
}

