/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene;

import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutHandler;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.scene.Scene;
import com.android.tools.idea.uibuilder.scene.SceneComponent;
import com.android.tools.idea.uibuilder.scene.target.DragDndTarget;
import com.android.tools.idea.uibuilder.scene.target.Target;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SceneDragHandler
extends DragHandler {
    private NlComponent myComponent;

    public SceneDragHandler(@NotNull ViewEditor editor, @NotNull ConstraintLayoutHandler constraintLayoutHandler, @NotNull NlComponent layout, @NotNull List<NlComponent> components, DragType type) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/scene/SceneDragHandler", "<init>"));
        }
        if (constraintLayoutHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintLayoutHandler", "com/android/tools/idea/uibuilder/scene/SceneDragHandler", "<init>"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/android/tools/idea/uibuilder/scene/SceneDragHandler", "<init>"));
        }
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/uibuilder/scene/SceneDragHandler", "<init>"));
        }
        super(editor, constraintLayoutHandler, layout, components, type);
        if (components.size() == 1) {
            this.myComponent = components.get(0);
            Scene scene = ((ViewEditorImpl)editor).getScreenView().getScene();
            scene.setDnDComponent(this.myComponent);
        }
    }

    @Override
    public void start(int x, int y, int modifiers) {
        super.start(x, y, modifiers);
        if (this.myComponent == null) {
            return;
        }
        Scene scene = ((ViewEditorImpl)this.editor).getScreenView().getScene();
        scene.needsRebuildList();
        SceneComponent component = scene.getSceneComponent(this.myComponent);
        ArrayList<Target> targets = component.getTargets();
        int dx = x - this.myComponent.w / 2;
        int dy = y - this.myComponent.h / 2;
        for (int i = 0; i < targets.size(); ++i) {
            if (!(targets.get(i) instanceof DragDndTarget)) continue;
            DragDndTarget target = (DragDndTarget)targets.get(i);
            target.mouseDown(scene.pxToDp(dx), scene.pxToDp(dy));
            break;
        }
    }

    @Override
    @Nullable
    public String update(int x, int y, int modifiers) {
        String result = super.update(x, y, modifiers);
        if (this.myComponent == null) {
            return "undefined";
        }
        Scene scene = ((ViewEditorImpl)this.editor).getScreenView().getScene();
        SceneComponent component = scene.getSceneComponent(this.myComponent);
        int dx = x - this.myComponent.w / 2;
        int dy = y - this.myComponent.h / 2;
        this.myComponent.x = dx;
        this.myComponent.y = dy;
        if (component != null) {
            ArrayList<Target> targets = component.getTargets();
            for (int i = 0; i < targets.size(); ++i) {
                if (!(targets.get(i) instanceof DragDndTarget)) continue;
                DragDndTarget target = (DragDndTarget)targets.get(i);
                target.mouseDrag(scene.pxToDp(dx), scene.pxToDp(dy), target);
                break;
            }
        }
        scene.checkRequestLayoutStatus();
        return result;
    }

    @Override
    public void cancel() {
        Scene scene = ((ViewEditorImpl)this.editor).getScreenView().getScene();
        scene.setDnDComponent(null);
    }

    @Override
    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        if (insertType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertType", "com/android/tools/idea/uibuilder/scene/SceneDragHandler", "commit"));
        }
        Scene scene = ((ViewEditorImpl)this.editor).getScreenView().getScene();
        if (this.myComponent != null) {
            NlComponent nlComponent = (NlComponent)this.components.get(0);
            NlComponent root = nlComponent.getRoot();
            root.ensureNamespace("app", "http://schemas.android.com/apk/res-auto");
            SceneComponent component = scene.getSceneComponent(this.myComponent);
            if (component != null) {
                ArrayList<Target> targets = component.getTargets();
                int dx = x - this.myComponent.w / 2;
                int dy = y - this.myComponent.h / 2;
                for (int i = 0; i < targets.size(); ++i) {
                    if (!(targets.get(i) instanceof DragDndTarget)) continue;
                    DragDndTarget target = (DragDndTarget)targets.get(i);
                    target.mouseRelease(scene.pxToDp(dx), scene.pxToDp(dy), nlComponent);
                    break;
                }
            }
        }
        this.insertComponents(-1, insertType);
        scene.setDnDComponent(null);
        scene.checkRequestLayoutStatus();
    }

    @Override
    public void paint(@NotNull NlGraphics graphics) {
        if (graphics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphics", "com/android/tools/idea/uibuilder/scene/SceneDragHandler", "paint"));
        }
    }
}

