/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.draw;

import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.decorator.ButtonDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.CheckBoxDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.ImageViewDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.ProgressBarDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.RadioButtonDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.SeekBarDecorator;
import com.android.tools.idea.uibuilder.scene.decorator.SwitchDecorator;
import com.android.tools.idea.uibuilder.scene.draw.DrawAnchor;
import com.android.tools.idea.uibuilder.scene.draw.DrawCommand;
import com.android.tools.idea.uibuilder.scene.draw.DrawComponentBackground;
import com.android.tools.idea.uibuilder.scene.draw.DrawComponentFrame;
import com.android.tools.idea.uibuilder.scene.draw.DrawConnection;
import com.android.tools.idea.uibuilder.scene.draw.DrawConnectionUtils;
import com.android.tools.idea.uibuilder.scene.draw.DrawResize;
import com.android.tools.idea.uibuilder.scene.draw.DrawTextRegion;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class DisplayList {
    private static final boolean DEBUG = false;
    private ArrayList<DrawCommand> myCommands = new ArrayList();
    static HashMap<String, Constructor<? extends DrawCommand>> ourBuildMap = new HashMap();

    public void clear() {
        this.myCommands.clear();
    }

    public ArrayList<DrawCommand> getCommands() {
        return this.myCommands;
    }

    public void add(DrawCommand cmd) {
        this.myCommands.add(cmd);
    }

    public UNClip addClip(SceneContext transform, Rectangle r) {
        int l = transform.getSwingX(r.x);
        int t = transform.getSwingY(r.y);
        int w = transform.getSwingDimension(r.width);
        int h = transform.getSwingDimension(r.height);
        Clip c = new Clip(l, t, w, h);
        this.myCommands.add(c);
        return new UNClip(c);
    }

    public void addRect(SceneContext transform, Rectangle r, Color color) {
        int l = transform.getSwingX(r.x);
        int t = transform.getSwingY(r.y);
        int w = transform.getSwingDimension(r.width);
        int h = transform.getSwingDimension(r.height);
        this.myCommands.add(new Rect(l, t, w, h, color));
    }

    public void addRect(SceneContext transform, float left, float top, float right, float bottom, Color color) {
        int l = transform.getSwingX(left);
        int t = transform.getSwingY(top);
        int w = transform.getSwingDimension(right - left);
        int h = transform.getSwingDimension(bottom - top);
        this.add(new Rect(l, t, w, h, color));
    }

    public void addConnection(SceneContext transform, float x1, float y1, float x2, float y2, int direction) {
        int sx1 = transform.getSwingX(x1);
        int sy1 = transform.getSwingY(y1);
        int sx2 = transform.getSwingX(x2);
        int sy2 = transform.getSwingY(y2);
        this.add(new Connection(sx1, sy1, sx2, sy2, direction));
    }

    public void addLine(SceneContext transform, float x1, float y1, float x2, float y2, Color color) {
        this.add(new Line(transform, x1, y1, x2, y2, color));
    }

    public void paint(Graphics2D g2, SceneContext sceneContext) {
        int count = this.myCommands.size();
        if (count == 0) {
            return;
        }
        Graphics2D g = (Graphics2D)g2.create();
        DrawCommand[] array = this.myCommands.toArray(new DrawCommand[this.myCommands.size()]);
        CommandSet set = new CommandSet(array, 0, array.length - 1);
        set.sort();
        set.paint(g, sceneContext);
        g.dispose();
    }

    public String generateSortedDisplayList(SceneContext sceneContext) {
        DrawCommand[] array = this.myCommands.toArray(new DrawCommand[this.myCommands.size()]);
        CommandSet set = new CommandSet(array, 0, array.length - 1);
        set.sort();
        return set.serialize();
    }

    public String serialize() {
        String str = "";
        int count = this.myCommands.size();
        for (int i = 0; i < count; ++i) {
            DrawCommand command = this.myCommands.get(i);
            str = str + command.serialize() + "\n";
        }
        return str;
    }

    public static void addListElementConstructor(Class<? extends DrawCommand> c) {
        try {
            ourBuildMap.put(c.getSimpleName(), c.getConstructor(String.class));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    public static void addListElementConstructor(String cmd, Constructor<? extends DrawCommand> constructor) {
        ourBuildMap.put(cmd, constructor);
    }

    private static DrawCommand get(String cmd, String args) {
        try {
            return ourBuildMap.get(cmd).newInstance(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DisplayList getDisplayList(String str) {
        DisplayList list = new DisplayList();
        String[] sp = str.split("\n");
        DrawCommand drawCommand = null;
        Clip lastClip = null;
        for (int i = 0; i < sp.length; ++i) {
            String args;
            String cmd;
            String s = sp[i];
            if (s.indexOf(44) > 0) {
                cmd = s.substring(0, s.indexOf(","));
                args = s.substring(s.indexOf(",") + 1);
            } else {
                cmd = s;
                args = "";
            }
            drawCommand = DisplayList.get(cmd, args);
            list.add(drawCommand);
            if (drawCommand instanceof Clip) {
                lastClip = (Clip)drawCommand;
            }
            if (!(drawCommand instanceof UNClip)) continue;
            UNClip unclip = (UNClip)drawCommand;
            unclip.setClip(lastClip);
        }
        return list;
    }

    static {
        try {
            ourBuildMap.put("Connection", Connection.class.getConstructor(String.class));
            ourBuildMap.put("Rect", Rect.class.getConstructor(String.class));
            ourBuildMap.put("Clip", Clip.class.getConstructor(String.class));
            ourBuildMap.put("UNClip", UNClip.class.getConstructor(String.class));
            ourBuildMap.put("Line", Line.class.getConstructor(String.class));
            ourBuildMap.put("DrawConnection", DrawConnection.class.getConstructor(String.class));
            DisplayList.addListElementConstructor(DrawResize.class);
            DisplayList.addListElementConstructor(DrawAnchor.class);
            DisplayList.addListElementConstructor(DrawComponentBackground.class);
            DisplayList.addListElementConstructor(DrawComponentFrame.class);
            DisplayList.addListElementConstructor(ProgressBarDecorator.DrawProgressBar.class);
            DisplayList.addListElementConstructor(ButtonDecorator.DrawButton.class);
            DisplayList.addListElementConstructor(DrawTextRegion.class);
            DisplayList.addListElementConstructor(ImageViewDecorator.DrawImageView.class);
            DisplayList.addListElementConstructor(CheckBoxDecorator.DrawCheckbox.class);
            DisplayList.addListElementConstructor(RadioButtonDecorator.DrawRadioButton.class);
            DisplayList.addListElementConstructor(SeekBarDecorator.DrawSeekBar.class);
            DisplayList.addListElementConstructor(SwitchDecorator.DrawSwitch.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class CommandSet
    implements DrawCommand {
        private ArrayList<DrawCommand> myCommands = new ArrayList();

        public CommandSet(DrawCommand[] commands, int start, int end) {
            if (commands.length == 0) {
                return;
            }
            int first = this.findFirstClip(commands, start, end);
            int last = this.findLastUnClip(commands, start, end);
            if (first == start && last == end) {
                this.myCommands.add(commands[start]);
                for (int i = start + 1; i < end; ++i) {
                    DrawCommand cmd = commands[i];
                    if (cmd instanceof Clip) {
                        int n = this.findNextUnClip(commands, i + 1, end - 1);
                        cmd = new CommandSet(commands, i, n);
                        i = Math.max(n, i);
                    }
                    this.myCommands.add(cmd);
                }
                this.myCommands.add(commands[end]);
            } else if (first != -1 && last != -1) {
                int i;
                for (i = start; i < first; ++i) {
                    this.myCommands.add(commands[i]);
                }
                this.myCommands.add(new CommandSet(commands, first, last));
                for (i = last + 1; i <= end; ++i) {
                    this.myCommands.add(commands[i]);
                }
            } else {
                for (int i = start; i <= end; ++i) {
                    this.myCommands.add(commands[i]);
                }
            }
        }

        private int findFirstClip(DrawCommand[] commands, int start, int end) {
            for (int i = start; i < end; ++i) {
                if (!(commands[i] instanceof Clip)) continue;
                return i;
            }
            return -1;
        }

        private int findLastUnClip(DrawCommand[] commands, int start, int end) {
            for (int i = end; i > start; --i) {
                if (!(commands[i] instanceof UNClip)) continue;
                return i;
            }
            return -1;
        }

        private int findNextUnClip(DrawCommand[] commands, int start, int end) {
            int count = 0;
            for (int i = start; i <= end; ++i) {
                if (commands[i] instanceof Clip) {
                    ++count;
                }
                if (!(commands[i] instanceof UNClip)) continue;
                if (count == 0) {
                    return i;
                }
                --count;
            }
            return -1;
        }

        public void sort() {
            this.myCommands.sort((o1, o2) -> Integer.compare(o1.getLevel(), o2.getLevel()));
            this.myCommands.forEach(command -> {
                if (command instanceof CommandSet) {
                    ((CommandSet)command).sort();
                }
            });
        }

        @Override
        public int getLevel() {
            return 20;
        }

        @Override
        public void paint(Graphics2D g2, SceneContext sceneContext) {
            this.myCommands.forEach(command -> command.paint(g2, sceneContext));
        }

        public void print(String s) {
            this.myCommands.forEach(command -> {
                if (command instanceof CommandSet) {
                    ((CommandSet)command).print(s + ">");
                } else {
                    System.out.println(s + command.serialize());
                }
            });
        }

        @Override
        public String serialize() {
            String str = "";
            for (DrawCommand command : this.myCommands) {
                str = str + command.serialize() + "\n";
            }
            return str;
        }

        public int compareTo(@NotNull Object o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/android/tools/idea/uibuilder/scene/draw/DisplayList$CommandSet", "compareTo"));
            }
            return Integer.compare(this.getLevel(), ((DrawCommand)o).getLevel());
        }
    }

    static class Line
    implements DrawCommand {
        Color color;
        int x1;
        int y1;
        int x2;
        int y2;

        @Override
        public String serialize() {
            return "Line," + this.x1 + "," + this.y1 + "," + this.x2 + "," + this.y2 + "," + Integer.toHexString(this.color.getRGB());
        }

        @Override
        public int getLevel() {
            return 30;
        }

        public int compareTo(@NotNull Object o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/android/tools/idea/uibuilder/scene/draw/DisplayList$Line", "compareTo"));
            }
            return Integer.compare(this.getLevel(), ((DrawCommand)o).getLevel());
        }

        public Line(String s) {
            String[] sp = s.split(",");
            int c = 0;
            this.x1 = Integer.parseInt(sp[c++]);
            this.y1 = Integer.parseInt(sp[c++]);
            this.x2 = Integer.parseInt(sp[c++]);
            this.y2 = Integer.parseInt(sp[c++]);
            this.color = new Color((int)Long.parseLong(sp[c++], 16));
        }

        public Line(SceneContext transform, float x1, float y1, float x2, float y2, Color c) {
            this.x1 = transform.getSwingX(x1);
            this.y1 = transform.getSwingY(y1);
            this.x2 = transform.getSwingX(x2);
            this.y2 = transform.getSwingY(y2);
            this.color = c;
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            g.setColor(this.color);
            g.drawLine(this.x1, this.y1, this.x2, this.y2);
        }
    }

    public static class UNClip
    implements DrawCommand {
        Clip lastClip;

        @Override
        public String serialize() {
            return "UNClip";
        }

        @Override
        public int getLevel() {
            return 1000;
        }

        public int compareTo(@NotNull Object o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/android/tools/idea/uibuilder/scene/draw/DisplayList$UNClip", "compareTo"));
            }
            return Integer.compare(this.getLevel(), ((DrawCommand)o).getLevel());
        }

        public UNClip(String s) {
        }

        public UNClip(Clip s) {
            this.lastClip = s;
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            g.setClip(this.lastClip.getOriginalShape());
        }

        public void setClip(Clip clip) {
            this.lastClip = clip;
        }
    }

    static class Clip
    extends Rectangle
    implements DrawCommand {
        Shape myOriginal;

        @Override
        public String serialize() {
            return "Clip," + this.x + "," + this.y + "," + this.width + "," + this.height;
        }

        @Override
        public int getLevel() {
            return 0;
        }

        public int compareTo(@NotNull Object o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/android/tools/idea/uibuilder/scene/draw/DisplayList$Clip", "compareTo"));
            }
            return Integer.compare(this.getLevel(), ((DrawCommand)o).getLevel());
        }

        public Clip(String s) {
            String[] sp = s.split(",");
            int c = 0;
            this.x = Integer.parseInt(sp[c++]);
            this.y = Integer.parseInt(sp[c++]);
            this.width = Integer.parseInt(sp[c++]);
            this.height = Integer.parseInt(sp[c++]);
        }

        public Clip(int x, int y, int width, int height) {
            super(x, y, width, height);
        }

        public Shape getOriginalShape() {
            return this.myOriginal;
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            this.myOriginal = g.getClip();
            g.clipRect(this.x, this.y, this.width, this.height);
        }
    }

    static class Rect
    extends Rectangle
    implements DrawCommand {
        Color color;

        @Override
        public String serialize() {
            return "Rect," + this.x + "," + this.y + "," + this.width + "," + this.height + "," + Integer.toHexString(this.color.getRGB());
        }

        public Rect(String s) {
            String[] sp = s.split(",");
            int c = 0;
            this.x = Integer.parseInt(sp[c++]);
            this.y = Integer.parseInt(sp[c++]);
            this.width = Integer.parseInt(sp[c++]);
            this.height = Integer.parseInt(sp[c++]);
            this.color = new Color((int)Long.parseLong(sp[c++], 16));
        }

        public Rect(int x, int y, int width, int height, Color c) {
            super(x, y, width, height);
            this.color = c;
        }

        @Override
        public int getLevel() {
            return 20;
        }

        public int compareTo(@NotNull Object o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/android/tools/idea/uibuilder/scene/draw/DisplayList$Rect", "compareTo"));
            }
            return Integer.compare(this.getLevel(), ((DrawCommand)o).getLevel());
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            g.setColor(this.color);
            g.drawRect(this.x, this.y, this.width, this.height);
        }
    }

    static class Connection
    implements DrawCommand {
        int x1;
        int y1;
        int x2;
        int y2;
        int myDirection;
        private static final int DIR_LEFT = 0;
        private static final int DIR_TOP = 1;
        private static final int DIR_RIGHT = 2;
        private static final int DIR_BOTTOM = 3;
        private static final int DIR_BASELINE = 4;

        @Override
        public int getLevel() {
            return 50;
        }

        public int compareTo(@NotNull Object o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/android/tools/idea/uibuilder/scene/draw/DisplayList$Connection", "compareTo"));
            }
            return Integer.compare(this.getLevel(), ((DrawCommand)o).getLevel());
        }

        @Override
        public String serialize() {
            return "Connection," + this.x1 + "," + this.y1 + "," + this.x2 + "," + this.y2 + this.myDirection;
        }

        public Connection(String s) {
            String[] sp = s.split(",");
            int c = 0;
            this.x1 = Integer.parseInt(sp[c++]);
            this.y1 = Integer.parseInt(sp[c++]);
            this.x2 = Integer.parseInt(sp[c++]);
            this.y2 = Integer.parseInt(sp[c++]);
            this.myDirection = Integer.parseInt(sp[c++]);
        }

        public Connection(int x1, int y1, int x2, int y2, int direction) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.myDirection = direction;
        }

        @Override
        public void paint(Graphics2D g, SceneContext sceneContext) {
            g.setColor(sceneContext.getColorSet().getFrames());
            int start_dx = 0;
            int start_dy = 0;
            int end_dx = 0;
            int end_dy = 0;
            int scale = 20;
            int arrowDirection = 0;
            int arrowX = this.x2;
            int arrowY = this.y2;
            int arrowGap = 5;
            switch (this.myDirection) {
                case 0: {
                    start_dx = -scale;
                    end_dx = this.x2 > this.x1 ? -scale : scale;
                    arrowDirection = this.x2 > this.x1 ? 0 : 1;
                    arrowX += this.x2 > this.x1 ? -arrowGap : arrowGap;
                    break;
                }
                case 1: {
                    start_dy = -10;
                    end_dy = this.y2 > this.y1 ? -scale : scale;
                    arrowDirection = this.y2 > this.y1 ? 2 : 3;
                    arrowY += this.y2 > this.y1 ? -arrowGap : arrowGap;
                    break;
                }
                case 2: {
                    end_dx = this.x2 > this.x1 ? -scale : scale;
                    start_dx = scale;
                    arrowDirection = this.x2 > this.x1 ? 0 : 1;
                    arrowX += this.x2 > this.x1 ? -arrowGap : arrowGap;
                    break;
                }
                case 3: {
                    start_dy = scale;
                    end_dy = this.y2 > this.y1 ? -scale : scale;
                    arrowDirection = this.y2 > this.y1 ? 2 : 3;
                    arrowY += this.y2 > this.y1 ? -arrowGap : arrowGap;
                    break;
                }
                case 4: {
                    start_dy = -scale;
                    end_dy = scale;
                    arrowDirection = 3;
                    arrowY += this.y2 > this.y1 ? -arrowGap : arrowGap;
                }
            }
            GeneralPath path = new GeneralPath();
            path.moveTo(this.x1, this.y1);
            path.curveTo(this.x1 + start_dx, this.y1 + start_dy, this.x2 + end_dx, this.y2 + end_dy, arrowX, arrowY);
            g.draw(path);
            int[] xPoints = new int[3];
            int[] yPoints = new int[3];
            DrawConnectionUtils.getArrow(arrowDirection, this.x2, this.y2, xPoints, yPoints);
            g.fillPolygon(xPoints, yPoints, 3);
        }
    }
}

