/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.target;

import com.android.tools.idea.uibuilder.model.AttributesTransaction;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.scene.draw.DrawResize;
import com.android.tools.idea.uibuilder.scene.target.BaseTarget;
import com.android.tools.idea.uibuilder.scene.target.Target;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResizeTarget
extends BaseTarget {
    private final Type myType;
    private final int mySize = 2;
    private int mStartX1;
    private int mStartY1;
    private int mStartX2;
    private int mStartY2;

    public Type getType() {
        return this.myType;
    }

    public ResizeTarget(@NotNull Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/uibuilder/scene/target/ResizeTarget", "<init>"));
        }
        this.mySize = 2;
        this.myType = type;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        float d;
        if (sceneTransform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sceneTransform", "com/android/tools/idea/uibuilder/scene/target/ResizeTarget", "layout"));
        }
        float ratio = 1.0f / (float)sceneTransform.getScale();
        if (ratio > 2.0f) {
            ratio = 2.0f;
        }
        float size = 2.0f * ratio;
        float minWidth = 4.0f * size;
        float minHeight = 4.0f * size;
        if ((float)(r - l) < minWidth) {
            d = (minWidth - (float)(r - l)) / 2.0f;
            l = (int)((float)l - d);
            r = (int)((float)r + d);
        }
        if ((float)(b - t) < minHeight) {
            d = (minHeight - (float)(b - t)) / 2.0f;
            t = (int)((float)t - d);
            b = (int)((float)b + d);
        }
        int w = r - l;
        int h = b - t;
        int mw = l + w / 2;
        int mh = t + h / 2;
        switch (this.myType) {
            case LEFT_TOP: {
                this.myLeft = (float)l - size;
                this.myTop = (float)t - size;
                this.myRight = (float)l + size;
                this.myBottom = (float)t + size;
                break;
            }
            case LEFT_BOTTOM: {
                this.myLeft = (float)l - size;
                this.myTop = (float)b - size;
                this.myRight = (float)l + size;
                this.myBottom = (float)b + size;
                break;
            }
            case RIGHT_TOP: {
                this.myLeft = (float)r - size;
                this.myTop = (float)t - size;
                this.myRight = (float)r + size;
                this.myBottom = (float)t + size;
                break;
            }
            case RIGHT_BOTTOM: {
                this.myLeft = (float)r - size;
                this.myTop = (float)b - size;
                this.myRight = (float)r + size;
                this.myBottom = (float)b + size;
            }
        }
        return false;
    }

    @Override
    public int getMouseCursor() {
        switch (this.myType) {
            case LEFT_TOP: {
                return 6;
            }
            case LEFT_BOTTOM: {
                return 4;
            }
            case RIGHT_TOP: {
                return 7;
            }
            case RIGHT_BOTTOM: {
                return 5;
            }
        }
        return 0;
    }

    @Override
    public void render(@NotNull DisplayList list, SceneContext sceneContext) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/uibuilder/scene/target/ResizeTarget", "render"));
        }
        if (!this.myComponent.getScene().allowsTarget(this)) {
            return;
        }
        DrawResize.add(list, sceneContext, this.myLeft, this.myTop, this.myRight, this.myBottom, this.mIsOver ? 1 : 0);
    }

    private void updateWidth(@NotNull AttributesTransaction attributes, int w) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/uibuilder/scene/target/ResizeTarget", "updateWidth"));
        }
        if (w < 0) {
            w = 0;
        }
        String position = String.format("%ddp", w);
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", position);
    }

    private void updateHeight(@NotNull AttributesTransaction attributes, int h) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/uibuilder/scene/target/ResizeTarget", "updateHeight"));
        }
        if (h < 0) {
            h = 0;
        }
        String position = String.format("%ddp", h);
        attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", position);
    }

    private void updatePositionX(@NotNull AttributesTransaction attributes, int x) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/uibuilder/scene/target/ResizeTarget", "updatePositionX"));
        }
        String positionX = String.format("%ddp", x);
        attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", positionX);
    }

    private void updatePositionY(@NotNull AttributesTransaction attributes, int y) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/uibuilder/scene/target/ResizeTarget", "updatePositionY"));
        }
        String positionY = String.format("%ddp", y);
        attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", positionY);
    }

    private void updateAttributes(@NotNull AttributesTransaction attributes, int x, int y) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/uibuilder/scene/target/ResizeTarget", "updateAttributes"));
        }
        switch (this.myType) {
            case RIGHT_TOP: {
                this.updateWidth(attributes, x - this.mStartX1);
                this.updatePositionY(attributes, y - this.myComponent.getParent().getDrawY());
                this.updateHeight(attributes, this.mStartY2 - y);
                break;
            }
            case RIGHT_BOTTOM: {
                this.updateWidth(attributes, x - this.mStartX1);
                this.updateHeight(attributes, y - this.mStartY1);
                break;
            }
            case LEFT_TOP: {
                this.updatePositionX(attributes, x - this.myComponent.getParent().getDrawX());
                this.updateWidth(attributes, this.mStartX2 - x);
                this.updatePositionY(attributes, y - this.myComponent.getParent().getDrawY());
                this.updateHeight(attributes, this.mStartY2 - y);
                break;
            }
            case LEFT_BOTTOM: {
                this.updatePositionX(attributes, x - this.myComponent.getParent().getDrawX());
                this.updateWidth(attributes, this.mStartX2 - x);
                this.updateHeight(attributes, y - this.mStartY1);
            }
        }
    }

    @Override
    public int getPreferenceLevel() {
        return 50;
    }

    @Override
    public void mouseDown(int x, int y) {
        this.mStartX1 = this.myComponent.getDrawX();
        this.mStartY1 = this.myComponent.getDrawY();
        this.mStartX2 = this.myComponent.getDrawX() + this.myComponent.getDrawWidth();
        this.mStartY2 = this.myComponent.getDrawY() + this.myComponent.getDrawHeight();
    }

    @Override
    public void mouseDrag(int x, int y, @Nullable Target closestTarget) {
        NlComponent component = this.myComponent.getNlComponent();
        AttributesTransaction attributes = component.startAttributeTransaction();
        this.updateAttributes(attributes, x, y);
        attributes.apply();
        this.myComponent.getScene().needsLayout(1);
    }

    @Override
    public void mouseRelease(int x, int y, @Nullable Target closestTarget) {
        NlComponent component = this.myComponent.getNlComponent();
        final AttributesTransaction attributes = component.startAttributeTransaction();
        this.updateAttributes(attributes, x, y);
        attributes.apply();
        NlModel nlModel = component.getModel();
        Project project = nlModel.getProject();
        XmlFile file = nlModel.getFile();
        String label = "Constraint";
        WriteCommandAction action = new WriteCommandAction(project, label, new PsiFile[]{file}){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/uibuilder/scene/target/ResizeTarget$1", "run"));
                }
                attributes.commit();
            }
        };
        action.execute();
        this.myComponent.getScene().needsLayout(1);
    }

    public static enum Type {
        LEFT,
        LEFT_TOP,
        LEFT_BOTTOM,
        TOP,
        BOTTOM,
        RIGHT,
        RIGHT_TOP,
        RIGHT_BOTTOM;

    }
}

