/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.uibuilder.graphics.NlConstants;
import com.android.tools.idea.uibuilder.scene.Display;
import com.android.tools.idea.uibuilder.scene.SceneContext;
import com.android.tools.idea.uibuilder.surface.Layer;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class SceneLayer
extends Layer {
    private final ScreenView myScreenView;
    private final Dimension myScreenViewSize;
    private final Rectangle mySizeRectangle;
    private final Display myDisplay;
    private boolean myShowOnHover;
    private boolean myShowAlways;

    public SceneLayer(@NotNull ScreenView view, boolean showAlways) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/android/tools/idea/uibuilder/surface/SceneLayer", "<init>"));
        }
        this.myScreenViewSize = new Dimension();
        this.mySizeRectangle = new Rectangle();
        this.myDisplay = new Display();
        this.myShowOnHover = false;
        this.myShowAlways = true;
        this.myScreenView = view;
        this.myShowAlways = showAlways;
    }

    @Override
    public void paint(@NotNull Graphics2D g2) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/android/tools/idea/uibuilder/surface/SceneLayer", "paint"));
        }
        if (!this.myShowOnHover && !this.myShowAlways) {
            return;
        }
        Graphics2D g = (Graphics2D)g2.create();
        try {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.myScreenView.getSize(this.myScreenViewSize);
            this.mySizeRectangle.setBounds(this.myScreenView.getX(), this.myScreenView.getY(), this.myScreenViewSize.width, this.myScreenViewSize.height);
            Rectangle2D.intersect(this.mySizeRectangle, g.getClipBounds(), this.mySizeRectangle);
            if (this.mySizeRectangle.isEmpty()) {
                return;
            }
            if (this.myShowAlways) {
                g.setColor(NlConstants.BLUEPRINT_BG_COLOR);
                g.fillRect(this.mySizeRectangle.x, this.mySizeRectangle.y, this.mySizeRectangle.width, this.mySizeRectangle.height);
            }
            this.myDisplay.draw(SceneContext.get(this.myScreenView), g, this.myScreenView.getScene());
        }
        finally {
            g.dispose();
        }
    }

    public boolean isShowOnHover() {
        return this.myShowOnHover;
    }

    public void setShowOnHover(boolean value) {
        this.myShowOnHover = value;
    }

    public ScreenView getScreenView() {
        return this.myScreenView;
    }
}

