/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.sdklib.devices.Storage;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.welcome.config.FirstRunWizardMode;
import com.android.tools.idea.welcome.install.Haxm;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FirstRunWizardDefaults {
    public static final String HAXM_DOCUMENTATION_URL = "https://software.intel.com/android/articles/intel-hardware-accelerated-execution-manager";
    public static final String HAXM_WINDOWS_INSTALL_URL = "https://software.intel.com/android/articles/installation-instructions-for-intel-hardware-accelerated-execution-manager-windows";
    public static final String HAXM_MAC_INSTALL_URL = "https://software.intel.com/android/articles/installation-instructions-for-intel-hardware-accelerated-execution-manager-mac-os-x";
    public static final String KVM_LINUX_INSTALL_URL = "https://software.intel.com/blogs/2012/03/12/how-to-start-intel-hardware-assisted-virtualization-hypervisor-on-linux-to-speed-up-intel-android-x86-emulator";
    public static final JavaSdkVersion MIN_JDK_VERSION = JavaSdkVersion.JDK_1_7;

    private FirstRunWizardDefaults() {
    }

    public static int getRecommendedHaxmMemory(long memorySize) {
        long GB = Storage.Unit.GiB.getNumberOfBytes();
        long defaultMemory = memorySize > 4L * GB ? 2L * GB : (memorySize > 2L * GB ? GB : GB / 2L);
        return (int)(defaultMemory / Haxm.UI_UNITS.getNumberOfBytes());
    }

    @NotNull
    private static File getDefaultSdkLocation() {
        String path = System.getenv("ANDROID_HOME");
        if (Strings.isNullOrEmpty((String)path)) {
            String userHome = System.getProperty("user.home");
            if (SystemInfo.isWindows) {
                path = FileUtil.join((String[])new String[]{userHome, "AppData", "Local", "Android", "Sdk"});
            } else if (SystemInfo.isMac) {
                path = FileUtil.join((String[])new String[]{userHome, "Library", "Android", "sdk"});
            } else if (SystemInfo.isLinux) {
                path = FileUtil.join((String[])new String[]{userHome, "Android", "Sdk"});
            } else {
                Messages.showErrorDialog((String)"Your OS is not officially supported.\nYou can continue, but it is likely you will encounter further problems.", (String)"Unsupported OS");
                path = "";
            }
        }
        File file = new File(path);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/FirstRunWizardDefaults", "getDefaultSdkLocation"));
        }
        return file;
    }

    @NotNull
    public static File getInitialSdkLocation(@NotNull FirstRunWizardMode mode) {
        VirtualFile homeDirectory;
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/android/tools/idea/welcome/install/FirstRunWizardDefaults", "getInitialSdkLocation"));
        }
        File dest = mode.getSdkLocation();
        if (dest != null) {
            File file = dest;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/FirstRunWizardDefaults", "getInitialSdkLocation"));
            }
            return file;
        }
        List<Sdk> sdks = AndroidSdks.getInstance().getAllAndroidSdks();
        Sdk sdk = (Sdk)Iterables.getFirst(sdks, null);
        if (sdk != null && (homeDirectory = sdk.getHomeDirectory()) != null) {
            File file = VfsUtilCore.virtualToIoFile((VirtualFile)homeDirectory);
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/FirstRunWizardDefaults", "getInitialSdkLocation"));
            }
            return file;
        }
        File file = FirstRunWizardDefaults.getDefaultSdkLocation();
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/FirstRunWizardDefaults", "getInitialSdkLocation"));
        }
        return file;
    }
}

