/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApiVersionConverter
extends ResolvingConverter<String> {
    @NotNull
    public Collection<String> getVariants(ConvertContext context) {
        ArrayList<String> result = new ArrayList<String>(25);
        for (int i = 1; i <= 25; ++i) {
            if (i > 25) {
                result.add(SdkVersionInfo.getBuildCode((int)i));
                continue;
            }
            result.add(Integer.toString(i));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/converters/ApiVersionConverter", "getVariants"));
        }
        return arrayList;
    }

    @Nullable
    public LookupElement createLookupElement(String s) {
        AndroidVersion version = SdkVersionInfo.getVersion((String)s, null);
        if (version == null) {
            return null;
        }
        return PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)s).withTypeText(version.getApiString()), (double)version.getFeatureLevel());
    }

    @Nullable
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        return s;
    }

    @Nullable
    public String toString(@Nullable String s, ConvertContext context) {
        return s;
    }
}

