/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.beans;

import com.intellij.cdi.beans.AbstractCdiBeanDescriptor;
import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.manager.CdiManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import java.util.Set;

public abstract class ProducerBeanDescriptor<T extends PsiMember>
extends AbstractCdiBeanDescriptor<T> {
    private PsiMember myMember;

    protected ProducerBeanDescriptor(PsiMember member) {
        this.myMember = member;
    }

    @Override
    public PsiClass getDefaultDeploymentType() {
        Set<CdiBeanDescriptor> cdiBeanDescriptors;
        PsiClass psiClass = this.getAnnotatedItem().getContainingClass();
        if (psiClass != null && (cdiBeanDescriptors = CdiManager.getService(this.getModule()).resolveBeanByClass(psiClass, new PsiAnnotation[0])).size() == 1) {
            return cdiBeanDescriptors.iterator().next().getDeploymentType();
        }
        return this.getAnnotationClass("javax.enterprise.inject.deployment.Production");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProducerBeanDescriptor)) {
            return false;
        }
        ProducerBeanDescriptor that = (ProducerBeanDescriptor)o;
        return !(this.myMember != null ? !this.myMember.equals(that.myMember) : that.myMember != null);
    }

    public int hashCode() {
        return this.myMember != null ? this.myMember.hashCode() : 0;
    }
}

