/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.manager.CdiManager;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CdiInjectionPointsInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(PsiClass psiClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/highlighting/CdiInjectionPointsInspection", "checkClass"));
        }
        Set<InjectionPointDescriptor> injectionPoints = CdiInjectionUtils.getInjectionPoints(psiClass);
        for (InjectionPointDescriptor injectionPoint : injectionPoints) {
            if (!CdiInjectionPointsInspection.isInjectionPointDefinedInClass(psiClass, injectionPoint)) continue;
            CdiInjectionPointsInspection.checkInjectionPointAmbiguousDependency(psiClass, injectionPoint, holder);
            CdiInjectionPointsInspection.checkNewAnnotationInjectionPoint(injectionPoint, holder);
        }
    }

    private static boolean isInjectionPointDefinedInClass(@NotNull PsiClass psiClass, @NotNull InjectionPointDescriptor ip) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/highlighting/CdiInjectionPointsInspection", "isInjectionPointDefinedInClass"));
        }
        if (ip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ip", "com/intellij/cdi/highlighting/CdiInjectionPointsInspection", "isInjectionPointDefinedInClass"));
        }
        PsiModifierListOwner owner = ip.getOwner();
        return psiClass.equals(PsiTreeUtil.getParentOfType((PsiElement)owner, PsiClass.class));
    }

    private static void checkNewAnnotationInjectionPoint(InjectionPointDescriptor injectionPoint, ProblemsHolder holder) {
        PsiAnnotation newAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)injectionPoint.getOwner(), (String[])new String[]{"javax.enterprise.inject.New"});
        if (newAnnotation != null) {
            for (PsiAnnotation psiAnnotation : injectionPoint.getQualifierAnnotations()) {
                String s = psiAnnotation.getQualifiedName();
                if ("javax.inject.Named".equals(s) || "javax.enterprise.inject.New".equals(s)) continue;
                holder.registerProblem((PsiElement)newAnnotation, CdiInspectionBundle.message("CdiInspectionPointsInspection.new.annotion.with.other.qualifiers", new Object[0]), new LocalQuickFix[0]);
                break;
            }
        }
    }

    private static void checkInjectionPointAmbiguousDependency(@NotNull PsiClass psiClass, @NotNull InjectionPointDescriptor injectionPoint, ProblemsHolder holder) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/cdi/highlighting/CdiInjectionPointsInspection", "checkInjectionPointAmbiguousDependency"));
        }
        if (injectionPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectionPoint", "com/intellij/cdi/highlighting/CdiInjectionPointsInspection", "checkInjectionPointAmbiguousDependency"));
        }
        PsiType type = injectionPoint.getType();
        if (type != null) {
            String typeCanonicalText = type.getCanonicalText();
            if (typeCanonicalText.startsWith("javax.enterprise.event.Event")) {
                return;
            }
            if (typeCanonicalText.startsWith("javax.enterprise.inject.spi.InjectionPoint") && injectionPoint.getQualifierAnnotations().length == 0) {
                return;
            }
            for (String className : CdiManager.BUILD_IN_CLASSES) {
                if (!typeCanonicalText.equals(className)) continue;
                return;
            }
        }
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"javax.enterprise.inject.Instance")) {
            return;
        }
        PsiModifierListOwner owner = injectionPoint.getOwner();
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, (String)"javax.decorator.Delegate", (boolean)true)) {
            return;
        }
        Set<CdiBeanDescriptor> injectedBeans = CdiInjectionUtils.getInjectedBeans(injectionPoint);
        if (owner instanceof PsiVariable) {
            owner = ((PsiVariable)owner).getNameIdentifier();
        }
        if (owner == null) {
            return;
        }
        if (injectedBeans.size() == 0) {
            holder.registerProblem((PsiElement)owner, CdiInspectionBundle.message("CdiInspectionPointsInspection.unsatisfied.dependency", new Object[0]), new LocalQuickFix[0]);
        } else if (injectedBeans.size() > 1) {
            holder.registerProblem((PsiElement)owner, CdiInspectionBundle.message("CdiInspectionPointsInspection.ambiguous.dependency", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CdiInspectionBundle.message("inspection.name.ambiguous.dependencies", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiInjectionPointsInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("CdiInjectionPointsInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiInjectionPointsInspection", "getShortName"));
        }
        return "CdiInjectionPointsInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiInjectionPointsInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }
}

