/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiManagedBeanValidationUtils;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.hash.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CdiObservesInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(PsiClass psiClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/highlighting/CdiObservesInspection", "checkClass"));
        }
        Map<PsiMethod, Set<PsiParameter>> observesMethods = CdiObservesInspection.collectObserverMethods(psiClass);
        for (PsiMethod method : observesMethods.keySet()) {
            Set<PsiParameter> observesParameters = observesMethods.get(method);
            CdiObservesInspection.checkObservesMethod(holder, method, observesParameters);
            CdiObservesInspection.checkObservesParameter(holder, observesParameters);
        }
    }

    private static void checkObservesMethod(ProblemsHolder holder, PsiMethod method, Set<PsiParameter> observesParameters) {
        CdiObservesInspection.checkMultipleObservesParameters(holder, method, observesParameters);
        CdiObservesInspection.checkWrongAnnotatedParameter(method, holder, "javax.enterprise.inject.Disposes");
        CdiObservesInspection.checkWrongAnnotations(holder, method, "javax.enterprise.inject.Produces");
        CdiObservesInspection.checkWrongAnnotations(holder, method, "javax.inject.Inject");
    }

    private static void checkWrongAnnotations(ProblemsHolder holder, PsiMethod method, String anno) {
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)anno, (boolean)false)) {
            holder.registerProblem((PsiElement)method.getNameIdentifier(), CdiInspectionBundle.message("CdiObservesInspection.wrong.observe.method.annotation", anno), new LocalQuickFix[0]);
        }
    }

    private static void checkMultipleObservesParameters(ProblemsHolder holder, PsiMethod method, Set<PsiParameter> observesParameters) {
        if (observesParameters.size() > 1) {
            holder.registerProblem((PsiElement)method.getNameIdentifier(), CdiInspectionBundle.message("CdiObservesInspection.multiple.observes.parameters.not.allowed", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static void checkObservesParameter(ProblemsHolder holder, Set<PsiParameter> observesParameters) {
    }

    private static void checkWrongAnnotatedParameter(PsiMethod method, ProblemsHolder holder, String anno) {
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, (String)anno, (boolean)true)) continue;
            holder.registerProblem((PsiElement)method.getNameIdentifier(), CdiInspectionBundle.message("CdiObservesInspection.observer.method.with.wrong.parameters", anno), new LocalQuickFix[0]);
            break;
        }
    }

    private static void checkParameterizedType(ProblemsHolder holder, PsiParameter parameter) {
        PsiType type = parameter.getType();
        if (type instanceof PsiClassType && CdiManagedBeanValidationUtils.isParameterizedType(((PsiClassType)type).resolve())) {
            holder.registerProblem((PsiElement)parameter.getNameIdentifier(), CdiInspectionBundle.message("CdiObservesInspection.cannot.observes.parameterized.types", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @NotNull
    private static Map<PsiMethod, Set<PsiParameter>> collectObserverMethods(PsiClass psiClass) {
        HashMap observesMethods = new HashMap();
        for (PsiMethod psiMethod : psiClass.getMethods()) {
            for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, (String)"javax.enterprise.event.Observes", (boolean)false)) continue;
                if (observesMethods.get(psiMethod) == null) {
                    observesMethods.put(psiMethod, new HashSet());
                }
                ((Set)observesMethods.get(psiMethod)).add(psiParameter);
            }
        }
        HashMap hashMap = observesMethods;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiObservesInspection", "collectObserverMethods"));
        }
        return hashMap;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CdiInspectionBundle.message("inspection.name.observer.method.errors", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiObservesInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("CdiObservesInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiObservesInspection", "getShortName"));
        }
        return "CdiObservesInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/highlighting/CdiObservesInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }
}

