/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.codeInsight.GwtReferenceUtil;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.CreateCssClassLocalQuickFix;
import com.intellij.gwt.inspections.CreateLocalCssClassLocalQuickFix;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.references.GwtToCssClassReference;
import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GwtToCssClassReferencesInspection
extends BaseGwtInspection {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/inspections/GwtToCssClassReferencesInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/GwtToCssClassReferencesInspection", "checkFile"));
        }
        if (!GwtToCssClassReferencesInspection.shouldCheck((PsiElement)file)) {
            return null;
        }
        SmartList problems = new SmartList();
        if (file instanceof PsiJavaFile) {
            file.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((List)problems, manager, isOnTheFly){
                final /* synthetic */ List val$problems;
                final /* synthetic */ InspectionManager val$manager;
                final /* synthetic */ boolean val$isOnTheFly;
                {
                    this.val$problems = list;
                    this.val$manager = inspectionManager;
                    this.val$isOnTheFly = bl;
                }

                public void visitLiteralExpression(PsiLiteralExpression expression) {
                    GwtToCssClassReferencesInspection.checkReferences((PsiElement)expression, this.val$problems, this.val$manager, this.val$isOnTheFly);
                }

                public void visitReferenceExpression(PsiReferenceExpression expression) {
                }
            });
        } else if (file instanceof XmlFile && UiBinderUtil.isUiXmlFile((XmlFile)file)) {
            file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor((List)problems, manager, isOnTheFly){
                final /* synthetic */ List val$problems;
                final /* synthetic */ InspectionManager val$manager;
                final /* synthetic */ boolean val$isOnTheFly;
                {
                    this.val$problems = list;
                    this.val$manager = inspectionManager;
                    this.val$isOnTheFly = bl;
                }

                public void visitXmlAttributeValue(XmlAttributeValue value) {
                    GwtToCssClassReferencesInspection.checkReferences((PsiElement)value, this.val$problems, this.val$manager, this.val$isOnTheFly);
                }
            });
        }
        if (problems.isEmpty()) {
            return null;
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    private static void checkReferences(PsiElement element, List<ProblemDescriptor> problems, InspectionManager manager, boolean isOnTheFly) {
        for (PsiReference reference : element.getReferences()) {
            StylesheetFile file;
            GwtToCssClassReference cssRef;
            if (!(reference instanceof GwtToCssClassReference) || (cssRef = (GwtToCssClassReference)reference).multiResolve(false).length > 0) continue;
            SmartList fixesList = new SmartList();
            GwtModule module = GwtReferenceUtil.findGwtModule(reference.getElement());
            String className = cssRef.getValue();
            if (module != null && (file = GwtModulesManager.getInstance(element.getProject()).findPreferableCssFile(module)) != null && !className.contains(".")) {
                fixesList.add(new CreateCssClassLocalQuickFix(file, className));
            }
            if (element instanceof XmlAttributeValue) {
                fixesList.add(new CreateLocalCssClassLocalQuickFix(className));
            }
            LocalQuickFix[] fixes = fixesList.toArray(LocalQuickFix.EMPTY_ARRAY);
            problems.add(manager.createProblemDescriptor(element, reference.getRangeInElement(), GwtBundle.message("problem.description.unknown.css.class", className), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, isOnTheFly, fixes));
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.unresolved.references.to.css.classes.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtToCssClassReferencesInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("GWTStyleCheck" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtToCssClassReferencesInspection", "getShortName"));
        }
        return "GWTStyleCheck";
    }
}

