/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder.declarations;

import com.intellij.gwt.uiBinder.declarations.UiXmlVariableDeclaration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UiImportVariable
implements UiXmlVariableDeclaration {
    private final XmlTag myTag;
    private final String myClassName;
    private final String myFieldName;

    public UiImportVariable(@NotNull XmlTag tag, @NotNull String className, @NotNull String fieldName) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/gwt/uiBinder/declarations/UiImportVariable", "<init>"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/gwt/uiBinder/declarations/UiImportVariable", "<init>"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/gwt/uiBinder/declarations/UiImportVariable", "<init>"));
        }
        this.myTag = tag;
        this.myClassName = className;
        this.myFieldName = fieldName;
    }

    @NotNull
    static List<UiImportVariable> createElements(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/gwt/uiBinder/declarations/UiImportVariable", "createElements"));
        }
        String qualifiedFieldName = tag.getAttributeValue("field");
        if (qualifiedFieldName == null) {
            List<UiImportVariable> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/declarations/UiImportVariable", "createElements"));
            }
            return list;
        }
        String className = StringUtil.getPackageName((String)qualifiedFieldName);
        if (className.isEmpty()) {
            List<UiImportVariable> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/declarations/UiImportVariable", "createElements"));
            }
            return list;
        }
        String fieldName = StringUtil.getShortName((String)qualifiedFieldName);
        if (!fieldName.equals("*")) {
            List<UiImportVariable> list = Collections.singletonList(new UiImportVariable(tag, className, fieldName));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/declarations/UiImportVariable", "createElements"));
            }
            return list;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)tag.getProject()).findClass(className, tag.getResolveScope());
        if (psiClass == null) {
            List<UiImportVariable> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/declarations/UiImportVariable", "createElements"));
            }
            return list;
        }
        ArrayList<UiImportVariable> variables = new ArrayList<UiImportVariable>();
        for (PsiField field : psiClass.getFields()) {
            if (!field.hasModifierProperty("static") || !field.hasModifierProperty("public")) continue;
            variables.add(new UiImportVariable(tag, className, field.getName()));
        }
        ArrayList<UiImportVariable> arrayList = variables;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/declarations/UiImportVariable", "createElements"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    public String getVariableName() {
        return this.myFieldName;
    }

    @Override
    @Nullable
    public String getType() {
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myTag.getProject()).findClass(this.myClassName, this.myTag.getResolveScope());
        if (psiClass == null) {
            return null;
        }
        PsiField field = psiClass.findFieldByName(this.myFieldName, false);
        return field != null ? field.getType().getCanonicalText() : null;
    }

    @Override
    @Nullable
    public PsiType resolveType() {
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myTag.getProject()).findClass(this.myClassName, this.myTag.getResolveScope());
        if (psiClass == null) {
            return null;
        }
        PsiField field = psiClass.findFieldByName(this.myFieldName, false);
        return field != null ? field.getType() : null;
    }

    @Override
    @NotNull
    public XmlTag getTag() {
        XmlTag xmlTag = this.myTag;
        if (xmlTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/declarations/UiImportVariable", "getTag"));
        }
        return xmlTag;
    }
}

