/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.descriptor;

import com.intellij.util.ArrayUtil;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public enum CssContextType {
    ANY("any", "everywhere", true),
    NONE("none", "root of file", true),
    NONAME("noname", "regular ruleset", true),
    PAGE("@page", "@page", false),
    JQUERY("@jquery", "jquery selector", true),
    KEYFRAMES("@keyframes", "@keyframes", true),
    CHARSET("@charset", "@charset", true),
    MEDIA("@media", "@media", true),
    NAMESPACE("@namespace", "@namespace", true),
    FONTFACE("@font-face", "@font-face", false),
    VIEWPORT("@viewport", "@viewport", false),
    SUPPORTS("@supports", "@supports", false),
    PAGE_MARGIN("page-margin", "page margin rule", false),
    COLOR_PROFILE("@color-profile", "@color-profile", false),
    COUNTER_STYLE("@counter-style", "@counter-style", false),
    UNKNOWN("unknown", "unknown", false);

    public static final String[] PAGE_MARGIN_RULES;
    public static final Comparator<? super CssContextType> COMPARATOR;
    private final String myName;
    @NotNull
    private final String myPresentationName;
    public static final CssContextType[] EMPTY_ARRAY;
    private final boolean mySubsetOfAny;

    private CssContextType(String name, String presentationName, boolean isSubsetOfAny) {
        if (presentationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationName", "com/intellij/psi/css/descriptor/CssContextType", "<init>"));
        }
        this.myName = name;
        this.myPresentationName = presentationName;
        this.mySubsetOfAny = isSubsetOfAny;
    }

    @NotNull
    public static CssContextType fromString(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/psi/css/descriptor/CssContextType", "fromString"));
        }
        for (CssContextType type : CssContextType.values()) {
            if (!s.equals(type.getName())) continue;
            CssContextType cssContextType = type;
            if (cssContextType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/CssContextType", "fromString"));
            }
            return cssContextType;
        }
        if (ArrayUtil.contains((String)s, (String[])PAGE_MARGIN_RULES)) {
            CssContextType cssContextType = PAGE_MARGIN;
            if (cssContextType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/CssContextType", "fromString"));
            }
            return cssContextType;
        }
        throw new IllegalArgumentException("Unknown context type '" + s + "'");
    }

    private String getName() {
        return this.myName;
    }

    public boolean isSubsetOfAny() {
        return this.mySubsetOfAny;
    }

    @NotNull
    private String getPresentationName() {
        String string = this.myPresentationName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/CssContextType", "getPresentationName"));
        }
        return string;
    }

    @NotNull
    public String toString() {
        String string = this.getPresentationName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/descriptor/CssContextType", "toString"));
        }
        return string;
    }

    static {
        PAGE_MARGIN_RULES = new String[]{"@top-left-corner", "@top-left", "@top-center", "@top-right", "@top-right-corner", "@bottom-left-corner", "@bottom-left", "@bottom-center", "@bottom-right", "@bottom-right-corner", "@left-top", "@left-middle", "@left-bottom", "@right-top", "@right-middle", "@right-bottom"};
        COMPARATOR = (o1, o2) -> o2.getName().compareTo(o1.getName());
        EMPTY_ARRAY = new CssContextType[0];
    }
}

