/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.converters;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.webflow.model.xml.Action;
import com.intellij.spring.webflow.model.xml.WebflowNamedAction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionBeanMethodConverter
extends ResolvingConverter<PsiMethod> {
    @NotNull
    public Collection<? extends PsiMethod> getVariants(ConvertContext context) {
        WebflowNamedAction action = (WebflowNamedAction)context.getInvocationElement().getParentOfType(WebflowNamedAction.class, false);
        boolean isAction = context.getInvocationElement().getParentOfType(Action.class, false) != null;
        HashSet<PsiMethod> variants = new HashSet<PsiMethod>();
        ArrayList<String> addedMethodNames = new ArrayList<String>();
        for (PsiMethod psiMethod : ActionBeanMethodConverter.getAllMethods(action)) {
            if (addedMethodNames.contains(psiMethod.getName()) || !psiMethod.hasModifierProperty("public") || psiMethod.isConstructor() || psiMethod.getContainingClass() == null || "java.lang.Object".equals(psiMethod.getContainingClass().getQualifiedName()) || isAction && !ActionBeanMethodConverter.isActionBeanMethod(psiMethod)) continue;
            variants.add(psiMethod);
            addedMethodNames.add(psiMethod.getName());
        }
        HashSet<PsiMethod> hashSet = variants;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/ActionBeanMethodConverter", "getVariants"));
        }
        return hashSet;
    }

    private static boolean isActionBeanMethod(PsiMethod method) {
        PsiType returnType = method.getReturnType();
        return method.getParameterList().getParameters().length == 1 && "org.springframework.webflow.execution.RequestContext".equals(method.getParameterList().getParameters()[0].getType().getCanonicalText()) && returnType != null && "org.springframework.webflow.execution.Event".equals(returnType.getCanonicalText());
    }

    private static Collection<? extends PsiMethod> getAllMethods(WebflowNamedAction action) {
        if (action == null) {
            return Collections.emptySet();
        }
        SpringBeanPointer bean = (SpringBeanPointer)action.getBean().getValue();
        if (bean == null) {
            return Collections.emptySet();
        }
        PsiClass beanClass = bean.getBeanClass();
        if (beanClass == null) {
            return Collections.emptySet();
        }
        HashSet methods = new HashSet();
        ContainerUtil.addAll(methods, (Object[])beanClass.getAllMethods());
        return methods;
    }

    public PsiMethod fromString(@Nullable @NonNls String s, ConvertContext context) {
        PsiMethod resolvedMethod = null;
        if (s != null) {
            WebflowNamedAction action = (WebflowNamedAction)context.getInvocationElement().getParentOfType(WebflowNamedAction.class, false);
            for (PsiMethod psiMethod : ActionBeanMethodConverter.getAllMethods(action)) {
                if (!s.equals(psiMethod.getName()) || resolvedMethod != null && (psiMethod.getContainingClass() == null || resolvedMethod.getContainingClass() == null || !psiMethod.getContainingClass().isInheritor(resolvedMethod.getContainingClass(), true))) continue;
                resolvedMethod = psiMethod;
            }
        }
        return resolvedMethod;
    }

    public String toString(@Nullable PsiMethod psiMethod, ConvertContext context) {
        return psiMethod != null ? psiMethod.getName() : null;
    }
}

