/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.el;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightVariableBuilder;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.spring.el.contextProviders.SpringElContextsExtension;
import com.intellij.spring.security.highlighting.SpringSecuritySpElAccessInjector;
import com.intellij.spring.security.model.xml.converters.SecurityExpressionRootMethodsUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringSecurityELContextVariables
extends SpringElContextsExtension {
    private static final List<String> ANNOTATIONS = ContainerUtil.immutableList((Object[])new String[]{"org.springframework.security.access.prepost.PreAuthorize", "org.springframework.security.access.prepost.PreFilter", "org.springframework.security.access.prepost.PostAuthorize", "org.springframework.security.access.prepost.PostFilter"});
    private static PsiElementPattern[] PATTERNS = new PsiElementPattern[]{(PsiElementPattern)PsiJavaPatterns.literalExpression().and((ElementPattern)PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("access")).definedInClass("org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer.AuthorizedUrl")))};

    @NotNull
    public Collection<PsiMethod> getRootMethods(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "getRootMethods"));
        }
        PsiElement context = element.getContext();
        if (context == null || !SpringSecurityELContextVariables.acceptContext(context)) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "getRootMethods"));
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        Set<PsiMethod> set = SecurityExpressionRootMethodsUtil.getExpressionRootMethods(module, SpringSecurityELContextVariables.isSecurityAnnotation(context) ? "org.springframework.security.access.expression.method.MethodSecurityExpressionRoot" : "org.springframework.security.web.access.expression.WebSecurityExpressionRoot");
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "getRootMethods"));
        }
        return set;
    }

    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "getContextVariables"));
        }
        PsiElement context = psiElement.getContext();
        if (context == null || !SpringSecurityELContextVariables.acceptContext(context)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "getContextVariables"));
            }
            return list;
        }
        List variables = ContainerUtil.newSmartList();
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethod.class);
        if (method != null) {
            PsiParameter[] parameters;
            for (PsiParameter parameter : parameters = method.getParameterList().getParameters()) {
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, (String[])new String[]{"org.springframework.security.access.method.P"});
                if (annotation != null) {
                    String value = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)"value");
                    if (!StringUtil.isNotEmpty((String)value)) continue;
                    variables.add(new LightVariableBuilder(value, parameter.getType(), (PsiElement)annotation));
                    continue;
                }
                variables.add(parameter);
            }
            PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)context, PsiAnnotation.class);
            if (annotation != null) {
                SpringSecurityELContextVariables.addPostAuthorizeVariables(annotation, variables, method);
                SpringSecurityELContextVariables.addPreFilterAnnotationVariables(annotation, variables, method);
                SpringSecurityELContextVariables.addPostFilterAnnotationVariables(annotation, variables, method);
            }
        }
        List list = variables;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "getContextVariables"));
        }
        return list;
    }

    private static boolean acceptContext(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "acceptContext"));
        }
        return SpringSecurityELContextVariables.isSecurityAnnotation(context) || SpringSecurityELContextVariables.isXmlAccess(context) || SpringSecurityELContextVariables.isSecuritySpElPatternAccepted(context);
    }

    private static boolean isSecurityAnnotation(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "isSecurityAnnotation"));
        }
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)context, PsiAnnotation.class);
        return annotation != null && ANNOTATIONS.contains(annotation.getQualifiedName());
    }

    private static boolean isXmlAccess(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "isXmlAccess"));
        }
        return context instanceof XmlAttributeValue && SpringSecuritySpElAccessInjector.ACCESS_ATTR_PATTERN.accepts((Object)context);
    }

    private static void addPostAuthorizeVariables(@NotNull PsiAnnotation annotation, @NotNull Collection<PsiVariable> variables, @NotNull PsiMethod method) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "addPostAuthorizeVariables"));
        }
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "addPostAuthorizeVariables"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "addPostAuthorizeVariables"));
        }
        if ("org.springframework.security.access.prepost.PostAuthorize".equals(annotation.getQualifiedName())) {
            PsiType returnType = method.getReturnType();
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            if (returnType != null && returnTypeElement != null) {
                variables.add((PsiVariable)new LightVariableBuilder("returnObject", returnType, (PsiElement)returnTypeElement));
            }
        }
    }

    private static void addPostFilterAnnotationVariables(@NotNull PsiAnnotation annotation, @NotNull Collection<PsiVariable> variables, @NotNull PsiMethod method) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "addPostFilterAnnotationVariables"));
        }
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "addPostFilterAnnotationVariables"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "addPostFilterAnnotationVariables"));
        }
        if ("org.springframework.security.access.prepost.PostFilter".equals(annotation.getQualifiedName())) {
            PsiTypeElement returnTypeElement;
            PsiType returnType = method.getReturnType();
            if (returnType == null) {
                return;
            }
            PsiType iterableTypeParameter = PsiUtil.extractIterableTypeParameter((PsiType)returnType, (boolean)true);
            if (iterableTypeParameter != null && (returnTypeElement = method.getReturnTypeElement()) != null) {
                variables.add((PsiVariable)new LightVariableBuilder("filterObject", iterableTypeParameter, (PsiElement)returnTypeElement));
            }
        }
    }

    private static void addPreFilterAnnotationVariables(@NotNull PsiAnnotation annotation, @NotNull Collection<PsiVariable> variables, @NotNull PsiMethod method) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "addPreFilterAnnotationVariables"));
        }
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "addPreFilterAnnotationVariables"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "addPreFilterAnnotationVariables"));
        }
        if ("org.springframework.security.access.prepost.PreFilter".equals(annotation.getQualifiedName())) {
            String filterTarget = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)"filterTarget");
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (StringUtil.isEmptyOrSpaces((String)filterTarget)) {
                if (parameters.length == 1) {
                    SpringSecurityELContextVariables.addFilterObjectParameter(variables, parameters[0]);
                }
            } else {
                for (PsiParameter parameter : parameters) {
                    if (!filterTarget.equals(parameter.getName())) continue;
                    SpringSecurityELContextVariables.addFilterObjectParameter(variables, parameter);
                    return;
                }
            }
        }
    }

    private static void addFilterObjectParameter(@NotNull Collection<PsiVariable> variables, @NotNull PsiParameter parameter) {
        if (variables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variables", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "addFilterObjectParameter"));
        }
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "com/intellij/spring/security/el/SpringSecurityELContextVariables", "addFilterObjectParameter"));
        }
        PsiType iterableTypeParameter = PsiUtil.extractIterableTypeParameter((PsiType)parameter.getType(), (boolean)true);
        if (iterableTypeParameter != null) {
            variables.add((PsiVariable)new LightVariableBuilder("filterObject", iterableTypeParameter, (PsiElement)parameter));
        }
    }

    public static boolean isSecuritySpElPatternAccepted(PsiElement context) {
        for (PsiElementPattern pattern : PATTERNS) {
            if (!pattern.accepts((Object)context)) continue;
            return true;
        }
        return false;
    }
}

