/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework;

import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructure;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructureBuilder;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructureBuilder;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSIndexContentBuilder;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsTestFileIndexingHandler
extends FrameworkIndexingHandler {
    public void processFile(@NotNull JSFile psiFile, @NotNull JSFileCachedData data) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/javascript/testFramework/JsTestFileIndexingHandler", "processFile"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/javascript/testFramework/JsTestFileIndexingHandler", "processFile"));
        }
        VirtualFile file = psiFile.getViewProvider().getVirtualFile();
        if (file instanceof LightVirtualFile) {
            file = ((LightVirtualFile)file).getOriginalFile();
        }
        if (file == null || !file.isInLocalFileSystem()) {
            return;
        }
        if (SingleRootFileViewProvider.fileSizeIsGreaterThan((VirtualFile)file, (long)0x100000L)) {
            return;
        }
        if (JSLibraryUtil.isProbableLibraryFile((VirtualFile)file)) {
            return;
        }
        data.setTestFileType(JsTestFileIndexingHandler.getTestFileType(psiFile));
    }

    @Nullable
    private static JSTestFileType getTestFileType(@NotNull JSFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/javascript/testFramework/JsTestFileIndexingHandler", "getTestFileType"));
        }
        JasmineFileStructure jasmine = (JasmineFileStructure)JasmineFileStructureBuilder.getInstance().fetchCachedTestFileStructure(psiFile);
        if (!jasmine.isEmpty()) {
            return JSTestFileType.JASMINE;
        }
        QUnitFileStructure qunit = (QUnitFileStructure)QUnitFileStructureBuilder.getInstance().fetchCachedTestFileStructure(psiFile);
        if (!qunit.isEmpty()) {
            return JSTestFileType.QUNIT;
        }
        MochaTddFileStructure tdd = (MochaTddFileStructure)MochaTddFileStructureBuilder.getInstance().fetchCachedTestFileStructure(psiFile);
        if (!tdd.isEmpty()) {
            return JSTestFileType.TDD;
        }
        return null;
    }

    public void processFile(@NotNull JSFile file, @NotNull JSIndexContentBuilder indexBuilder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/testFramework/JsTestFileIndexingHandler", "processFile"));
        }
        if (indexBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexBuilder", "com/intellij/javascript/testFramework/JsTestFileIndexingHandler", "processFile"));
        }
        for (AbstractTestFileStructureBuilder<? extends AbstractTestFileStructure> builder : JsTestFileIndexingHandler.getFileStructureBuilders()) {
            JsTestFileIndexingHandler.putTestFileStructure(file, indexBuilder, builder);
        }
    }

    public static Collection<AbstractTestFileStructureBuilder<? extends AbstractTestFileStructure>> getFileStructureBuilders() {
        return ContainerUtil.list((Object[])new AbstractTestFileStructureBuilder[]{JasmineFileStructureBuilder.getInstance(), QUnitFileStructureBuilder.getInstance(), MochaTddFileStructureBuilder.getInstance()});
    }

    public int getVersion() {
        return 8;
    }

    private static <T extends AbstractTestFileStructure> void putTestFileStructure(@NotNull JSFile file, @NotNull JSIndexContentBuilder indexBuilder, @NotNull AbstractTestFileStructureBuilder<T> builder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/testFramework/JsTestFileIndexingHandler", "putTestFileStructure"));
        }
        if (indexBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexBuilder", "com/intellij/javascript/testFramework/JsTestFileIndexingHandler", "putTestFileStructure"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/javascript/testFramework/JsTestFileIndexingHandler", "putTestFileStructure"));
        }
        T testStructure = builder.buildTestFileStructure(file);
        indexBuilder.putAdditionalData(builder.KEY, testStructure);
    }
}

