/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework;

import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JstdRunElement;
import com.intellij.javascript.testFramework.util.TestMethodNameRefiner;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestFileStructurePack {
    private final List<AbstractTestFileStructure> myTestFileStructures;

    public TestFileStructurePack(@NotNull List<AbstractTestFileStructure> testFileStructures) {
        if (testFileStructures == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFileStructures", "com/intellij/javascript/testFramework/TestFileStructurePack", "<init>"));
        }
        this.myTestFileStructures = testFileStructures;
    }

    public boolean isEmpty() {
        for (AbstractTestFileStructure structure : this.myTestFileStructures) {
            if (structure.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public JstdRunElement getJstdRunElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/javascript/testFramework/TestFileStructurePack", "getJstdRunElement"));
        }
        TextRange textRange = psiElement.getTextRange();
        for (AbstractTestFileStructure testFileStructure : this.myTestFileStructures) {
            JstdRunElement jstdRunElement = testFileStructure.findJstdRunElement(textRange);
            if (jstdRunElement == null) continue;
            return jstdRunElement;
        }
        return null;
    }

    @Nullable
    public PsiElement findPsiElement(@NotNull String testCaseName, @Nullable String testMethodName, @Nullable TestMethodNameRefiner testMethodNameRefiner) {
        if (testCaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCaseName", "com/intellij/javascript/testFramework/TestFileStructurePack", "findPsiElement"));
        }
        for (AbstractTestFileStructure testFileStructure : this.myTestFileStructures) {
            PsiElement element;
            String refinedTestMethodName = testMethodName;
            if (testMethodNameRefiner != null && testMethodName != null) {
                refinedTestMethodName = testMethodNameRefiner.refine(testFileStructure, testMethodName);
            }
            if ((element = testFileStructure.findPsiElement(testCaseName, refinedTestMethodName)) == null) continue;
            return element;
        }
        return null;
    }

    public boolean contains(@NotNull String testCaseName, @Nullable String testMethodName, @Nullable TestMethodNameRefiner testMethodNameRefiner) {
        if (testCaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCaseName", "com/intellij/javascript/testFramework/TestFileStructurePack", "contains"));
        }
        for (AbstractTestFileStructure testFileStructure : this.myTestFileStructures) {
            boolean ok;
            String refinedTestMethodName = testMethodName;
            if (testMethodNameRefiner != null && testMethodName != null) {
                refinedTestMethodName = testMethodNameRefiner.refine(testFileStructure, testMethodName);
            }
            if (!(ok = testFileStructure.contains(testCaseName, refinedTestMethodName))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<AbstractTestFileStructure> getTestFileStructures() {
        List<AbstractTestFileStructure> list = this.myTestFileStructures;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/TestFileStructurePack", "getTestFileStructures"));
        }
        return list;
    }

    @NotNull
    public List<String> getTopLevelElements() {
        ArrayList<String> out = new ArrayList<String>();
        for (AbstractTestFileStructure structure : this.myTestFileStructures) {
            if (structure.isEmpty()) continue;
            List<String> topLevel = structure.getTopLevelElements();
            out.addAll(topLevel);
        }
        ArrayList<String> arrayList = out;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/TestFileStructurePack", "getTopLevelElements"));
        }
        return arrayList;
    }

    @NotNull
    public List<String> getChildrenOf(String topLevelElementName) {
        ArrayList<String> out = new ArrayList<String>();
        for (AbstractTestFileStructure structure : this.myTestFileStructures) {
            List<String> localChildren = structure.getChildrenOf(topLevelElementName);
            out.addAll(localChildren);
        }
        ArrayList<String> arrayList = out;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/TestFileStructurePack", "getChildrenOf"));
        }
        return arrayList;
    }
}

