/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.util;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.BaseJSTokenTypes;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsPsiUtils {
    private JsPsiUtils() {
    }

    private static String getStringValue(@NotNull JSLiteralExpression literalExpression) {
        if (literalExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalExpression", "com/intellij/javascript/testFramework/util/JsPsiUtils", "getStringValue"));
        }
        if (literalExpression instanceof JSStringTemplateExpression) {
            return StringUtil.unquoteString((String)literalExpression.getText(), (char)'`');
        }
        String text = StringUtil.unquoteString((String)StringUtil.notNullize((String)literalExpression.getText()));
        return JsPsiUtils.unescapeBackslashes(text);
    }

    @NotNull
    public static String unescapeBackslashes(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/javascript/testFramework/util/JsPsiUtils", "unescapeBackslashes"));
        }
        if (!StringUtil.containsChar((String)str, (char)'\\')) {
            String string = str;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/JsPsiUtils", "unescapeBackslashes"));
            }
            return string;
        }
        StringBuilder result = new StringBuilder(str.length());
        boolean backslash = false;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (backslash) {
                if (ch == 'u') {
                    if (JsPsiUtils.appendCodePoint(result, str, i + 1, 4)) {
                        i += 4;
                    } else {
                        result.append('\\').append(ch);
                    }
                } else if (ch == 'x') {
                    if (JsPsiUtils.appendCodePoint(result, str, i + 1, 2)) {
                        i += 2;
                    } else {
                        result.append('\\').append(ch);
                    }
                } else {
                    JsPsiUtils.appendEscapedChar(result, ch);
                }
                backslash = false;
                continue;
            }
            if (ch == '\\') {
                backslash = true;
                continue;
            }
            result.append(ch);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/JsPsiUtils", "unescapeBackslashes"));
        }
        return string;
    }

    private static void appendEscapedChar(@NotNull StringBuilder result, char ch) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javascript/testFramework/util/JsPsiUtils", "appendEscapedChar"));
        }
        if (ch == '0') {
            result.append('\u0000');
        } else if (ch == '\'') {
            result.append('\'');
        } else if (ch == '\"') {
            result.append('\"');
        } else if (ch == '\\') {
            result.append('\\');
        } else if (ch == 'n') {
            result.append('\n');
        } else if (ch == 'r') {
            result.append('\r');
        } else if (ch == 'v') {
            result.append('v');
        } else if (ch == 't') {
            result.append('\t');
        } else if (ch == 'b') {
            int l = result.length();
            if (l > 0) {
                result.setLength(l - 1);
            }
        } else if (ch == 'f') {
            result.append('\f');
        } else {
            result.append(ch);
        }
    }

    private static boolean appendCodePoint(@NotNull StringBuilder result, @NotNull String str, int from, int cnt) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javascript/testFramework/util/JsPsiUtils", "appendCodePoint"));
        }
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/javascript/testFramework/util/JsPsiUtils", "appendCodePoint"));
        }
        if (from + cnt <= str.length()) {
            String s = str.substring(from, from + cnt);
            try {
                int code = Integer.parseInt(s, 16);
                result.append((char)code);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    @Nullable
    public static String extractStringValue(@Nullable JSExpression jsExpression) {
        JSExpression initializer;
        JSReferenceExpression jsReferenceExpression;
        IElementType operationType;
        if (jsExpression == null) {
            return null;
        }
        JSLiteralExpression jsLiteralExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)jsExpression, JSLiteralExpression.class);
        if (jsLiteralExpression != null && jsLiteralExpression.isQuotedLiteral()) {
            return JsPsiUtils.getStringValue(jsLiteralExpression);
        }
        JSBinaryExpression jsBinaryExpression = (JSBinaryExpression)ObjectUtils.tryCast((Object)jsExpression, JSBinaryExpression.class);
        if (jsBinaryExpression != null && (operationType = jsBinaryExpression.getOperationSign()) == BaseJSTokenTypes.PLUS) {
            String lOperand = JsPsiUtils.extractStringValue(jsBinaryExpression.getLOperand());
            String rOperand = JsPsiUtils.extractStringValue(jsBinaryExpression.getROperand());
            if (lOperand != null && rOperand != null) {
                return lOperand + rOperand;
            }
        }
        if ((jsReferenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)jsExpression, JSReferenceExpression.class)) != null && (initializer = JsPsiUtils.extractInitExpression(jsReferenceExpression)) != null) {
            return JsPsiUtils.extractStringValue(initializer);
        }
        return null;
    }

    @Nullable
    private static JSExpression extractInitExpression(@NotNull JSReferenceExpression jsReferenceExpression) {
        if (jsReferenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsReferenceExpression", "com/intellij/javascript/testFramework/util/JsPsiUtils", "extractInitExpression"));
        }
        JSElement scopeElement = JsPsiUtils.getNearestContainingScopeElement((JSElement)jsReferenceExpression);
        if (scopeElement == null) {
            return null;
        }
        String refName = jsReferenceExpression.getReferenceName();
        if (refName == null || refName.isEmpty()) {
            return null;
        }
        List<JSStatement> statements = JsPsiUtils.getTopLevelStatementsOf(scopeElement);
        int maxOffset = jsReferenceExpression.getTextRange().getStartOffset();
        JSExpression lastExpr = null;
        for (JSStatement statement : statements) {
            JSReferenceExpression refExpr;
            JSDefinitionExpression defExpr;
            JSAssignmentExpression assignmentExpr;
            JSExpressionStatement exprStmt;
            if (statement.getTextRange().getEndOffset() > maxOffset) break;
            JSVarStatement varStmt = (JSVarStatement)ObjectUtils.tryCast((Object)statement, JSVarStatement.class);
            if (varStmt != null) {
                JSVariable[] vars;
                for (JSVariable var : vars = (JSVariable[])ObjectUtils.notNull((Object)varStmt.getVariables(), (Object)JSVariable.EMPTY_ARRAY)) {
                    if (!refName.equals(var.getQualifiedName())) continue;
                    lastExpr = var.getInitializer();
                }
            }
            if ((exprStmt = (JSExpressionStatement)ObjectUtils.tryCast((Object)statement, JSExpressionStatement.class)) == null || (assignmentExpr = (JSAssignmentExpression)ObjectUtils.tryCast((Object)exprStmt.getExpression(), JSAssignmentExpression.class)) == null || (defExpr = (JSDefinitionExpression)ObjectUtils.tryCast((Object)assignmentExpr.getLOperand(), JSDefinitionExpression.class)) == null || (refExpr = (JSReferenceExpression)ObjectUtils.tryCast((Object)defExpr.getExpression(), JSReferenceExpression.class)) == null || refExpr.getQualifier() != null || !refName.equals(refExpr.getReferenceName())) continue;
            lastExpr = assignmentExpr.getROperand();
        }
        return lastExpr;
    }

    @Nullable
    public static JSObjectLiteralExpression extractObjectLiteralExpression(@Nullable JSExpression expression) {
        JSExpression initializer;
        if (expression == null) {
            return null;
        }
        JSObjectLiteralExpression jsObjectLiteralExpression = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)expression, JSObjectLiteralExpression.class);
        if (jsObjectLiteralExpression != null) {
            return jsObjectLiteralExpression;
        }
        JSReferenceExpression jsReferenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)expression, JSReferenceExpression.class);
        if (jsReferenceExpression != null && (initializer = JsPsiUtils.extractInitExpression(jsReferenceExpression)) != null) {
            return JsPsiUtils.extractObjectLiteralExpression(initializer);
        }
        return null;
    }

    @Nullable
    public static String extractNumberLiteral(@Nullable JSExpression jsExpression) {
        JSExpression initializer;
        if (jsExpression == null) {
            return null;
        }
        JSLiteralExpression jsLiteralExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)jsExpression, JSLiteralExpression.class);
        if (jsLiteralExpression != null && jsLiteralExpression.isNumericLiteral()) {
            return jsLiteralExpression.getText();
        }
        JSReferenceExpression jsReferenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)jsExpression, JSReferenceExpression.class);
        if (jsReferenceExpression != null && (initializer = JsPsiUtils.extractInitExpression(jsReferenceExpression)) != null) {
            return JsPsiUtils.extractNumberLiteral(initializer);
        }
        return null;
    }

    @Nullable
    public static JSFunctionExpression extractFunctionExpression(@Nullable JSExpression expression) {
        JSExpression initializer;
        if (expression == null) {
            return null;
        }
        JSFunctionExpression jsFunctionExpression = (JSFunctionExpression)ObjectUtils.tryCast((Object)expression, JSFunctionExpression.class);
        if (jsFunctionExpression != null) {
            return jsFunctionExpression;
        }
        JSReferenceExpression jsReferenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)expression, JSReferenceExpression.class);
        if (jsReferenceExpression != null && (initializer = JsPsiUtils.extractInitExpression(jsReferenceExpression)) != null) {
            return JsPsiUtils.extractFunctionExpression(initializer);
        }
        return null;
    }

    @NotNull
    public static List<JSStatement> listStatementsInExecutionOrder(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/intellij/javascript/testFramework/util/JsPsiUtils", "listStatementsInExecutionOrder"));
        }
        ArrayList statements = Lists.newArrayList();
        for (PsiElement child : jsFile.getChildren()) {
            JSElement element = (JSElement)ObjectUtils.tryCast((Object)child, JSElement.class);
            if (element == null) continue;
            JsPsiUtils.collectJsStatementsInExecutionOrder(element, statements);
        }
        ArrayList arrayList = statements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/JsPsiUtils", "listStatementsInExecutionOrder"));
        }
        return arrayList;
    }

    @NotNull
    public static List<JSStatement> listStatementsInExecutionOrder(@NotNull JSFunctionExpression funcExpr) {
        if (funcExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "funcExpr", "com/intellij/javascript/testFramework/util/JsPsiUtils", "listStatementsInExecutionOrder"));
        }
        ArrayList statements = Lists.newArrayList();
        for (JSSourceElement sourceElement : funcExpr.getBody()) {
            JsPsiUtils.collectJsStatementsInExecutionOrder((JSElement)sourceElement, statements);
        }
        ArrayList arrayList = statements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/JsPsiUtils", "listStatementsInExecutionOrder"));
        }
        return arrayList;
    }

    private static void collectJsStatementsInExecutionOrder(@NotNull JSElement statement, @NotNull List<JSStatement> statements) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/javascript/testFramework/util/JsPsiUtils", "collectJsStatementsInExecutionOrder"));
        }
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "com/intellij/javascript/testFramework/util/JsPsiUtils", "collectJsStatementsInExecutionOrder"));
        }
        JSFunction function = null;
        if (statement instanceof JSExpressionStatement) {
            JSCallExpression callExpression;
            JSExpression expressionOfStatement = ((JSExpressionStatement)statement).getExpression();
            if (expressionOfStatement == null) {
                return;
            }
            if (expressionOfStatement instanceof JSCallExpression) {
                callExpression = (JSCallExpression)expressionOfStatement;
                JSParenthesizedExpression parenthesizedExpression = JsPsiUtils.getParenthesizedExpression(callExpression);
                if (parenthesizedExpression != null) {
                    function = (JSFunction)ObjectUtils.tryCast((Object)parenthesizedExpression.getInnerExpression(), JSFunction.class);
                } else if (JSAmdPsiUtil.isDefineCall((JSCallExpression)callExpression)) {
                    JSExpression moduleInitializer = JSAmdPsiUtil.getModuleInitializer((JSCallExpression)callExpression);
                    function = (JSFunction)ObjectUtils.tryCast((Object)moduleInitializer, JSFunction.class);
                }
            } else if (expressionOfStatement instanceof JSParenthesizedExpression && (callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)((JSParenthesizedExpression)expressionOfStatement).getInnerExpression(), JSCallExpression.class)) != null) {
                function = (JSFunction)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSFunction.class);
            }
        }
        if (function == null) {
            function = (JSFunction)ObjectUtils.tryCast((Object)statement, JSFunction.class);
        }
        if (function != null) {
            JSSourceElement[] sourceElements;
            for (JSSourceElement jSSourceElement : sourceElements = function.getBody()) {
                if (!(jSSourceElement instanceof JSStatement)) continue;
                JsPsiUtils.collectJsStatementsInExecutionOrder((JSElement)jSSourceElement, statements);
            }
        } else if (statement instanceof JSBlockStatement) {
            JSStatement[] childStatements = ((JSBlockStatement)statement).getStatements();
            for (JSSourceElement jSSourceElement : childStatements) {
                JsPsiUtils.collectJsStatementsInExecutionOrder((JSElement)jSSourceElement, statements);
            }
        } else if (statement instanceof JSStatement) {
            statements.add((JSStatement)statement);
        } else if (statement instanceof TypeScriptImplicitModule) {
            TypeScriptModule module = ((TypeScriptImplicitModule)statement).getRealModule();
            if (module != null) {
                JsPsiUtils.collectStatementsInsideModule(module, statements);
            }
        } else if (statement instanceof TypeScriptModule) {
            JsPsiUtils.collectStatementsInsideModule((TypeScriptModule)statement, statements);
        }
    }

    private static void collectStatementsInsideModule(@NotNull TypeScriptModule<?> tsm, @NotNull List<JSStatement> statements) {
        if (tsm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tsm", "com/intellij/javascript/testFramework/util/JsPsiUtils", "collectStatementsInsideModule"));
        }
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "com/intellij/javascript/testFramework/util/JsPsiUtils", "collectStatementsInsideModule"));
        }
        for (PsiElement element : tsm.getChildren()) {
            if (!(element instanceof JSElement)) continue;
            JsPsiUtils.collectJsStatementsInExecutionOrder((JSElement)element, statements);
        }
    }

    private static JSParenthesizedExpression getParenthesizedExpression(JSCallExpression callExpression) {
        JSExpression methodExpression = callExpression.getMethodExpression();
        JSReferenceExpression referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)methodExpression, JSReferenceExpression.class);
        if (referenceExpression != null && "call".equals(referenceExpression.getReferenceName())) {
            return (JSParenthesizedExpression)ObjectUtils.tryCast((Object)referenceExpression.getQualifier(), JSParenthesizedExpression.class);
        }
        return (JSParenthesizedExpression)ObjectUtils.tryCast((Object)methodExpression, JSParenthesizedExpression.class);
    }

    public static boolean isStringElement(@Nullable JSExpression jsExpression) {
        return JsPsiUtils.extractStringValue(jsExpression) != null;
    }

    public static boolean isObjectElement(@Nullable JSExpression jsExpression) {
        return JsPsiUtils.extractObjectLiteralExpression(jsExpression) != null;
    }

    public static boolean isFunctionExpressionElement(@Nullable JSExpression jsExpression) {
        return JsPsiUtils.extractFunctionExpression(jsExpression) != null;
    }

    public static boolean isNumberElement(@Nullable JSExpression jsExpression) {
        return JsPsiUtils.extractNumberLiteral(jsExpression) != null;
    }

    @Nullable
    public static JSCallExpression toCallExpressionFromStatement(@NotNull JSStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/javascript/testFramework/util/JsPsiUtils", "toCallExpressionFromStatement"));
        }
        if (statement instanceof JSExpressionStatement) {
            JSExpressionStatement expressionStatement = (JSExpressionStatement)statement;
            return (JSCallExpression)ObjectUtils.tryCast((Object)expressionStatement.getExpression(), JSCallExpression.class);
        }
        if (statement instanceof JSReturnStatement) {
            JSReturnStatement returnStatement = (JSReturnStatement)statement;
            return (JSCallExpression)ObjectUtils.tryCast((Object)returnStatement.getExpression(), JSCallExpression.class);
        }
        return null;
    }

    @NotNull
    public static JSProperty[] getProperties(@NotNull JSObjectLiteralExpression objectLiteralExpression) {
        if (objectLiteralExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectLiteralExpression", "com/intellij/javascript/testFramework/util/JsPsiUtils", "getProperties"));
        }
        JSProperty[] properties = objectLiteralExpression.getProperties();
        if (properties == null) {
            properties = JSProperty.EMPTY_ARRAY;
        }
        int cnt = 0;
        for (JSProperty property : properties) {
            if (property == null) continue;
            ++cnt;
        }
        if (cnt < properties.length) {
            JSProperty[] a = new JSProperty[cnt];
            int id = 0;
            for (JSProperty property : properties) {
                if (property == null) continue;
                a[id] = property;
                ++id;
            }
            if (a == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/JsPsiUtils", "getProperties"));
            }
            return a;
        }
        if (properties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/JsPsiUtils", "getProperties"));
        }
        return properties;
    }

    public static boolean containsOffsetStrictly(@NotNull TextRange textRange, int offset) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/javascript/testFramework/util/JsPsiUtils", "containsOffsetStrictly"));
        }
        return textRange.getStartOffset() < offset && offset < textRange.getEndOffset();
    }

    @NotNull
    public static JSExpression[] getArguments(@Nullable JSArgumentList argumentList) {
        JSExpression[] expressions = null;
        if (argumentList != null) {
            expressions = argumentList.getArguments();
        }
        if (expressions == null) {
            expressions = JSExpression.EMPTY_ARRAY;
        }
        if (expressions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/JsPsiUtils", "getArguments"));
        }
        return expressions;
    }

    @NotNull
    public static JSExpression[] getArguments(@NotNull JSCallExpression jsCallExpression) {
        if (jsCallExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsCallExpression", "com/intellij/javascript/testFramework/util/JsPsiUtils", "getArguments"));
        }
        JSExpression[] jSExpressionArray = JsPsiUtils.getArguments(jsCallExpression.getArgumentList());
        if (jSExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/JsPsiUtils", "getArguments"));
        }
        return jSExpressionArray;
    }

    @Nullable
    public static PsiElement getPropertyNamePsiElement(@NotNull JSProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/javascript/testFramework/util/JsPsiUtils", "getPropertyNamePsiElement"));
        }
        return (PsiElement)ObjectUtils.tryCast((Object)property.getFirstChild(), LeafPsiElement.class);
    }

    @Nullable
    public static String getPropertyName(@NotNull JSProperty property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/javascript/testFramework/util/JsPsiUtils", "getPropertyName"));
        }
        PsiElement testMethodNameDeclaration = JsPsiUtils.getPropertyNamePsiElement(property);
        if (testMethodNameDeclaration == null) {
            return null;
        }
        return StringUtil.unquoteString((String)testMethodNameDeclaration.getText());
    }

    public static boolean isElementOfType(@Nullable PsiElement psiElement, @NotNull IElementType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javascript/testFramework/util/JsPsiUtils", "isElementOfType"));
        }
        if (psiElement instanceof ASTNode) {
            ASTNode node = (ASTNode)psiElement;
            return node.getElementType() == type;
        }
        return false;
    }

    public static boolean isElementOfType(@Nullable PsiElement psiElement, @NotNull IElementType type1, @NotNull IElementType type2, @NotNull IElementType type3) {
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "com/intellij/javascript/testFramework/util/JsPsiUtils", "isElementOfType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "com/intellij/javascript/testFramework/util/JsPsiUtils", "isElementOfType"));
        }
        if (type3 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type3", "com/intellij/javascript/testFramework/util/JsPsiUtils", "isElementOfType"));
        }
        if (psiElement instanceof ASTNode) {
            ASTNode node = (ASTNode)psiElement;
            IElementType type = node.getElementType();
            return type == type1 || type == type2 || type == type3;
        }
        return false;
    }

    @Nullable
    public static PsiElement getFunctionLeftBrace(@Nullable JSFunction function) {
        JSSourceElement[] jsSourceElements;
        if (function == null) {
            return null;
        }
        for (JSSourceElement jsSourceElement : jsSourceElements = (JSSourceElement[])ObjectUtils.notNull((Object)function.getBody(), (Object)JSSourceElement.EMPTY_ARRAY)) {
            if (!(jsSourceElement instanceof JSBlockStatement)) continue;
            JSBlockStatement jsBlockStatement = (JSBlockStatement)jsSourceElement;
            return jsBlockStatement.getFirstChild();
        }
        return null;
    }

    @Nullable
    public static Document getDocument(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/testFramework/util/JsPsiUtils", "getDocument"));
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        return PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(psiFile);
    }

    @NotNull
    public static List<JSStatement> listStatementsInExecutionOrderNextTo(@NotNull JSStatement stmt) {
        if (stmt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stmt", "com/intellij/javascript/testFramework/util/JsPsiUtils", "listStatementsInExecutionOrderNextTo"));
        }
        JSElement nearestScopeElement = JsPsiUtils.getNearestContainingScopeElement((JSElement)stmt);
        if (nearestScopeElement == null) {
            List<JSStatement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/JsPsiUtils", "listStatementsInExecutionOrderNextTo"));
            }
            return list;
        }
        List<JSStatement> statements = JsPsiUtils.getTopLevelStatementsOf(nearestScopeElement);
        int minStartOffset = stmt.getTextRange().getEndOffset();
        Iterator<JSStatement> it = statements.iterator();
        while (it.hasNext()) {
            JSStatement statement = it.next();
            if (minStartOffset <= statement.getTextRange().getStartOffset()) continue;
            it.remove();
        }
        List<JSStatement> list = statements;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/JsPsiUtils", "listStatementsInExecutionOrderNextTo"));
        }
        return list;
    }

    @Nullable
    private static JSElement getNearestContainingScopeElement(@NotNull JSElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/testFramework/util/JsPsiUtils", "getNearestContainingScopeElement"));
        }
        PsiElement parent = element.getParent();
        while (parent != null) {
            if (parent instanceof JSFunction) {
                return (JSFunction)parent;
            }
            if (parent instanceof PsiFile) {
                return (JSElement)ObjectUtils.tryCast((Object)parent, JSFile.class);
            }
            PsiElement newParent = parent.getParent();
            if (newParent == parent) break;
            parent = newParent;
        }
        return null;
    }

    @NotNull
    private static List<JSStatement> getTopLevelStatementsOf(@NotNull JSElement parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javascript/testFramework/util/JsPsiUtils", "getTopLevelStatementsOf"));
        }
        JSSourceElement[] elements = JSSourceElement.EMPTY_ARRAY;
        if (parent instanceof JSFile) {
            JSFile jsFile = (JSFile)parent;
            elements = jsFile.getStatements();
        } else if (parent instanceof JSFunction) {
            JSFunction f = (JSFunction)parent;
            elements = f.getBody();
        }
        ArrayList<JSStatement> out = new ArrayList<JSStatement>();
        for (JSSourceElement element : elements) {
            JsPsiUtils.collectJsStatementsInExecutionOrder((JSElement)element, out);
        }
        ArrayList<JSStatement> arrayList = out;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/JsPsiUtils", "getTopLevelStatementsOf"));
        }
        return arrayList;
    }

    public static <K> K getVerifiedHierarchyHead(PsiElement psiElement, Class<?>[] hierarchyClasses, Class<K> headHierarchyClass) {
        for (Class<?> clazz : hierarchyClasses) {
            if (!clazz.isInstance(psiElement)) {
                return null;
            }
            psiElement = psiElement.getParent();
        }
        return (K)ObjectUtils.tryCast((Object)psiElement, headHierarchyClass);
    }

    @NotNull
    public static String wrapWithMostFrequentQuote(@NotNull JSFile jsFile, String stringLiteralValue) {
        if (jsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/intellij/javascript/testFramework/util/JsPsiUtils", "wrapWithMostFrequentQuote"));
        }
        QuoteCountingVisitor visitor = new QuoteCountingVisitor();
        visitor.visitFile((PsiFile)jsFile);
        char quoteChar = visitor.mySingleQuotes == visitor.myDoubleQuotes ? (char)'\'' : (visitor.mySingleQuotes < visitor.myDoubleQuotes ? (char)'\"' : '\'');
        String string = quoteChar + stringLiteralValue + quoteChar;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/util/JsPsiUtils", "wrapWithMostFrequentQuote"));
        }
        return string;
    }

    public static boolean mightContainGlobalCall(@NotNull PsiFile file, @NotNull String globalName, boolean globalAsQualifier) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/testFramework/util/JsPsiUtils", "mightContainGlobalCall"));
        }
        if (globalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalName", "com/intellij/javascript/testFramework/util/JsPsiUtils", "mightContainGlobalCall"));
        }
        CharSequence contents = file.getViewProvider().getContents();
        int ind = StringUtil.indexOf((CharSequence)contents, (CharSequence)globalName);
        while (ind >= 0) {
            char prevChar;
            char c = prevChar = ind > 0 ? (char)contents.charAt(ind - 1) : (char)' ';
            if (prevChar != '.' && prevChar != '_' && !Character.isLetterOrDigit(prevChar)) {
                char nextChar;
                int nextCharInd = ind + globalName.length();
                char c2 = nextChar = nextCharInd < contents.length() ? (char)contents.charAt(nextCharInd) : (char)'(';
                if (nextChar == '(' || Character.isWhitespace(nextChar)) {
                    return true;
                }
                if (globalAsQualifier && nextChar == '.') {
                    return true;
                }
            }
            ind = StringUtil.indexOf((CharSequence)contents, (CharSequence)globalName, (int)(ind + globalName.length() + 1));
        }
        return false;
    }

    private static class QuoteCountingVisitor
    extends JSRecursiveElementVisitor {
        private int myDoubleQuotes = 0;
        private int mySingleQuotes = 0;

        private QuoteCountingVisitor() {
        }

        public void visitJSLiteralExpression(JSLiteralExpression expr) {
            if (expr.isQuotedLiteral()) {
                CharSequence seq;
                LeafPsiElement firstChild = (LeafPsiElement)ObjectUtils.tryCast((Object)expr.getFirstChild(), LeafPsiElement.class);
                CharSequence charSequence = seq = firstChild != null ? firstChild.getChars() : expr.getText();
                if (StringUtil.startsWithChar((CharSequence)seq, (char)'\"')) {
                    ++this.myDoubleQuotes;
                } else {
                    ++this.mySingleQuotes;
                }
            }
        }
    }
}

