/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/SingletonReferencesLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "visitGetEnumValue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "visitGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "backend.jvm"})
public final class SingletonReferencesLowering
extends IrElementTransformerVoid
implements BodyLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrBody irBody) {
        Intrinsics.checkParameterIsNotNull((Object)irBody, (String)"irBody");
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, this);
    }

    @Override
    @NotNull
    public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        PropertyDescriptor enumValueFieldDescriptor = this.context.getSpecialDescriptorsFactory().getFieldDescriptorForEnumEntry(expression2.getDescriptor());
        return new IrGetFieldImpl(expression2.getStartOffset(), expression2.getEndOffset(), enumValueFieldDescriptor, null, null, 24, null);
    }

    @Override
    @NotNull
    public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        PropertyDescriptor instanceFieldDescriptor = this.context.getSpecialDescriptorsFactory().getFieldDescriptorForObjectInstance(expression2.getDescriptor());
        return new IrGetFieldImpl(expression2.getStartOffset(), expression2.getEndOffset(), instanceFieldDescriptor, null, null, 24, null);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public SingletonReferencesLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

