/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import com.intellij.compiler.options.ComparingUtils;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.CoroutineSupport;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.TargetPlatformKind;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.PluginStartupComponent;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JsCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JvmCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCommonCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerSettings;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerWorkspaceSettings;
import org.jetbrains.kotlin.idea.facet.DescriptionListCellRenderer;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

public class KotlinCompilerConfigurableTab
implements SearchableConfigurable,
Configurable.NoScroll {
    private static final Map<String, String> moduleKindDescriptions = new LinkedHashMap<String, String>();
    private static final List<LanguageFeature.State> languageFeatureStates = Arrays.asList(LanguageFeature.State.ENABLED, LanguageFeature.State.ENABLED_WITH_WARNING, LanguageFeature.State.ENABLED_WITH_ERROR);
    private static final int MAX_WARNING_SIZE = 75;
    @Nullable
    private final KotlinCompilerWorkspaceSettings compilerWorkspaceSettings;
    private final Project project;
    private final boolean isProjectSettings;
    private CommonCompilerArguments commonCompilerArguments;
    private K2JSCompilerArguments k2jsCompilerArguments;
    private K2JVMCompilerArguments k2jvmCompilerArguments;
    private CompilerSettings compilerSettings;
    private JPanel contentPane;
    private ThreeStateCheckBox reportWarningsCheckBox;
    private RawCommandLineEditor additionalArgsOptionsField;
    private JLabel additionalArgsLabel;
    private ThreeStateCheckBox generateSourceMapsCheckBox;
    private TextFieldWithBrowseButton outputPrefixFile;
    private TextFieldWithBrowseButton outputPostfixFile;
    private JLabel labelForOutputDirectory;
    private TextFieldWithBrowseButton outputDirectory;
    private ThreeStateCheckBox copyRuntimeFilesCheckBox;
    private ThreeStateCheckBox keepAliveCheckBox;
    private JCheckBox enablePreciseIncrementalCheckBox;
    private JComboBox moduleKindComboBox;
    private JTextField scriptTemplatesField;
    private JTextField scriptTemplatesClasspathField;
    private JLabel scriptTemplatesLabel;
    private JLabel scriptTemplatesClasspathLabel;
    private JPanel k2jvmPanel;
    private JPanel k2jsPanel;
    private JComboBox jvmVersionComboBox;
    private JComboBox languageVersionComboBox;
    private JComboBox coroutineSupportComboBox;
    private JComboBox apiVersionComboBox;
    private JPanel scriptPanel;
    private JLabel labelForOutputPrefixFile;
    private JLabel labelForOutputPostfixFile;
    private JLabel warningLabel;
    private boolean isEnabled;

    public KotlinCompilerConfigurableTab(Project project, @NotNull CommonCompilerArguments commonCompilerArguments, @NotNull K2JSCompilerArguments k2jsCompilerArguments, @NotNull K2JVMCompilerArguments k2jvmCompilerArguments, CompilerSettings compilerSettings, @Nullable KotlinCompilerWorkspaceSettings compilerWorkspaceSettings, boolean isProjectSettings, boolean isMultiEditor) {
        if (commonCompilerArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonCompilerArguments", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "<init>"));
        }
        if (k2jsCompilerArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k2jsCompilerArguments", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "<init>"));
        }
        if (k2jvmCompilerArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "k2jvmCompilerArguments", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "<init>"));
        }
        this.isEnabled = true;
        this.project = project;
        this.commonCompilerArguments = commonCompilerArguments;
        this.k2jsCompilerArguments = k2jsCompilerArguments;
        this.compilerSettings = compilerSettings;
        this.compilerWorkspaceSettings = compilerWorkspaceSettings;
        this.k2jvmCompilerArguments = k2jvmCompilerArguments;
        this.isProjectSettings = isProjectSettings;
        this.$$$setupUI$$$();
        this.languageVersionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KotlinCompilerConfigurableTab.this.restrictAPIVersions();
            }
        });
        this.additionalArgsOptionsField.attachLabel(this.additionalArgsLabel);
        KotlinCompilerConfigurableTab.setupFileChooser(this.labelForOutputPrefixFile, this.outputPrefixFile, KotlinBundle.message("kotlin.compiler.js.option.output.prefix.browse.title", new Object[0]), true);
        KotlinCompilerConfigurableTab.setupFileChooser(this.labelForOutputPostfixFile, this.outputPostfixFile, KotlinBundle.message("kotlin.compiler.js.option.output.postfix.browse.title", new Object[0]), true);
        KotlinCompilerConfigurableTab.setupFileChooser(this.labelForOutputDirectory, this.outputDirectory, "Choose Output Directory", false);
        this.copyRuntimeFilesCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab$2", "stateChanged"));
                }
                KotlinCompilerConfigurableTab.this.updateOutputDirEnabled();
            }
        });
        this.fillModuleKindList();
        this.fillJvmVersionList();
        this.fillLanguageAndAPIVersionList();
        this.fillCoroutineSupportList();
        if (compilerWorkspaceSettings == null) {
            this.keepAliveCheckBox.setVisible(false);
            this.k2jvmPanel.setVisible(false);
        }
        this.reportWarningsCheckBox.setThirdStateEnabled(isMultiEditor);
        this.generateSourceMapsCheckBox.setThirdStateEnabled(isMultiEditor);
        this.copyRuntimeFilesCheckBox.setThirdStateEnabled(isMultiEditor);
        this.keepAliveCheckBox.setThirdStateEnabled(isMultiEditor);
        if (isProjectSettings) {
            List modulesOverridingProjectSettings = ArraysKt.mapNotNull((Object[])ModuleManager.getInstance((Project)project).getModules(), (Function1)new Function1<Module, String>(){

                public String invoke(Module module) {
                    KotlinFacet facet = KotlinFacet.Companion.get(module);
                    if (facet == null) {
                        return null;
                    }
                    KotlinFacetSettings facetSettings = ((KotlinFacetConfiguration)facet.getConfiguration()).getSettings();
                    if (facetSettings.getUseProjectSettings()) {
                        return null;
                    }
                    return module.getName();
                }
            });
            CollectionsKt.sort((List)modulesOverridingProjectSettings);
            if (!modulesOverridingProjectSettings.isEmpty()) {
                this.warningLabel.setVisible(true);
                this.warningLabel.setText(KotlinCompilerConfigurableTab.buildOverridingModulesWarning(modulesOverridingProjectSettings));
            }
        }
        this.updateOutputDirEnabled();
    }

    public KotlinCompilerConfigurableTab(Project project) {
        this(project, (CommonCompilerArguments)KotlinCommonCompilerArgumentsHolder.Companion.getInstance(project).getSettings(), (K2JSCompilerArguments)Kotlin2JsCompilerArgumentsHolder.Companion.getInstance(project).getSettings(), (K2JVMCompilerArguments)Kotlin2JvmCompilerArgumentsHolder.Companion.getInstance(project).getSettings(), (CompilerSettings)KotlinCompilerSettings.Companion.getInstance(project).getSettings(), (KotlinCompilerWorkspaceSettings)ServiceManager.getService((Project)project, KotlinCompilerWorkspaceSettings.class), true, false);
    }

    private static int calculateNameCountToShowInWarning(List<String> allNames) {
        int lengthSoFar = 0;
        int size = allNames.size();
        for (int i = 0; i < size; ++i) {
            lengthSoFar = (i > 0 ? lengthSoFar + 2 : 0) + allNames.get(i).length();
            if (lengthSoFar <= 75) continue;
            return i;
        }
        return size;
    }

    @NotNull
    private static String buildOverridingModulesWarning(List<String> modulesOverridingProjectSettings) {
        int nameCountToShow = KotlinCompilerConfigurableTab.calculateNameCountToShowInWarning(modulesOverridingProjectSettings);
        int allNamesCount = modulesOverridingProjectSettings.size();
        if (nameCountToShow == 0) {
            String string = String.valueOf(allNamesCount) + " modules override project settings";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "buildOverridingModulesWarning"));
            }
            return string;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<html>Following modules override project settings: ");
        CollectionsKt.joinTo(modulesOverridingProjectSettings.subList(0, nameCountToShow), (Appendable)builder, (CharSequence)", ", (CharSequence)"", (CharSequence)"", (int)-1, (CharSequence)"", (Function1)new Function1<String, CharSequence>(){

            public CharSequence invoke(String s) {
                return "<strong>" + s + "</strong>";
            }
        });
        if (nameCountToShow < allNamesCount) {
            builder.append(" and ").append(allNamesCount - nameCountToShow).append(" other(s)");
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "buildOverridingModulesWarning"));
        }
        return string;
    }

    @NotNull
    private static String getModuleKindDescription(@NotNull String moduleKind) {
        if (moduleKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleKind", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "getModuleKindDescription"));
        }
        String result2 = moduleKindDescriptions.get(moduleKind);
        assert (result2 != null) : "Module kind " + moduleKind + " was not added to combobox, therefore it should not be here";
        String string = result2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "getModuleKindDescription"));
        }
        return string;
    }

    @NotNull
    private static String getModuleKindOrDefault(@Nullable String moduleKindId) {
        if (moduleKindId == null) {
            moduleKindId = "plain";
        }
        String string = moduleKindId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "getModuleKindOrDefault"));
        }
        return string;
    }

    private static String getJvmVersionOrDefault(@Nullable String jvmVersion) {
        return jvmVersion != null ? jvmVersion : JvmTarget.DEFAULT.getDescription();
    }

    private static String getLanguageVersionOrDefault(@Nullable String languageVersion) {
        return languageVersion != null ? languageVersion : LanguageVersion.LATEST.getVersionString();
    }

    private static void setupFileChooser(@NotNull JLabel label2, @NotNull TextFieldWithBrowseButton fileChooser, @NotNull String title, boolean forFiles) {
        if (label2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "setupFileChooser"));
        }
        if (fileChooser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileChooser", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "setupFileChooser"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "setupFileChooser"));
        }
        label2.setLabelFor((Component)fileChooser);
        fileChooser.addBrowseFolderListener(title, null, null, new FileChooserDescriptor(forFiles, !forFiles, false, false, false, false), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT, false);
    }

    private static boolean isModified(@NotNull TextFieldWithBrowseButton chooser2, @Nullable String currentValue) {
        if (chooser2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chooser", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "isModified"));
        }
        return !StringUtil.equals((CharSequence)StringUtil.nullize((String)chooser2.getText(), (boolean)true), (CharSequence)currentValue);
    }

    private void updateOutputDirEnabled() {
        if (this.isEnabled) {
            this.outputDirectory.setEnabled(this.copyRuntimeFilesCheckBox.isSelected());
            this.labelForOutputDirectory.setEnabled(this.copyRuntimeFilesCheckBox.isSelected());
        }
    }

    private void restrictAPIVersions() {
        String selectedAPIVersion = this.getSelectedAPIVersion();
        final String selectedLanguageVersion = this.getSelectedLanguageVersion();
        List permittedAPIVersions = ArraysKt.mapNotNull((Object[])LanguageVersion.values(), (Function1)new Function1<LanguageVersion, String>(){

            public String invoke(LanguageVersion version) {
                return VersionComparatorUtil.compare((String)version.getVersionString(), (String)selectedLanguageVersion) <= 0 ? version.getVersionString() : null;
            }
        });
        this.apiVersionComboBox.setModel(new DefaultComboBoxModel<Object>(permittedAPIVersions.toArray()));
        this.apiVersionComboBox.setSelectedItem(VersionComparatorUtil.compare((String)selectedAPIVersion, (String)selectedLanguageVersion) <= 0 ? selectedAPIVersion : selectedLanguageVersion);
    }

    private void fillJvmVersionList() {
        for (TargetPlatformKind.Jvm jvm : TargetPlatformKind.Jvm.Companion.getJVM_PLATFORMS()) {
            this.jvmVersionComboBox.addItem(((JvmTarget)jvm.getVersion()).getDescription());
        }
    }

    private void fillLanguageAndAPIVersionList() {
        for (LanguageVersion version : LanguageVersion.values()) {
            this.languageVersionComboBox.addItem(version.getDescription());
            this.apiVersionComboBox.addItem(version.getDescription());
        }
    }

    private void fillCoroutineSupportList() {
        for (LanguageFeature.State coroutineSupport : languageFeatureStates) {
            this.coroutineSupportComboBox.addItem(coroutineSupport);
        }
        this.coroutineSupportComboBox.setRenderer(new DescriptionListCellRenderer());
    }

    public void setTargetPlatform(@Nullable TargetPlatformKind<?> targetPlatform) {
        this.k2jsPanel.setVisible(TargetPlatformKind.JavaScript.INSTANCE.equals(targetPlatform));
        this.scriptPanel.setVisible(targetPlatform instanceof TargetPlatformKind.Jvm);
    }

    private void fillModuleKindList() {
        for (String moduleKind : moduleKindDescriptions.keySet()) {
            this.moduleKindComboBox.addItem(moduleKind);
        }
        this.moduleKindComboBox.setRenderer(new ListCellRendererWrapper<String>(){

            public void customize(JList list2, String value2, int index2, boolean selected, boolean hasFocus) {
                this.setText(KotlinCompilerConfigurableTab.getModuleKindDescription(value2));
            }
        });
    }

    @NotNull
    public String getId() {
        if ("project.kotlinCompiler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "getId"));
        }
        return "project.kotlinCompiler";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.contentPane;
    }

    public boolean isModified() {
        return ComparingUtils.isModified((JCheckBox)this.reportWarningsCheckBox, (!this.commonCompilerArguments.suppressWarnings ? 1 : 0) != 0) || !this.getSelectedLanguageVersion().equals(KotlinCompilerConfigurableTab.getLanguageVersionOrDefault(this.commonCompilerArguments.languageVersion)) || !this.getSelectedAPIVersion().equals(KotlinCompilerConfigurableTab.getLanguageVersionOrDefault(this.commonCompilerArguments.apiVersion)) || !this.coroutineSupportComboBox.getSelectedItem().equals(CoroutineSupport.byCompilerArguments(this.commonCompilerArguments)) || ComparingUtils.isModified((RawCommandLineEditor)this.additionalArgsOptionsField, (String)this.compilerSettings.additionalArguments) || ComparingUtils.isModified((JTextField)this.scriptTemplatesField, (String)this.compilerSettings.scriptTemplates) || ComparingUtils.isModified((JTextField)this.scriptTemplatesClasspathField, (String)this.compilerSettings.scriptTemplatesClasspath) || ComparingUtils.isModified((JCheckBox)this.copyRuntimeFilesCheckBox, (boolean)this.compilerSettings.copyJsLibraryFiles) || KotlinCompilerConfigurableTab.isModified(this.outputDirectory, this.compilerSettings.outputDirectoryForJsLibraryFiles) || this.compilerWorkspaceSettings != null && (ComparingUtils.isModified((JCheckBox)this.enablePreciseIncrementalCheckBox, (boolean)this.compilerWorkspaceSettings.getPreciseIncrementalEnabled()) || ComparingUtils.isModified((JCheckBox)this.keepAliveCheckBox, (boolean)this.compilerWorkspaceSettings.getEnableDaemon())) || ComparingUtils.isModified((JCheckBox)this.generateSourceMapsCheckBox, (boolean)this.k2jsCompilerArguments.sourceMap) || ComparingUtils.isModified((TextFieldWithBrowseButton)this.outputPrefixFile, (String)this.k2jsCompilerArguments.outputPrefix) || ComparingUtils.isModified((TextFieldWithBrowseButton)this.outputPostfixFile, (String)this.k2jsCompilerArguments.outputPostfix) || !this.getSelectedModuleKind().equals(KotlinCompilerConfigurableTab.getModuleKindOrDefault(this.k2jsCompilerArguments.moduleKind)) || !this.getSelectedJvmVersion().equals(KotlinCompilerConfigurableTab.getJvmVersionOrDefault(this.k2jvmCompilerArguments.jvmTarget));
    }

    @NotNull
    private String getSelectedModuleKind() {
        String string = KotlinCompilerConfigurableTab.getModuleKindOrDefault((String)this.moduleKindComboBox.getSelectedItem());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "getSelectedModuleKind"));
        }
        return string;
    }

    @NotNull
    private String getSelectedJvmVersion() {
        String string = KotlinCompilerConfigurableTab.getJvmVersionOrDefault((String)this.jvmVersionComboBox.getSelectedItem());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "getSelectedJvmVersion"));
        }
        return string;
    }

    @NotNull
    private String getSelectedLanguageVersion() {
        String string = KotlinCompilerConfigurableTab.getLanguageVersionOrDefault((String)this.languageVersionComboBox.getSelectedItem());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "getSelectedLanguageVersion"));
        }
        return string;
    }

    @NotNull
    private String getSelectedAPIVersion() {
        String string = KotlinCompilerConfigurableTab.getLanguageVersionOrDefault((String)this.apiVersionComboBox.getSelectedItem());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab", "getSelectedAPIVersion"));
        }
        return string;
    }

    public void applyTo(CommonCompilerArguments commonCompilerArguments, K2JVMCompilerArguments k2jvmCompilerArguments, K2JSCompilerArguments k2jsCompilerArguments, CompilerSettings compilerSettings) throws ConfigurationException {
        if (this.isProjectSettings) {
            boolean shouldInvalidateCaches;
            boolean bl = shouldInvalidateCaches = commonCompilerArguments.languageVersion != this.getSelectedLanguageVersion() || commonCompilerArguments.apiVersion != this.getSelectedAPIVersion() || !this.coroutineSupportComboBox.getSelectedItem().equals(CoroutineSupport.byCompilerArguments(commonCompilerArguments));
            if (shouldInvalidateCaches) {
                ApplicationUtilsKt.runWriteAction(new Function0<Object>(){

                    public Object invoke() {
                        ProjectRootManagerEx.getInstanceEx((Project)KotlinCompilerConfigurableTab.this.project).makeRootsChange(EmptyRunnable.INSTANCE, false, true);
                        return null;
                    }
                });
            }
        }
        commonCompilerArguments.suppressWarnings = !this.reportWarningsCheckBox.isSelected();
        commonCompilerArguments.languageVersion = this.getSelectedLanguageVersion();
        commonCompilerArguments.apiVersion = this.getSelectedAPIVersion();
        LanguageFeature.State coroutineSupport = (LanguageFeature.State)this.coroutineSupportComboBox.getSelectedItem();
        commonCompilerArguments.coroutinesEnable = coroutineSupport == LanguageFeature.State.ENABLED;
        commonCompilerArguments.coroutinesWarn = coroutineSupport == LanguageFeature.State.ENABLED_WITH_WARNING;
        commonCompilerArguments.coroutinesError = coroutineSupport == LanguageFeature.State.ENABLED_WITH_ERROR || coroutineSupport == LanguageFeature.State.DISABLED;
        compilerSettings.additionalArguments = this.additionalArgsOptionsField.getText();
        compilerSettings.scriptTemplates = this.scriptTemplatesField.getText();
        compilerSettings.scriptTemplatesClasspath = this.scriptTemplatesClasspathField.getText();
        compilerSettings.copyJsLibraryFiles = this.copyRuntimeFilesCheckBox.isSelected();
        compilerSettings.outputDirectoryForJsLibraryFiles = this.outputDirectory.getText();
        if (this.compilerWorkspaceSettings != null) {
            this.compilerWorkspaceSettings.setPreciseIncrementalEnabled(this.enablePreciseIncrementalCheckBox.isSelected());
            boolean oldEnableDaemon = this.compilerWorkspaceSettings.getEnableDaemon();
            this.compilerWorkspaceSettings.setEnableDaemon(this.keepAliveCheckBox.isSelected());
            if (this.keepAliveCheckBox.isSelected() != oldEnableDaemon) {
                PluginStartupComponent.getInstance().resetAliveFlag();
            }
        }
        k2jsCompilerArguments.sourceMap = this.generateSourceMapsCheckBox.isSelected();
        k2jsCompilerArguments.outputPrefix = StringUtil.nullize((String)this.outputPrefixFile.getText(), (boolean)true);
        k2jsCompilerArguments.outputPostfix = StringUtil.nullize((String)this.outputPostfixFile.getText(), (boolean)true);
        k2jsCompilerArguments.moduleKind = this.getSelectedModuleKind();
        k2jvmCompilerArguments.jvmTarget = this.getSelectedJvmVersion();
        if (this.isProjectSettings) {
            KotlinCommonCompilerArgumentsHolder.Companion.getInstance(this.project).setSettings(commonCompilerArguments);
            Kotlin2JvmCompilerArgumentsHolder.Companion.getInstance(this.project).setSettings(k2jvmCompilerArguments);
            Kotlin2JsCompilerArgumentsHolder.Companion.getInstance(this.project).setSettings(k2jsCompilerArguments);
            KotlinCompilerSettings.Companion.getInstance(this.project).setSettings(compilerSettings);
        }
        BuildManager.getInstance().clearState(this.project);
    }

    public void apply() throws ConfigurationException {
        this.applyTo(this.commonCompilerArguments, this.k2jvmCompilerArguments, this.k2jsCompilerArguments, this.compilerSettings);
    }

    public void reset() {
        this.reportWarningsCheckBox.setSelected(!this.commonCompilerArguments.suppressWarnings);
        this.languageVersionComboBox.setSelectedItem(KotlinCompilerConfigurableTab.getLanguageVersionOrDefault(this.commonCompilerArguments.languageVersion));
        this.apiVersionComboBox.setSelectedItem(KotlinCompilerConfigurableTab.getLanguageVersionOrDefault(this.commonCompilerArguments.apiVersion));
        this.restrictAPIVersions();
        this.coroutineSupportComboBox.setSelectedItem(CoroutineSupport.byCompilerArguments(this.commonCompilerArguments));
        this.additionalArgsOptionsField.setText(this.compilerSettings.additionalArguments);
        this.scriptTemplatesField.setText(this.compilerSettings.scriptTemplates);
        this.scriptTemplatesClasspathField.setText(this.compilerSettings.scriptTemplatesClasspath);
        this.copyRuntimeFilesCheckBox.setSelected(this.compilerSettings.copyJsLibraryFiles);
        this.outputDirectory.setText(this.compilerSettings.outputDirectoryForJsLibraryFiles);
        if (this.compilerWorkspaceSettings != null) {
            this.enablePreciseIncrementalCheckBox.setSelected(this.compilerWorkspaceSettings.getPreciseIncrementalEnabled());
            this.keepAliveCheckBox.setSelected(this.compilerWorkspaceSettings.getEnableDaemon());
        }
        this.generateSourceMapsCheckBox.setSelected(this.k2jsCompilerArguments.sourceMap);
        this.outputPrefixFile.setText(this.k2jsCompilerArguments.outputPrefix);
        this.outputPostfixFile.setText(this.k2jsCompilerArguments.outputPostfix);
        this.moduleKindComboBox.setSelectedItem(KotlinCompilerConfigurableTab.getModuleKindOrDefault(this.k2jsCompilerArguments.moduleKind));
        this.jvmVersionComboBox.setSelectedItem(KotlinCompilerConfigurableTab.getJvmVersionOrDefault(this.k2jvmCompilerArguments.jvmTarget));
    }

    public void disposeUIResources() {
    }

    @Nls
    public String getDisplayName() {
        return "Kotlin Compiler";
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.compiler.kotlin";
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    public ThreeStateCheckBox getReportWarningsCheckBox() {
        return this.reportWarningsCheckBox;
    }

    public RawCommandLineEditor getAdditionalArgsOptionsField() {
        return this.additionalArgsOptionsField;
    }

    public ThreeStateCheckBox getGenerateSourceMapsCheckBox() {
        return this.generateSourceMapsCheckBox;
    }

    public TextFieldWithBrowseButton getOutputPrefixFile() {
        return this.outputPrefixFile;
    }

    public TextFieldWithBrowseButton getOutputPostfixFile() {
        return this.outputPostfixFile;
    }

    public TextFieldWithBrowseButton getOutputDirectory() {
        return this.outputDirectory;
    }

    public ThreeStateCheckBox getCopyRuntimeFilesCheckBox() {
        return this.copyRuntimeFilesCheckBox;
    }

    public ThreeStateCheckBox getKeepAliveCheckBox() {
        return this.keepAliveCheckBox;
    }

    public JComboBox getModuleKindComboBox() {
        return this.moduleKindComboBox;
    }

    public JTextField getScriptTemplatesField() {
        return this.scriptTemplatesField;
    }

    public JTextField getScriptTemplatesClasspathField() {
        return this.scriptTemplatesClasspathField;
    }

    public JComboBox getLanguageVersionComboBox() {
        return this.languageVersionComboBox;
    }

    public JComboBox getApiVersionComboBox() {
        return this.apiVersionComboBox;
    }

    public JComboBox getCoroutineSupportComboBox() {
        return this.coroutineSupportComboBox;
    }

    public void setEnabled(boolean value2) {
        this.isEnabled = value2;
        UIUtil.setEnabled((Component)this.getContentPane(), (boolean)value2, (boolean)true);
        this.updateOutputDirEnabled();
    }

    public CommonCompilerArguments getCommonCompilerArguments() {
        return this.commonCompilerArguments;
    }

    public void setCommonCompilerArguments(CommonCompilerArguments commonCompilerArguments) {
        this.commonCompilerArguments = commonCompilerArguments;
    }

    public K2JSCompilerArguments getK2jsCompilerArguments() {
        return this.k2jsCompilerArguments;
    }

    public void setK2jsCompilerArguments(K2JSCompilerArguments k2jsCompilerArguments) {
        this.k2jsCompilerArguments = k2jsCompilerArguments;
    }

    public K2JVMCompilerArguments getK2jvmCompilerArguments() {
        return this.k2jvmCompilerArguments;
    }

    public void setK2jvmCompilerArguments(K2JVMCompilerArguments k2jvmCompilerArguments) {
        this.k2jvmCompilerArguments = k2jvmCompilerArguments;
    }

    public CompilerSettings getCompilerSettings() {
        return this.compilerSettings;
    }

    public void setCompilerSettings(CompilerSettings compilerSettings) {
        this.compilerSettings = compilerSettings;
    }

    static {
        moduleKindDescriptions.put("plain", "Plain (put to global scope)");
        moduleKindDescriptions.put("amd", "AMD");
        moduleKindDescriptions.put("commonjs", "CommonJS");
        moduleKindDescriptions.put("umd", "UMD (detect AMD or CommonJS if available, fallback to plain)");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ThreeStateCheckBox threeStateCheckBox;
        RawCommandLineEditor rawCommandLineEditor;
        JLabel jLabel;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JComboBox jComboBox3;
        ThreeStateCheckBox threeStateCheckBox2;
        JComboBox jComboBox4;
        JCheckBox jCheckBox;
        JPanel jPanel;
        JLabel jLabel2;
        JTextField jTextField;
        JLabel jLabel3;
        JTextField jTextField2;
        JLabel jLabel4;
        JPanel jPanel2;
        ThreeStateCheckBox threeStateCheckBox3;
        JComboBox jComboBox5;
        ThreeStateCheckBox threeStateCheckBox4;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel5;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JLabel jLabel6;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JLabel jLabel7;
        JPanel jPanel3;
        JPanel jPanel4;
        this.contentPane = jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(12, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), null, 0, 0, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(11, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.k2jsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel3).setVisible(true);
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel4.add((Component)jPanel3, new GridConstraints(8, 0, 1, 2, 1, 1, 3, 3, null, null, null, 0, true));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.panel.title"), (int)0, (int)0, null, null));
        this.labelForOutputPrefixFile = jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.output.prefix"));
        jPanel3.add((Component)jLabel7, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.outputPrefixFile = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton3, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.labelForOutputPostfixFile = jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.output.postfix"));
        jPanel3.add((Component)jLabel6, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.outputPostfixFile = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.labelForOutputDirectory = jLabel5 = new JLabel();
        jLabel5.setText("Destination directory");
        jLabel5.setDisplayedMnemonic('D');
        jLabel5.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.outputDirectory = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("lib");
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.copyRuntimeFilesCheckBox = threeStateCheckBox4 = new ThreeStateCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)threeStateCheckBox4, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.output.copy.files"));
        threeStateCheckBox4.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        jPanel3.add((Component)threeStateCheckBox4, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Module kind:");
        jLabel8.setDisplayedMnemonic('K');
        jLabel8.setDisplayedMnemonicIndex(7);
        jPanel3.add((Component)jLabel8, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.moduleKindComboBox = jComboBox5 = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox5.setModel(defaultComboBoxModel);
        jPanel3.add(jComboBox5, new GridConstraints(5, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.generateSourceMapsCheckBox = threeStateCheckBox3 = new ThreeStateCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)threeStateCheckBox3, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.js.option.generate.sourcemaps"));
        threeStateCheckBox3.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        jPanel3.add((Component)threeStateCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.scriptPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setVisible(true);
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel4.add((Component)jPanel2, new GridConstraints(9, 0, 1, 2, 1, 1, 3, 3, null, null, null, 0, true));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Kotlin Scripting", (int)0, (int)0, null, null));
        this.scriptTemplatesLabel = jLabel4 = new JLabel();
        jLabel4.setText("Script template classes:");
        jLabel4.setDisplayedMnemonic('T');
        jLabel4.setDisplayedMnemonicIndex(7);
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.scriptTemplatesField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.scriptTemplatesClasspathLabel = jLabel3 = new JLabel();
        jLabel3.setText("Script templates classpath:");
        jLabel3.setDisplayedMnemonic('P');
        jLabel3.setDisplayedMnemonicIndex(22);
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.scriptTemplatesClasspathField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.warningLabel = jLabel2 = new JLabel();
        jLabel2.setInheritsPopupMenu(false);
        jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/general/warningDialog.png")));
        jLabel2.setFocusable(false);
        ((Component)jLabel2).setVisible(false);
        jLabel2.setText("");
        jPanel5.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.k2jvmPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setVisible(true);
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel4.add((Component)jPanel, new GridConstraints(7, 0, 1, 2, 1, 1, 3, 3, null, null, null, 0, true));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.jvm.option.panel.title"), (int)0, (int)0, null, null));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Target JVM version");
        jLabel9.setDisplayedMnemonic('J');
        jLabel9.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jLabel9, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.enablePreciseIncrementalCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable precise incremental compilation");
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.jvmVersionComboBox = jComboBox4 = new JComboBox();
        jPanel.add(jComboBox4, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.reportWarningsCheckBox = threeStateCheckBox2 = new ThreeStateCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)threeStateCheckBox2, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.option.generate.no.warnings"));
        threeStateCheckBox2.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        threeStateCheckBox2.setSelected(false);
        jPanel6.add((Component)threeStateCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel7, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("Language version");
        jLabel10.setDisplayedMnemonic('L');
        jLabel10.setDisplayedMnemonicIndex(0);
        jPanel7.add((Component)jLabel10, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.languageVersionComboBox = jComboBox3 = new JComboBox();
        jPanel7.add(jComboBox3, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel8, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("API version");
        jLabel11.setDisplayedMnemonic('I');
        jLabel11.setDisplayedMnemonicIndex(2);
        jPanel8.add((Component)jLabel11, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.apiVersionComboBox = jComboBox2 = new JComboBox();
        jPanel8.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel9, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel12 = new JLabel();
        jLabel12.setText("Coroutines (experimental)");
        jLabel12.setDisplayedMnemonic('U');
        jLabel12.setDisplayedMnemonicIndex(4);
        jPanel9.add((Component)jLabel12, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.coroutineSupportComboBox = jComboBox = new JComboBox();
        jPanel9.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.additionalArgsLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/kotlin/idea/KotlinBundle").getString("kotlin.compiler.option.additional.command.line.parameters"));
        jPanel4.add((Component)jLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.additionalArgsOptionsField = rawCommandLineEditor = new RawCommandLineEditor();
        jPanel4.add((Component)rawCommandLineEditor, new GridConstraints(5, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.keepAliveCheckBox = threeStateCheckBox = new ThreeStateCheckBox();
        threeStateCheckBox.setText("Keep compiler process alive between invocations");
        threeStateCheckBox.setState(ThreeStateCheckBox.State.NOT_SELECTED);
        jPanel4.add((Component)threeStateCheckBox, new GridConstraints(6, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        jLabel8.setLabelFor(jComboBox5);
        jLabel4.setLabelFor(jTextField2);
        jLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

