/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinWithLibraryConfigurator;
import org.jetbrains.kotlin.idea.configuration.RuntimeLibraryFiles;
import org.jetbrains.kotlin.idea.framework.KotlinLibraryUtilKt;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.PathUtil;

public class KotlinJsModuleConfigurator
extends KotlinWithLibraryConfigurator {
    public static final String NAME = "js";

    @Override
    @NotNull
    public String getName() {
        if (NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator", "getName"));
        }
        return NAME;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        JsPlatform jsPlatform = JsPlatform.INSTANCE;
        if (jsPlatform == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator", "getTargetPlatform"));
        }
        return jsPlatform;
    }

    @Override
    @NotNull
    public String getPresentableText() {
        if ("JavaScript" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator", "getPresentableText"));
        }
        return "JavaScript";
    }

    @Override
    public boolean isConfigured(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator", "isConfigured"));
        }
        return ConfigureKotlinInProjectUtilsKt.hasKotlinJsRuntimeInScope(module);
    }

    @Override
    @NotNull
    protected String getLibraryName() {
        if ("KotlinJavaScript" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator", "getLibraryName"));
        }
        return "KotlinJavaScript";
    }

    @Override
    @NotNull
    protected String getDialogTitle() {
        if ("Create Kotlin JavaScript Library" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator", "getDialogTitle"));
        }
        return "Create Kotlin JavaScript Library";
    }

    @Override
    @NotNull
    protected String getLibraryCaption() {
        if ("Kotlin JavaScript Library" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator", "getLibraryCaption"));
        }
        return "Kotlin JavaScript Library";
    }

    @Override
    @NotNull
    protected String getMessageForOverrideDialog() {
        if ("JavaScript Library Creation" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator", "getMessageForOverrideDialog"));
        }
        return "JavaScript Library Creation";
    }

    @Override
    @NotNull
    public RuntimeLibraryFiles getExistingJarFiles() {
        KotlinPaths paths = PathUtil.getKotlinPathsForIdeaPlugin();
        RuntimeLibraryFiles runtimeLibraryFiles = new RuntimeLibraryFiles(this.assertFileExists(paths.getJsStdLibJarPath()), null, this.assertFileExists(paths.getJsStdLibSrcJarPath()));
        if (runtimeLibraryFiles == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator", "getExistingJarFiles"));
        }
        return runtimeLibraryFiles;
    }

    KotlinJsModuleConfigurator() {
    }

    @Override
    @Nullable
    protected String getOldSourceRootUrl(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator", "getOldSourceRootUrl"));
        }
        VirtualFile jsStdLibJar = KotlinLibraryUtilKt.getJsStdLibJar(library);
        return jsStdLibJar != null ? jsStdLibJar.getUrl() : null;
    }
}

