/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentUtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.compilerRunner.ArgumentUtils;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.CoroutineSupport;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinFacetSettingsKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.TargetPlatformKind;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JsCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.Kotlin2JvmCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCommonCompilerArgumentsHolder;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerSettings;
import org.jetbrains.kotlin.idea.facet.FacetUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.facet.KotlinFacetType;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000^\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002\u001a*\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010 \u001a\u00020!\u001a0\u0010\"\u001a\u00020\u001d*\u00020!2\u0006\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00102\u0006\u0010'\u001a\u00020(\u001a\u001a\u0010)\u001a\u00020!*\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0006\u0010*\u001a\u00020+\u001a\u0018\u0010,\u001a\u0004\u0018\u00010\u0014*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010-\u001a\u00020.\u001a,\u0010/\u001a\u00020\u001d*\u0002002\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u000e\b\u0002\u0010&\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0005\"\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0005\"\u001f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00061"}, d2={"commonPrimaryFields", "", "", "commonUIExposedFields", "getCommonUIExposedFields", "()Ljava/util/List;", "commonUIHiddenFields", "jsPrimaryFields", "jsSpecificUIExposedFields", "jsUIExposedFields", "getJsUIExposedFields", "jvmPrimaryFields", "jvmSpecificUIExposedFields", "jvmUIExposedFields", "getJvmUIExposedFields", "mavenLibraryIds", "Lorg/jetbrains/kotlin/config/TargetPlatformKind;", "getMavenLibraryIds", "(Lorg/jetbrains/kotlin/config/TargetPlatformKind;)Ljava/util/List;", "primaryFields", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "getPrimaryFields", "(Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;)Ljava/util/List;", "getDefaultTargetPlatform", "module", "Lcom/intellij/openapi/module/Module;", "rootModel", "Lcom/intellij/openapi/roots/ModuleRootModel;", "parseCompilerArgumentsToFacet", "", "arguments", "defaultArguments", "kotlinFacet", "Lorg/jetbrains/kotlin/idea/facet/KotlinFacet;", "configureFacet", "compilerVersion", "coroutineSupport", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "platformKind", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "getOrCreateFacet", "useProjectSettings", "", "getPlatformCompilerArgumentsByProject", "project", "Lcom/intellij/openapi/project/Project;", "initializeIfNeeded", "Lorg/jetbrains/kotlin/config/KotlinFacetSettings;", "idea"})
public final class FacetUtilsKt {
    @NotNull
    private static final List<String> commonUIExposedFields = CollectionsKt.listOf((Object[])new String[]{"languageVersion", "apiVersion", "suppressWarnings", "coroutinesEnable", "coroutinesWarn", "coroutinesError"});
    private static final List<String> commonUIHiddenFields = CollectionsKt.listOf((Object[])new String[]{"pluginClasspaths", "pluginOptions"});
    private static final List<String> commonPrimaryFields = CollectionsKt.plus((Collection)commonUIExposedFields, (Iterable)commonUIHiddenFields);
    private static final List<String> jvmSpecificUIExposedFields = CollectionsKt.listOf((Object[])new String[]{"jvmTarget", "destination", "classpath"});
    @NotNull
    private static final List<String> jvmUIExposedFields = CollectionsKt.plus((Collection)commonUIExposedFields, (Iterable)jvmSpecificUIExposedFields);
    private static final List<String> jvmPrimaryFields = CollectionsKt.plus((Collection)commonPrimaryFields, (Iterable)jvmSpecificUIExposedFields);
    private static final List<String> jsSpecificUIExposedFields = CollectionsKt.listOf((Object[])new String[]{"sourceMap", "outputPrefix", "outputPostfix", "moduleKind"});
    @NotNull
    private static final List<String> jsUIExposedFields = CollectionsKt.plus((Collection)commonUIExposedFields, (Iterable)jsSpecificUIExposedFields);
    private static final List<String> jsPrimaryFields = CollectionsKt.plus((Collection)commonPrimaryFields, (Iterable)jsSpecificUIExposedFields);

    private static final TargetPlatformKind<?> getDefaultTargetPlatform(Module module, ModuleRootModel rootModel) {
        JavaSdkVersion javaSdkVersion;
        Sdk sdk;
        Collection<String> collection = KotlinVersionInfoProviderKt.getRuntimeLibraryVersions(module, rootModel, TargetPlatformKind.JavaScript.INSTANCE);
        if (!collection.isEmpty()) {
            return TargetPlatformKind.JavaScript.INSTANCE;
        }
        collection = KotlinVersionInfoProviderKt.getRuntimeLibraryVersions(module, rootModel, TargetPlatformKind.Common.INSTANCE);
        if (!collection.isEmpty()) {
            return TargetPlatformKind.Common.INSTANCE;
        }
        ModuleRootModel moduleRootModel = rootModel;
        if (moduleRootModel == null) {
            moduleRootModel = (ModuleRootModel)ModuleRootManager.getInstance((Module)module);
        }
        Sdk sdk2 = sdk = moduleRootModel.getSdk();
        Object object = sdk2 != null ? sdk2.getSdkType() : null;
        if (!(object instanceof JavaSdk)) {
            object = null;
        }
        JavaSdk javaSdk = (JavaSdk)object;
        if (javaSdk != null) {
            Sdk sdk3 = sdk;
            if (sdk3 == null) {
                Intrinsics.throwNpe();
            }
            javaSdkVersion = javaSdk.getVersion(sdk3);
        } else {
            javaSdkVersion = null;
        }
        JavaSdkVersion sdkVersion = javaSdkVersion;
        return sdkVersion == null || sdkVersion.compareTo((Enum)JavaSdkVersion.JDK_1_8) >= 0 ? (TargetPlatformKind)TargetPlatformKind.Jvm.Companion.get(JvmTarget.JVM_1_8) : (TargetPlatformKind)TargetPlatformKind.Jvm.Companion.get(JvmTarget.JVM_1_6);
    }

    public static final void initializeIfNeeded(@NotNull KotlinFacetSettings $receiver, @NotNull Module module, @Nullable ModuleRootModel rootModel, @Nullable TargetPlatformKind<?> platformKind) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Project project = module.getProject();
        if ($receiver.getCompilerSettings() == null) {
            Project project2 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
            $receiver.setCompilerSettings((CompilerSettings)KotlinCompilerSettings.Companion.getInstance(project2).getSettings());
        }
        Project project3 = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"module.project");
        CommonCompilerArguments commonArguments = (CommonCompilerArguments)KotlinCommonCompilerArgumentsHolder.Companion.getInstance(project3).getSettings();
        if ($receiver.getCompilerArguments() == null) {
            TargetPlatformKind<?> targetPlatformKind = platformKind;
            if (targetPlatformKind == null) {
                targetPlatformKind = FacetUtilsKt.getDefaultTargetPlatform(module, rootModel);
            }
            TargetPlatformKind<?> targetPlatformKind2 = targetPlatformKind;
            CommonCompilerArguments commonCompilerArguments = KotlinFacetSettingsKt.createCompilerArguments(targetPlatformKind2);
            KotlinFacetSettings kotlinFacetSettings = $receiver;
            CommonCompilerArguments $receiver2 = commonCompilerArguments;
            Project project4 = module.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"module.project");
            CommonCompilerArguments commonCompilerArguments2 = FacetUtilsKt.getPlatformCompilerArgumentsByProject(targetPlatformKind2, project4);
            if (commonCompilerArguments2 != null) {
                CommonCompilerArguments commonCompilerArguments3;
                CommonCompilerArguments it = commonCompilerArguments3 = commonCompilerArguments2;
                ArgumentUtilsKt.mergeBeans(it, $receiver2);
            }
            ArgumentUtilsKt.mergeBeans(commonArguments, $receiver2);
            CommonCompilerArguments commonCompilerArguments4 = commonCompilerArguments;
            kotlinFacetSettings.setCompilerArguments(commonCompilerArguments4);
        }
        if ($receiver.getLanguageLevel() == null) {
            LanguageVersion languageVersion = $receiver.getUseProjectSettings() ? LanguageVersion.Companion.fromVersionString(commonArguments.languageVersion) : null;
            if (languageVersion == null) {
                languageVersion = KotlinVersionInfoProviderKt.getDefaultLanguageLevel$default(module, null, 2, null);
            }
            $receiver.setLanguageLevel(languageVersion);
        }
        if ($receiver.getApiLevel() == null) {
            LanguageVersion languageVersion;
            if ($receiver.getUseProjectSettings()) {
                languageVersion = LanguageVersion.Companion.fromVersionString(commonArguments.apiVersion);
                if (languageVersion == null) {
                    languageVersion = $receiver.getLanguageLevel();
                }
            } else {
                LanguageVersion languageVersion2 = $receiver.getLanguageLevel();
                if (languageVersion2 == null) {
                    Intrinsics.throwNpe();
                }
                Comparable comparable = (Comparable)((Object)languageVersion2);
                TargetPlatformKind<?> targetPlatformKind = $receiver.getTargetPlatformKind();
                if (targetPlatformKind == null) {
                    Intrinsics.throwNpe();
                }
                languageVersion = (LanguageVersion)((Object)RangesKt.coerceAtMost((Comparable)comparable, (Comparable)((Comparable)((Object)KotlinVersionInfoProviderKt.getLibraryLanguageLevel(module, rootModel, targetPlatformKind)))));
            }
            $receiver.setApiLevel(languageVersion);
        }
    }

    public static /* bridge */ /* synthetic */ void initializeIfNeeded$default(KotlinFacetSettings kotlinFacetSettings, Module module, ModuleRootModel moduleRootModel, TargetPlatformKind targetPlatformKind, int n, Object object) {
        if ((n & 4) != 0) {
            targetPlatformKind = null;
        }
        FacetUtilsKt.initializeIfNeeded(kotlinFacetSettings, module, moduleRootModel, targetPlatformKind);
    }

    @Nullable
    public static final CommonCompilerArguments getPlatformCompilerArgumentsByProject(@NotNull TargetPlatformKind<?> $receiver, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        TargetPlatformKind<?> targetPlatformKind = $receiver;
        return targetPlatformKind instanceof TargetPlatformKind.Jvm ? (CommonCompilerArguments)Kotlin2JvmCompilerArgumentsHolder.Companion.getInstance(project).getSettings() : (targetPlatformKind instanceof TargetPlatformKind.JavaScript ? (CommonCompilerArguments)Kotlin2JsCompilerArgumentsHolder.Companion.getInstance(project).getSettings() : null);
    }

    @NotNull
    public static final List<String> getMavenLibraryIds(@NotNull TargetPlatformKind<?> $receiver) {
        List list2;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        TargetPlatformKind<?> targetPlatformKind = $receiver;
        if (targetPlatformKind instanceof TargetPlatformKind.Jvm) {
            list2 = CollectionsKt.listOf((Object[])new String[]{KotlinRuntimeLibraryUtilKt.getMAVEN_STDLIB_ID(), KotlinRuntimeLibraryUtilKt.getMAVEN_STDLIB_ID_JRE7(), KotlinRuntimeLibraryUtilKt.getMAVEN_STDLIB_ID_JRE8()});
        } else if (targetPlatformKind instanceof TargetPlatformKind.JavaScript) {
            list2 = CollectionsKt.listOf((Object[])new String[]{KotlinRuntimeLibraryUtilKt.getMAVEN_JS_STDLIB_ID(), KotlinRuntimeLibraryUtilKt.getMAVEN_OLD_JS_STDLIB_ID()});
        } else if (targetPlatformKind instanceof TargetPlatformKind.Common) {
            list2 = CollectionsKt.listOf((Object)KotlinRuntimeLibraryUtilKt.getMAVEN_COMMON_STDLIB_ID());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list2;
    }

    @NotNull
    public static final KotlinFacet getOrCreateFacet(@NotNull Module $receiver, @NotNull IdeModifiableModelsProvider modelsProvider, boolean useProjectSettings) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        ModifiableFacetModel facetModel = modelsProvider.getModifiableFacetModel($receiver);
        Object object = (KotlinFacet)facetModel.findFacet(KotlinFacetType.Companion.getTYPE_ID(), KotlinFacetType.Companion.getINSTANCE().getDefaultFacetName());
        if (object == null) {
            Object object2;
            KotlinFacetType $receiver2 = object2 = KotlinFacetType.Companion.getINSTANCE();
            String string = $receiver2.getDefaultFacetName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"defaultFacetName");
            $receiver2 = object2 = $receiver2.createFacet($receiver, string, $receiver2.createDefaultConfiguration(), (Facet<?>)null);
            facetModel.addFacet((Facet)$receiver2);
            object = object2;
        }
        KotlinFacet facet = object;
        ((KotlinFacetConfiguration)facet.getConfiguration()).getSettings().setUseProjectSettings(useProjectSettings);
        KotlinFacet kotlinFacet = facet;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kotlinFacet), (String)"facet");
        return kotlinFacet;
    }

    public static final void configureFacet(@NotNull KotlinFacet $receiver, @NotNull String compilerVersion, @NotNull LanguageFeature.State coroutineSupport, @Nullable TargetPlatformKind<?> platformKind, @NotNull IdeModifiableModelsProvider modelsProvider) {
        KotlinFacetSettings kotlinFacetSettings;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)compilerVersion, (String)"compilerVersion");
        Intrinsics.checkParameterIsNotNull((Object)coroutineSupport, (String)"coroutineSupport");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        Module module = $receiver.getModule();
        KotlinFacetSettings $receiver2 = kotlinFacetSettings = ((KotlinFacetConfiguration)$receiver.getConfiguration()).getSettings();
        $receiver2.setCompilerArguments(null);
        $receiver2.setCompilerSettings(null);
        Module module2 = module;
        Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
        FacetUtilsKt.initializeIfNeeded($receiver2, module2, (ModuleRootModel)modelsProvider.getModifiableRootModel(module), platformKind);
        LanguageVersion languageVersion = LanguageVersion.Companion.fromFullVersionString(compilerVersion);
        if (languageVersion == null) {
            languageVersion = LanguageVersion.LATEST;
        }
        $receiver2.setLanguageLevel(languageVersion);
        LanguageVersion languageVersion2 = $receiver2.getApiLevel();
        if (languageVersion2 == null) {
            Intrinsics.throwNpe();
        }
        LanguageVersion languageVersion3 = $receiver2.getLanguageLevel();
        if (languageVersion3 == null) {
            Intrinsics.throwNpe();
        }
        if (languageVersion2.compareTo((Enum)languageVersion3) > 0) {
            $receiver2.setApiLevel($receiver2.getLanguageLevel());
        }
        $receiver2.setCoroutineSupport(coroutineSupport);
    }

    @NotNull
    public static final List<String> getCommonUIExposedFields() {
        return commonUIExposedFields;
    }

    @NotNull
    public static final List<String> getJvmUIExposedFields() {
        return jvmUIExposedFields;
    }

    @NotNull
    public static final List<String> getJsUIExposedFields() {
        return jsUIExposedFields;
    }

    private static final List<String> getPrimaryFields(@NotNull CommonCompilerArguments $receiver) {
        CommonCompilerArguments commonCompilerArguments = $receiver;
        return commonCompilerArguments instanceof K2JVMCompilerArguments ? jvmPrimaryFields : (commonCompilerArguments instanceof K2JSCompilerArguments ? jsPrimaryFields : commonPrimaryFields);
    }

    public static final void parseCompilerArgumentsToFacet(@NotNull List<String> arguments2, @NotNull List<String> defaultArguments, @NotNull KotlinFacet kotlinFacet) {
        Collection $receiver$iv;
        KotlinFacetSettings kotlinFacetSettings;
        Collection $receiver$iv2;
        Intrinsics.checkParameterIsNotNull(arguments2, (String)"arguments");
        Intrinsics.checkParameterIsNotNull(defaultArguments, (String)"defaultArguments");
        Intrinsics.checkParameterIsNotNull((Object)((Object)kotlinFacet), (String)"kotlinFacet");
        Collection thisCollection$iv = $receiver$iv2 = (Collection)arguments2;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] argumentArray = stringArray;
        KotlinFacetSettings $receiver = kotlinFacetSettings = ((KotlinFacetConfiguration)kotlinFacet.getConfiguration()).getSettings();
        CommonCompilerArguments commonCompilerArguments = $receiver.getCompilerArguments();
        if (commonCompilerArguments == null) {
            return;
        }
        CommonCompilerArguments compilerArguments = commonCompilerArguments;
        CommonCompilerArguments defaultCompilerArguments = (CommonCompilerArguments)compilerArguments.getClass().newInstance();
        Collection thisCollection$iv2 = $receiver$iv = (Collection)defaultArguments;
        String[] stringArray2 = thisCollection$iv2.toArray(new String[thisCollection$iv2.size()]);
        if (stringArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        ArgumentUtilsKt.parseArguments(stringArray2, defaultCompilerArguments, true);
        LanguageFeature.State oldCoroutineSupport = CoroutineSupport.byCompilerArguments(compilerArguments);
        compilerArguments.coroutinesEnable = false;
        compilerArguments.coroutinesWarn = false;
        compilerArguments.coroutinesError = false;
        ArgumentUtilsKt.parseArguments(argumentArray, compilerArguments, true);
        boolean restoreCoroutineSupport = !compilerArguments.coroutinesEnable && !compilerArguments.coroutinesWarn && !compilerArguments.coroutinesError;
        List<String> primaryFields = FacetUtilsKt.getPrimaryFields(compilerArguments);
        Function1<Field, Boolean> exposeAsAdditionalArgument$ = new Function1<Field, Boolean>(primaryFields, compilerArguments, defaultCompilerArguments){
            final /* synthetic */ List $primaryFields;
            final /* synthetic */ CommonCompilerArguments $compilerArguments;
            final /* synthetic */ CommonCompilerArguments $defaultCompilerArguments;

            public final boolean invoke(@NotNull Field field2) {
                Intrinsics.checkParameterIsNotNull((Object)field2, (String)"field");
                return this.$primaryFields.contains(field2.getName()) ^ true && Intrinsics.areEqual((Object)field2.get(this.$compilerArguments), (Object)field2.get(this.$defaultCompilerArguments)) ^ true;
            }
            {
                this.$primaryFields = list2;
                this.$compilerArguments = commonCompilerArguments;
                this.$defaultCompilerArguments = commonCompilerArguments2;
                super(1);
            }
        };
        Object object = compilerArguments.getClass().newInstance();
        CommonCompilerArguments $receiver2 = (CommonCompilerArguments)object;
        ArgumentUtilsKt.copyFieldsSatisfying(compilerArguments, $receiver2, (Function1<? super Field, Boolean>)((Function1)new Function1<Field, Boolean>(compilerArguments, exposeAsAdditionalArgument$){
            final /* synthetic */ CommonCompilerArguments $compilerArguments$inlined;
            final /* synthetic */ parseCompilerArgumentsToFacet.1.1 $exposeAsAdditionalArgument$inlined;
            {
                this.$compilerArguments$inlined = commonCompilerArguments;
                this.$exposeAsAdditionalArgument$inlined = var2_2;
                super(1);
            }

            public final boolean invoke(Field p1) {
                return this.$exposeAsAdditionalArgument$inlined.invoke(p1);
            }

            public final KDeclarationContainer getOwner() {
                return null;
            }

            public final String getName() {
                return "exposeAsAdditionalArgument";
            }

            public final String getSignature() {
                return "invoke(Ljava/lang/reflect/Field;)Z";
            }
        }));
        String additionalArgumentsString2 = CollectionsKt.joinToString$default((Iterable)ArgumentUtils.convertArgumentsToStringList($receiver2), (CharSequence)" ", null, null, (int)0, null, (Function1)parseCompilerArgumentsToFacet.1.additionalArgumentsString.1.2.INSTANCE, (int)30, null);
        CompilerSettings compilerSettings = $receiver.getCompilerSettings();
        if (compilerSettings != null) {
            object = additionalArgumentsString2;
            CompilerSettings compilerSettings2 = compilerSettings;
            boolean bl = object.length() > 0;
            compilerSettings2.additionalArguments = bl ? additionalArgumentsString2 : CompilerSettings.Companion.getDEFAULT_ADDITIONAL_ARGUMENTS();
        }
        object = compilerArguments.getClass().newInstance();
        $receiver2 = (CommonCompilerArguments)object;
        ArgumentUtilsKt.copyFieldsSatisfying($receiver2, compilerArguments, (Function1<? super Field, Boolean>)((Function1)new Function1<Field, Boolean>(compilerArguments, exposeAsAdditionalArgument$){
            final /* synthetic */ CommonCompilerArguments $compilerArguments$inlined;
            final /* synthetic */ parseCompilerArgumentsToFacet.1.1 $exposeAsAdditionalArgument$inlined;
            {
                this.$compilerArguments$inlined = commonCompilerArguments;
                this.$exposeAsAdditionalArgument$inlined = var2_2;
                super(1);
            }

            public final boolean invoke(Field p1) {
                return this.$exposeAsAdditionalArgument$inlined.invoke(p1);
            }

            public final KDeclarationContainer getOwner() {
                return null;
            }

            public final String getName() {
                return "exposeAsAdditionalArgument";
            }

            public final String getSignature() {
                return "invoke(Ljava/lang/reflect/Field;)Z";
            }
        }));
        if (restoreCoroutineSupport) {
            $receiver.setCoroutineSupport(oldCoroutineSupport);
        }
    }
}

