/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.framework.FrameworksCompatibilityUtils;
import org.jetbrains.kotlin.idea.framework.JSFrameworkType;
import org.jetbrains.kotlin.idea.framework.JSLibraryStdDescription;
import org.jetbrains.kotlin.idea.framework.JavaFrameworkType;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeLibraryDescription;

public class JSFrameworkSupportProvider
extends FrameworkSupportInModuleProvider {
    @NotNull
    public FrameworkTypeEx getFrameworkType() {
        JSFrameworkType jSFrameworkType = JSFrameworkType.getInstance();
        if (jSFrameworkType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/framework/JSFrameworkSupportProvider", "getFrameworkType"));
        }
        return jSFrameworkType;
    }

    @NotNull
    public FrameworkSupportInModuleConfigurable createConfigurable(final @NotNull FrameworkSupportModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/kotlin/idea/framework/JSFrameworkSupportProvider", "createConfigurable"));
        }
        FrameworkSupportInModuleConfigurable frameworkSupportInModuleConfigurable = new FrameworkSupportInModuleConfigurable(){
            public JSLibraryStdDescription description;

            @Nullable
            public CustomLibraryDescription createLibraryDescription() {
                this.description = new JSLibraryStdDescription(model.getProject());
                return this.description;
            }

            @Nullable
            public JComponent createComponent() {
                return null;
            }

            public boolean isOnlyLibraryAdded() {
                return true;
            }

            public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider) {
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/kotlin/idea/framework/JSFrameworkSupportProvider$1", "addSupport"));
                }
                if (rootModel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "org/jetbrains/kotlin/idea/framework/JSFrameworkSupportProvider$1", "addSupport"));
                }
                if (modifiableModelsProvider == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiableModelsProvider", "org/jetbrains/kotlin/idea/framework/JSFrameworkSupportProvider$1", "addSupport"));
                }
                FrameworksCompatibilityUtils.suggestRemoveIncompatibleFramework(rootModel, JavaRuntimeLibraryDescription.SUITABLE_LIBRARY_KINDS, (FrameworkType)JavaFrameworkType.getInstance());
                this.description.finishLibConfiguration(module, rootModel);
            }

            public void onFrameworkSelectionChanged(boolean selected) {
                String providerId;
                if (selected && model.isFrameworkSelected(providerId = JavaFrameworkType.getInstance().getId())) {
                    model.setFrameworkComponentEnabled(providerId, false);
                }
            }
        };
        if (frameworkSupportInModuleConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/framework/JSFrameworkSupportProvider", "createConfigurable"));
        }
        return frameworkSupportInModuleConfigurable;
    }

    public boolean isEnabledForModuleType(@NotNull ModuleType moduleType) {
        if (moduleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleType", "org/jetbrains/kotlin/idea/framework/JSFrameworkSupportProvider", "isEnabledForModuleType"));
        }
        return moduleType instanceof JavaModuleType;
    }
}

