/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Attributes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.framework.JavaRuntimeDetectionUtil;
import org.jetbrains.kotlin.idea.framework.KotlinJavaScriptLibraryDetectionUtil;
import org.jetbrains.kotlin.utils.LibraryUtils;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0018\u0010\r\u001a\u0004\u0018\u00010\f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/framework/JsLibraryStdDetectionUtil;", "", "()V", "IS_JS_LIBRARY_STD_LIB", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getJsLibraryStdVersion", "", "classesRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getJsStdLibJar", "hasJsStdlibJar", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "idea-analysis"})
public final class JsLibraryStdDetectionUtil {
    private static final Key<Boolean> IS_JS_LIBRARY_STD_LIB;
    public static final JsLibraryStdDetectionUtil INSTANCE;

    public final boolean hasJsStdlibJar(@NotNull Library library) {
        List<VirtualFile> classes2;
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        if (library instanceof LibraryEx && ((LibraryEx)library).isDisposed()) {
            return false;
        }
        if (!KotlinJavaScriptLibraryDetectionUtil.isKotlinJavaScriptLibrary(library)) {
            return false;
        }
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
        List<VirtualFile> list2 = classes2 = Arrays.asList(Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"classes");
        return this.getJsLibraryStdVersion(list2) != null;
    }

    @Nullable
    public final String getJsLibraryStdVersion(@NotNull List<? extends VirtualFile> classesRoots) {
        Intrinsics.checkParameterIsNotNull(classesRoots, (String)"classesRoots");
        if (JavaRuntimeDetectionUtil.getJavaRuntimeVersion(classesRoots) != null) {
            return null;
        }
        VirtualFile virtualFile2 = this.getJsStdLibJar(classesRoots);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile jar = virtualFile2;
        return JarUtil.getJarAttribute((File)VfsUtilCore.virtualToIoFile((VirtualFile)jar), (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
    }

    private final VirtualFile getJsStdLibJar(List<? extends VirtualFile> classesRoots) {
        for (VirtualFile virtualFile2 : classesRoots) {
            VirtualFile jar;
            if (virtualFile2.getFileSystem().getProtocol() != "jar") continue;
            if (VfsUtilCore.getVirtualFileForJar((VirtualFile)virtualFile2) == null) {
                continue;
            }
            String name2 = jar.getName();
            if (!Intrinsics.areEqual((Object)name2, (Object)"kotlin-stdlib-js.jar") && !Intrinsics.areEqual((Object)name2, (Object)"kotlin-jslib.jar") && !PathUtil.KOTLIN_STDLIB_JS_JAR_PATTERN.matcher(name2).matches() && !PathUtil.KOTLIN_JS_LIBRARY_JAR_PATTERN.matcher(name2).matches()) continue;
            Boolean isJSStdLib = (Boolean)jar.getUserData(IS_JS_LIBRARY_STD_LIB);
            if (isJSStdLib == null) {
                isJSStdLib = LibraryUtils.isKotlinJavascriptStdLibrary(new File(jar.getPath()));
                jar.putUserData(IS_JS_LIBRARY_STD_LIB, (Object)isJSStdLib);
            }
            Boolean bl = isJSStdLib;
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"isJSStdLib");
            if (!bl.booleanValue()) continue;
            return jar;
        }
        return null;
    }

    private JsLibraryStdDetectionUtil() {
        INSTANCE = this;
        IS_JS_LIBRARY_STD_LIB = Key.create((String)"IS_JS_LIBRARY_STD_LIB");
    }

    static {
        new JsLibraryStdDetectionUtil();
    }
}

