/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.RedundantIfInspection$RemoveRedundantIf$WhenMappings;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0003\f\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "BranchType", "RedundancyType", "RemoveRedundantIf", "idea"})
public final class RedundantIfInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            /*
             * WARNING - void declaration
             */
            public void visitIfExpression(@NotNull KtIfExpression expression2) {
                void branchType;
                void redundancyType;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitIfExpression(expression2);
                if (expression2.getCondition() == null) {
                    return;
                }
                Pair<RedundancyType, BranchType> pair2 = RedundancyType.Companion.of$idea(expression2);
                RedundancyType redundancyType2 = (RedundancyType)((Object)pair2.component1());
                BranchType branchType2 = (BranchType)pair2.component2();
                pair2 = null;
                if (Intrinsics.areEqual((Object)redundancyType, (Object)((Object)RedundancyType.NONE))) {
                    return;
                }
                this.$holder.registerProblem((PsiElement)expression2, "Redundant 'if' statement", ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{new RemoveRedundantIf((RedundancyType)redundancyType, (BranchType)branchType)});
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType;", "", "()V", "Assign", "Return", "Simple", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType$Simple;", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType$Return;", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType$Assign;", "idea"})
    private static abstract class BranchType {
        private BranchType() {
        }

        public /* synthetic */ BranchType(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType$Simple;", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType;", "()V", "idea"})
        public static final class Simple
        extends BranchType {
            public static final Simple INSTANCE;

            private Simple() {
                super(null);
                INSTANCE = this;
            }

            static {
                new Simple();
            }
        }

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType$Return;", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType;", "()V", "idea"})
        public static final class Return
        extends BranchType {
            public static final Return INSTANCE;

            private Return() {
                super(null);
                INSTANCE = this;
            }

            static {
                new Return();
            }
        }

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType$Assign;", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType;", "lvalue", "Lorg/jetbrains/kotlin/psi/KtExpression;", "(Lorg/jetbrains/kotlin/psi/KtExpression;)V", "getLvalue", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "equals", "", "other", "", "hashCode", "", "idea"})
        public static final class Assign
        extends BranchType {
            @NotNull
            private final KtExpression lvalue;

            public boolean equals(@Nullable Object other) {
                return other instanceof Assign && Intrinsics.areEqual((Object)this.lvalue.getText(), (Object)((Assign)other).lvalue.getText());
            }

            public int hashCode() {
                return this.lvalue.getText().hashCode();
            }

            @NotNull
            public final KtExpression getLvalue() {
                return this.lvalue;
            }

            public Assign(@NotNull KtExpression lvalue) {
                Intrinsics.checkParameterIsNotNull((Object)lvalue, (String)"lvalue");
                super(null);
                this.lvalue = lvalue;
            }
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u0000 \u00062\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$RedundancyType;", "", "(Ljava/lang/String;I)V", "NONE", "THEN_TRUE", "ELSE_TRUE", "Companion", "idea"})
    private static final class RedundancyType
    extends Enum<RedundancyType> {
        public static final /* enum */ RedundancyType NONE;
        public static final /* enum */ RedundancyType THEN_TRUE;
        public static final /* enum */ RedundancyType ELSE_TRUE;
        private static final /* synthetic */ RedundancyType[] $VALUES;
        public static final Companion Companion;

        static {
            RedundancyType[] redundancyTypeArray = new RedundancyType[3];
            RedundancyType[] redundancyTypeArray2 = redundancyTypeArray;
            redundancyTypeArray[0] = NONE = new RedundancyType();
            redundancyTypeArray[1] = THEN_TRUE = new RedundancyType();
            redundancyTypeArray[2] = ELSE_TRUE = new RedundancyType();
            $VALUES = redundancyTypeArray;
            Companion = new Companion(null);
        }

        public static RedundancyType[] values() {
            return (RedundancyType[])$VALUES.clone();
        }

        public static RedundancyType valueOf(String string) {
            return Enum.valueOf(RedundancyType.class, string);
        }

        @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u001e\u0010\n\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004*\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$RedundancyType$Companion;", "", "()V", "of", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$RedundancyType;", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType;", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "of$idea", "getBranchExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "idea"})
        public static final class Companion {
            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Pair<RedundancyType, BranchType> of$idea(@NotNull KtIfExpression expression2) {
                void elseReturn;
                void thenReturn;
                void elseType;
                void thenType;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Pair<KtExpression, BranchType> pair2 = this.getBranchExpression(expression2.getThen());
                if (pair2 == null) {
                    return TuplesKt.to((Object)((Object)NONE), (Object)BranchType.Simple.INSTANCE);
                }
                Object object = pair2;
                KtExpression ktExpression = (KtExpression)object.component1();
                BranchType branchType = (BranchType)object.component2();
                object = null;
                Pair<KtExpression, BranchType> pair3 = this.getBranchExpression(expression2.getElse());
                if (pair3 == null) {
                    return TuplesKt.to((Object)((Object)NONE), (Object)BranchType.Simple.INSTANCE);
                }
                Pair<KtExpression, BranchType> pair4 = pair3;
                object = (KtExpression)pair4.component1();
                BranchType branchType2 = (BranchType)pair4.component2();
                pair4 = null;
                return Intrinsics.areEqual((Object)thenType, (Object)elseType) ^ true ? TuplesKt.to((Object)((Object)NONE), (Object)BranchType.Simple.INSTANCE) : (KtPsiUtil.isTrueConstant((KtExpression)thenReturn) && KtPsiUtil.isFalseConstant((KtExpression)elseReturn) ? TuplesKt.to((Object)((Object)THEN_TRUE), (Object)thenType) : (KtPsiUtil.isFalseConstant((KtExpression)thenReturn) && KtPsiUtil.isTrueConstant((KtExpression)elseReturn) ? TuplesKt.to((Object)((Object)ELSE_TRUE), (Object)thenType) : TuplesKt.to((Object)((Object)NONE), (Object)BranchType.Simple.INSTANCE)));
            }

            private final Pair<KtExpression, BranchType> getBranchExpression(@Nullable KtExpression $receiver) {
                Object object;
                KtExpression ktExpression = $receiver;
                if (ktExpression instanceof KtReturnExpression) {
                    object = TuplesKt.to((Object)((KtReturnExpression)$receiver).getReturnedExpression(), (Object)BranchType.Return.INSTANCE);
                } else if (ktExpression instanceof KtBlockExpression) {
                    KtExpression ktExpression2 = (KtExpression)CollectionsKt.singleOrNull(((KtBlockExpression)$receiver).getStatements());
                    object = ktExpression2 != null ? this.getBranchExpression(ktExpression2) : null;
                } else if (ktExpression instanceof KtBinaryExpression) {
                    if (Intrinsics.areEqual((Object)((KtBinaryExpression)$receiver).getOperationToken(), (Object)((Object)KtTokens.EQ)) && ((KtBinaryExpression)$receiver).getLeft() != null) {
                        KtExpression ktExpression3 = ((KtBinaryExpression)$receiver).getRight();
                        KtExpression ktExpression4 = ((KtBinaryExpression)$receiver).getLeft();
                        if (ktExpression4 == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"left!!");
                        object = TuplesKt.to((Object)ktExpression3, (Object)new BranchType.Assign(ktExpression4));
                    } else {
                        object = null;
                    }
                } else {
                    object = ktExpression instanceof KtExpression ? TuplesKt.to((Object)$receiver, (Object)BranchType.Simple.INSTANCE) : null;
                }
                return object;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$RemoveRedundantIf;", "Lcom/intellij/codeInspection/LocalQuickFix;", "redundancyType", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$RedundancyType;", "branchType", "Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType;", "(Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$RedundancyType;Lorg/jetbrains/kotlin/idea/inspections/RedundantIfInspection$BranchType;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    private static final class RemoveRedundantIf
    implements LocalQuickFix {
        private final RedundancyType redundancyType;
        private final BranchType branchType;

        @NotNull
        public String getName() {
            return "Remove redundant 'if' statement";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            KtExpression ktExpression;
            KtExpression ktExpression2;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
            }
            KtIfExpression element2 = (KtIfExpression)psiElement2;
            if (!CodeInsightUtil.preparePsiElementsForWrite((PsiElement[])new PsiElement[]{(PsiElement)element2})) {
                return;
            }
            switch (RedundantIfInspection$RemoveRedundantIf$WhenMappings.$EnumSwitchMapping$0[this.redundancyType.ordinal()]) {
                case 1: {
                    return;
                }
                case 2: {
                    ktExpression2 = element2.getCondition();
                    if (ktExpression2 != null) break;
                    Intrinsics.throwNpe();
                    break;
                }
                case 3: {
                    KtExpression ktExpression3 = element2.getCondition();
                    if (ktExpression3 == null) {
                        Intrinsics.throwNpe();
                    }
                    ktExpression2 = UtilsKt.negate(ktExpression3);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            KtExpression condition2 = ktExpression2;
            KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element2, false, 2, null);
            BranchType branchType = this.branchType;
            if (branchType instanceof BranchType.Return) {
                Object[] objectArray = new Object[1];
                KtExpression ktExpression4 = condition2;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"condition");
                objectArray[0] = ktExpression4;
                ktExpression = CreateByPatternKt.createExpressionByPattern$default(factory2, "return $0", objectArray, false, 4, null);
            } else if (branchType instanceof BranchType.Assign) {
                Object[] objectArray = new Object[2];
                objectArray[0] = ((BranchType.Assign)this.branchType).getLvalue();
                KtExpression ktExpression5 = condition2;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression5, (String)"condition");
                objectArray[1] = ktExpression5;
                ktExpression = CreateByPatternKt.createExpressionByPattern$default(factory2, "$0 = $1", objectArray, false, 4, null);
            } else {
                KtExpression ktExpression6 = condition2;
                ktExpression = ktExpression6;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression6, (String)"condition");
            }
            element2.replace((PsiElement)ktExpression);
        }

        public RemoveRedundantIf(@NotNull RedundancyType redundancyType, @NotNull BranchType branchType) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)redundancyType), (String)"redundancyType");
            Intrinsics.checkParameterIsNotNull((Object)branchType, (String)"branchType");
            this.redundancyType = redundancyType;
            this.branchType = branchType;
        }
    }
}

