/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.inspections.DifferentKotlinMavenVersionInspection;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R(\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0005@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0007\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/DifferentKotlinMavenVersionInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "()V", "idePluginVersion", "", "getIdePluginVersion", "()Ljava/lang/String;", "idePluginVersion$delegate", "Lkotlin/Lazy;", "<set-?>", "testVersionMessage", "getTestVersionMessage", "setTestVersionMessage", "(Ljava/lang/String;)V", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "createProblem", "plugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "idea-maven"})
public final class DifferentKotlinMavenVersionInspection
extends DomElementsInspection<MavenDomProjectModel> {
    private final Lazy idePluginVersion$delegate = LazyKt.lazy((Function0)idePluginVersion.2.INSTANCE);
    @Nullable
    private String testVersionMessage;
    static final /* synthetic */ KProperty[] $$delegatedProperties;

    private final String getIdePluginVersion() {
        Lazy lazy = this.idePluginVersion$delegate;
        DifferentKotlinMavenVersionInspection differentKotlinMavenVersionInspection = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getTestVersionMessage() {
        return this.testVersionMessage;
    }

    public final void setTestVersionMessage(@Nullable String string) {
        this.testVersionMessage = string;
    }

    /*
     * WARNING - void declaration
     */
    public void checkFileElement(@Nullable DomFileElement<MavenDomProjectModel> domFileElement, @Nullable DomElementAnnotationHolder holder) {
        void $receiver$iv$iv;
        if (domFileElement == null || holder == null) {
            return;
        }
        Module module = domFileElement.getModule();
        if (module == null || (module = module.getProject()) == null) {
            return;
        }
        Module project = module;
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)project);
        if (mavenProjectsManager == null) {
            return;
        }
        MavenProjectsManager mavenManager = mavenProjectsManager;
        if (!mavenManager.isMavenizedProject() || !mavenManager.isManagedFile(domFileElement.getFile().getVirtualFile())) {
            return;
        }
        XmlFile xmlFile = domFileElement.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)xmlFile, (String)"domFileElement.file");
        PomFile pomFile = PomFile.Companion.forFileOrNull(xmlFile);
        if (pomFile == null) {
            return;
        }
        PomFile pomFile2 = pomFile;
        Iterable $receiver$iv = pomFile2.findKotlinPlugins();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            MavenDomPlugin it = (MavenDomPlugin)element$iv$iv;
            if (!(it.getVersion().exists() && Intrinsics.areEqual((Object)it.getVersion().getStringValue(), (Object)this.getIdePluginVersion()) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            MavenDomPlugin plugin;
            MavenDomPlugin mavenDomPlugin = plugin = (MavenDomPlugin)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)mavenDomPlugin, (String)"plugin");
            this.createProblem(holder, mavenDomPlugin);
        }
    }

    private final void createProblem(DomElementAnnotationHolder holder, MavenDomPlugin plugin) {
        DomElement domElement = (DomElement)plugin.getVersion();
        StringBuilder stringBuilder = new StringBuilder().append("Kotlin version that is used for building with Maven (").append(plugin.getVersion().getStringValue()).append(") differs from the one bundled into the IDE plugin (");
        String string = this.testVersionMessage;
        if (string == null) {
            string = this.getIdePluginVersion();
        }
        holder.createProblem(domElement, HighlightSeverity.WARNING, stringBuilder.append(string).append(")").toString());
    }

    public DifferentKotlinMavenVersionInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DifferentKotlinMavenVersionInspection.class), "idePluginVersion", "getIdePluginVersion()Ljava/lang/String;"))};
    }
}

