/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.junit.AbstractTestClassConfigurationProducer;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit.TestObject;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatform;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002J&\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0014J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fH\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinJUnitRunConfigurationProducer;", "Lcom/intellij/execution/actions/RunConfigurationProducer;", "Lcom/intellij/execution/junit/JUnitConfiguration;", "()V", "isConfigurationFromContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "onFirstRun", "", "fromContext", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "performRunnable", "Ljava/lang/Runnable;", "settingsMatchTemplate", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "shouldReplace", "self", "other", "Companion", "idea"})
public final class KotlinJUnitRunConfigurationProducer
extends RunConfigurationProducer<JUnitConfiguration> {
    public static final Companion Companion = new Companion(null);

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        Intrinsics.checkParameterIsNotNull((Object)self, (String)"self");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return other.isProducedBy(JUnitConfigurationProducer.class) || other.isProducedBy(PatternConfigurationProducer.class);
    }

    public boolean isConfigurationFromContext(@NotNull JUnitConfiguration configuration2, @NotNull ConfigurationContext context) {
        Location leaf;
        Intrinsics.checkParameterIsNotNull((Object)configuration2, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        Location location2 = context.getLocation();
        if (location2 == null || (location2 = location2.getPsiElement()) == null) {
            return false;
        }
        Location location3 = leaf = location2;
        Intrinsics.checkExpressionValueIsNotNull((Object)location3, (String)"leaf");
        Location<PsiMethod> methodLocation = Companion.getTestMethodLocation((PsiElement)location3);
        Location location4 = leaf;
        Intrinsics.checkExpressionValueIsNotNull((Object)location4, (String)"leaf");
        PsiClass testClass = Companion.getTestClass((PsiElement)location4);
        TestObject testObject = configuration2.getTestObject();
        Location<PsiMethod> location5 = methodLocation;
        if (!testObject.isConfiguredByElement(configuration2, testClass, (PsiMethod)(location5 != null ? (PsiMethod)location5.getPsiElement() : null), null, null)) {
            return false;
        }
        return this.settingsMatchTemplate(configuration2, context);
    }

    private final boolean settingsMatchTemplate(JUnitConfiguration configuration2, ConfigurationContext context) {
        String vmParameters;
        RunConfiguration predefinedConfiguration = context.getOriginalConfiguration((ConfigurationType)JUnitConfigurationType.getInstance());
        RunConfiguration runConfiguration = predefinedConfiguration;
        if (!(runConfiguration instanceof CommonJavaRunConfigurationParameters)) {
            runConfiguration = null;
        }
        CommonJavaRunConfigurationParameters commonJavaRunConfigurationParameters = (CommonJavaRunConfigurationParameters)runConfiguration;
        String string = vmParameters = commonJavaRunConfigurationParameters != null ? commonJavaRunConfigurationParameters.getVMParameters() : null;
        if (vmParameters != null && Intrinsics.areEqual((Object)configuration2.getVMParameters(), (Object)vmParameters) ^ true) {
            return false;
        }
        Project project = configuration2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"configuration.project");
        RunManager runManager = RunManager.Companion.getInstance(project);
        ConfigurationFactory configurationFactory = this.getConfigurationFactory();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationFactory, (String)"configurationFactory");
        RunnerAndConfigurationSettings template2 = runManager.getConfigurationTemplate(configurationFactory);
        RunConfiguration runConfiguration2 = template2.getConfiguration();
        if (runConfiguration2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.execution.configurations.ModuleBasedConfiguration<*>");
        }
        Module predefinedModule = ((ModuleBasedConfiguration)runConfiguration2).getConfigurationModule().getModule();
        Module configurationModule = ((JavaRunConfigurationModule)configuration2.getConfigurationModule()).getModule();
        Location location2 = context.getLocation();
        return Intrinsics.areEqual((Object)configurationModule, (Object)(location2 != null ? location2.getModule() : null)) || Intrinsics.areEqual((Object)configurationModule, (Object)predefinedModule);
    }

    protected boolean setupConfigurationFromContext(@NotNull JUnitConfiguration configuration2, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiElement leaf;
        Intrinsics.checkParameterIsNotNull((Object)configuration2, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(sourceElement, (String)"sourceElement");
        if (DumbService.getInstance((Project)context.getProject()).isDumb()) {
            return false;
        }
        Location location2 = context.getLocation();
        if (location2 == null) {
            return false;
        }
        Location location3 = location2;
        PsiElement psiElement2 = leaf = location3.getPsiElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"leaf");
        if (!ProjectRootsUtil.isInProjectOrLibSource(psiElement2)) {
            return false;
        }
        if (!(leaf.getContainingFile() instanceof KtFile)) {
            return false;
        }
        PsiFile psiFile = leaf.getContainingFile();
        if (psiFile == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        }
        KtFile ktFile = (KtFile)psiFile;
        if (Intrinsics.areEqual((Object)TargetPlatformDetector.getPlatform(ktFile), (Object)JvmPlatform.INSTANCE) ^ true) {
            return false;
        }
        PsiElement psiElement3 = leaf;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"leaf");
        Location<PsiMethod> methodLocation = Companion.getTestMethodLocation(psiElement3);
        if (methodLocation != null) {
            Module originalModule = ((JavaRunConfigurationModule)configuration2.getConfigurationModule()).getModule();
            configuration2.beMethodConfiguration(methodLocation);
            configuration2.restoreOriginalModule(originalModule);
            JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration2, location3);
            return true;
        }
        PsiElement psiElement4 = leaf;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"leaf");
        PsiClass testClass = Companion.getTestClass(psiElement4);
        if (testClass != null) {
            Module originalModule = ((JavaRunConfigurationModule)configuration2.getConfigurationModule()).getModule();
            configuration2.beClassConfiguration(testClass);
            configuration2.restoreOriginalModule(originalModule);
            JavaRunConfigurationExtensionManager.getInstance().extendCreatedConfiguration((RunConfigurationBase)configuration2, location3);
            return true;
        }
        return false;
    }

    public void onFirstRun(@NotNull ConfigurationFromContext fromContext, @NotNull ConfigurationContext context, @NotNull Runnable performRunnable) {
        PsiElement leaf;
        Intrinsics.checkParameterIsNotNull((Object)fromContext, (String)"fromContext");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)performRunnable, (String)"performRunnable");
        PsiElement psiElement2 = leaf = fromContext.getSourceElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"leaf");
        PsiClass psiClass2 = Companion.getTestClass(psiElement2);
        if (psiClass2 != null) {
            PsiClass psiClass3;
            PsiClass testClass = psiClass3 = psiClass2;
            ConfigurationFromContext fromContextSubstitute = new ConfigurationFromContext(testClass, fromContext, context, performRunnable){
                final /* synthetic */ PsiClass $testClass;
                final /* synthetic */ ConfigurationFromContext $fromContext$inlined;
                final /* synthetic */ ConfigurationContext $context$inlined;
                final /* synthetic */ Runnable $performRunnable$inlined;
                {
                    this.$testClass = $captured_local_variable$1;
                    this.$fromContext$inlined = configurationFromContext;
                    this.$context$inlined = configurationContext;
                    this.$performRunnable$inlined = runnable;
                }

                public RunnerAndConfigurationSettings getConfigurationSettings() {
                    return this.$fromContext$inlined.getConfigurationSettings();
                }

                public void setConfigurationSettings(RunnerAndConfigurationSettings configurationSettings) {
                    this.$fromContext$inlined.setConfigurationSettings(configurationSettings);
                }

                public PsiClass getSourceElement() {
                    return this.$testClass;
                }
            };
            new AbstractTestClassConfigurationProducer((ConfigurationType)JUnitConfigurationType.getInstance()){}.onFirstRun(fromContextSubstitute, context, performRunnable);
            return;
        }
        super.onFirstRun(fromContext, context, performRunnable);
    }

    public KotlinJUnitRunConfigurationProducer() {
        super((ConfigurationType)JUnitConfigurationType.getInstance());
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u000f*\u0004\u0018\u00010\bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/run/KotlinJUnitRunConfigurationProducer$Companion;", "", "()V", "getTestClass", "Lcom/intellij/psi/PsiClass;", "leaf", "Lcom/intellij/psi/PsiElement;", "getTestClassInFile", "Lorg/jetbrains/kotlin/psi/KtClass;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "getTestMethodLocation", "Lcom/intellij/execution/Location;", "Lcom/intellij/psi/PsiMethod;", "isJUnitTestClass", "", "idea"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final PsiClass getTestClass(@NotNull PsiElement leaf) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)leaf, (String)"leaf");
            PsiFile psiFile = leaf.getContainingFile();
            if (!(psiFile instanceof KtFile)) {
                psiFile = null;
            }
            KtFile ktFile = (KtFile)psiFile;
            if (ktFile == null) {
                return null;
            }
            KtFile containingFile = ktFile;
            PsiElement psiElement2 = leaf;
            boolean strict$iv = false;
            KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtClass.class, (boolean)strict$iv);
            if (!this.isJUnitTestClass(ktClass)) {
                ktClass = this.getTestClassInFile(containingFile);
            }
            KtClass ktClass2 = ktClass;
            return ktClass2 != null ? LightClassUtilsKt.toLightClass(ktClass2) : null;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Location<PsiMethod> getTestMethodLocation(@NotNull PsiElement leaf) {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)leaf, (String)"leaf");
            PsiElement psiElement2 = leaf;
            boolean strict$iv = false;
            KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtNamedFunction.class, (boolean)strict$iv);
            if (ktNamedFunction == null) {
                return null;
            }
            KtNamedFunction function2 = ktNamedFunction;
            KtTypeParameterListOwner owner = (KtTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)function2, (Class[])new Class[]{KtFunction.class, KtClass.class});
            if (owner instanceof KtClass) {
                Object object;
                block6: {
                    KtLightClass ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)owner);
                    if (ktLightClass == null) {
                        return null;
                    }
                    KtLightClass delegate2 = ktLightClass;
                    Object[] $receiver$iv2 = delegate2.getMethods();
                    for (int i = 0; i < $receiver$iv2.length; ++i) {
                        Object element$iv = $receiver$iv2[i];
                        PsiMethod it = (PsiMethod)element$iv;
                        if (!Intrinsics.areEqual((Object)it.getNavigationElement(), (Object)function2)) continue;
                        object = element$iv;
                        break block6;
                    }
                    object = null;
                }
                PsiMethod psiMethod2 = (PsiMethod)object;
                if (psiMethod2 == null) {
                    return null;
                }
                PsiMethod method = psiMethod2;
                Location methodLocation = PsiLocation.fromPsiElement((PsiElement)((PsiElement)method));
                if (JUnitUtil.isTestMethod((Location)methodLocation, (boolean)false)) {
                    return methodLocation;
                }
            }
            return null;
        }

        private final boolean isJUnitTestClass(@Nullable KtClass $receiver) {
            boolean bl;
            Object object = $receiver;
            if (object != null && (object = LightClassUtilsKt.toLightClass((KtClassOrObject)object)) != null) {
                Object object2;
                Object it = object2 = object;
                bl = JUnitUtil.isTestClass((PsiClass)((PsiClass)it), (boolean)false, (boolean)true);
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private final KtClass getTestClassInFile(KtFile ktFile) {
            Iterable iterable;
            block3: {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable2 = $receiver$iv = (Iterable)ktFile.getDeclarations();
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    if (!(element$iv$iv instanceof KtClass)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $receiver$iv) {
                    KtClass it = (KtClass)element$iv;
                    if (!Companion.isJUnitTestClass(it)) continue;
                    if (found$iv) {
                        iterable = null;
                        break block3;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                iterable = !found$iv ? null : iterable2;
            }
            return (KtClass)((Object)iterable);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

