/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinJavaModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinJsModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollectorKt;
import org.jetbrains.kotlin.idea.framework.JSLibraryStdPresentationProvider;
import org.jetbrains.kotlin.idea.framework.JavaRuntimePresentationProvider;
import org.jetbrains.kotlin.idea.framework.KotlinLibraryUtilKt;
import org.jetbrains.kotlin.idea.util.DumbUtilsKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.BinaryVersionedFile;
import org.jetbrains.kotlin.idea.versions.KotlinJsMetadataVersionIndex;
import org.jetbrains.kotlin.idea.versions.KotlinJvmMetadataVersionIndex;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt$WhenMappings;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;
import org.jetbrains.kotlin.idea.vfilefinder.FileIndexesKt;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinJavaScriptMetaFileIndex;
import org.jetbrains.kotlin.load.kotlin.JvmMetadataVersion;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.deserialization.BinaryVersion;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000\u008e\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0006\u0010\u0017\u001a\u00020\u0003\u001a\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!\u001a\u001a\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$0#2\u0006\u0010&\u001a\u00020\u001b\u001a\u001a\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0$0#2\u0006\u0010&\u001a\u00020\u001b\u001aA\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H*0$0#\"\b\b\u0000\u0010**\u00020+2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010,\u001a\u0002H*2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H*0.H\u0002\u00a2\u0006\u0002\u0010/\u001a\u0012\u00100\u001a\u0004\u0018\u0001012\b\u00102\u001a\u0004\u0018\u000101\u001a\u0018\u00103\u001a\u00020\u00032\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\u0003\u001a\u000e\u00107\u001a\u0002082\u0006\u00106\u001a\u00020\u0003\u001a\u0016\u00109\u001a\u0002082\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!\u001a\u000e\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u0003\u001a\u0018\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u000201H\u0000\u001a\u0016\u0010A\u001a\u00020=2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010B\u001a\u00020\u0003\u001a\"\u0010C\u001a\u00020=2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010D\u001a\u0004\u0018\u0001012\u0006\u0010E\u001a\u00020FH\u0002\u001a\u001c\u0010G\u001a\u00020=2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001a0#\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0014\u0010\u0006\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0005\"\u0014\u0010\b\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0005\"\u0014\u0010\n\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0005\"\u0014\u0010\f\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0005\"\u0014\u0010\u000e\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0005\"\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\"\u001d\u0010\u0013\u001a\u0004\u0018\u00010\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0014\u0010\u0005\u00a8\u0006I"}, d2={"KOTLIN_JS_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "MAVEN_COMMON_STDLIB_ID", "", "getMAVEN_COMMON_STDLIB_ID", "()Ljava/lang/String;", "MAVEN_JS_STDLIB_ID", "getMAVEN_JS_STDLIB_ID", "MAVEN_OLD_JS_STDLIB_ID", "getMAVEN_OLD_JS_STDLIB_ID", "MAVEN_STDLIB_ID", "getMAVEN_STDLIB_ID", "MAVEN_STDLIB_ID_JRE7", "getMAVEN_STDLIB_ID_JRE7", "MAVEN_STDLIB_ID_JRE8", "getMAVEN_STDLIB_ID_JRE8", "PLUGIN_VERSIONS_SEPARATORS", "", "[Ljava/lang/String;", "bundledRuntimeBuildNumber", "getBundledRuntimeBuildNumber", "bundledRuntimeBuildNumber$delegate", "Lkotlin/Lazy;", "bundledRuntimeVersion", "findAllUsedLibraries", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/roots/libraries/Library;", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "getKotlinJvmRuntimeMarkerClass", "Lcom/intellij/psi/PsiClass;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getLibraryRootsWithAbiIncompatibleForKotlinJs", "", "Lorg/jetbrains/kotlin/idea/versions/BinaryVersionedFile;", "Lorg/jetbrains/kotlin/utils/JsMetadataVersion;", "module", "getLibraryRootsWithAbiIncompatibleKotlinClasses", "Lorg/jetbrains/kotlin/load/kotlin/JvmMetadataVersion;", "getLibraryRootsWithAbiIncompatibleVersion", "T", "Lorg/jetbrains/kotlin/serialization/deserialization/BinaryVersion;", "supportedVersion", "index", "Lcom/intellij/util/indexing/ScalarIndexExtension;", "(Lcom/intellij/openapi/module/Module;Lorg/jetbrains/kotlin/serialization/deserialization/BinaryVersion;Lcom/intellij/util/indexing/ScalarIndexExtension;)Ljava/util/Collection;", "getLocalJar", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlinRuntimeJar", "getStdlibArtifactId", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "version", "hasJreSpecificRuntime", "", "hasKotlinJsKjsmFile", "pluginRuntimeVersion", "pluginVersion", "replaceFile", "", "updatedFile", "Ljava/io/File;", "replacedJarFile", "showRuntimeJarNotFoundDialog", "jarName", "updateJar", "fileToReplace", "libraryJarDescriptor", "Lorg/jetbrains/kotlin/idea/versions/LibraryJarDescriptor;", "updateLibraries", "libraries", "idea"})
public final class KotlinRuntimeLibraryUtilKt {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final Lazy bundledRuntimeBuildNumber$delegate;
    private static final String[] PLUGIN_VERSIONS_SEPARATORS;
    private static final FqName KOTLIN_JS_FQ_NAME;
    @NotNull
    private static final String MAVEN_STDLIB_ID = "kotlin-stdlib";
    @NotNull
    private static final String MAVEN_STDLIB_ID_JRE7 = "kotlin-stdlib-jre7";
    @NotNull
    private static final String MAVEN_STDLIB_ID_JRE8 = "kotlin-stdlib-jre8";
    @NotNull
    private static final String MAVEN_JS_STDLIB_ID = "kotlin-stdlib-js";
    @NotNull
    private static final String MAVEN_OLD_JS_STDLIB_ID = "kotlin-js-library";
    @NotNull
    private static final String MAVEN_COMMON_STDLIB_ID = "kotlin-stdlib-common";

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(KotlinRuntimeLibraryUtilKt.class, (String)"idea"), "bundledRuntimeBuildNumber", "getBundledRuntimeBuildNumber()Ljava/lang/String;"))};
        bundledRuntimeBuildNumber$delegate = LazyKt.lazy((Function0)bundledRuntimeBuildNumber.2.INSTANCE);
        String[] elements$iv = new String[]{"Idea", "IJ", "release", "dev", "Studio"};
        PLUGIN_VERSIONS_SEPARATORS = var0;
        KOTLIN_JS_FQ_NAME = new FqName("kotlin.js");
        MAVEN_STDLIB_ID = MAVEN_STDLIB_ID;
        MAVEN_STDLIB_ID_JRE7 = MAVEN_STDLIB_ID_JRE7;
        MAVEN_STDLIB_ID_JRE8 = MAVEN_STDLIB_ID_JRE8;
        MAVEN_JS_STDLIB_ID = MAVEN_JS_STDLIB_ID;
        MAVEN_OLD_JS_STDLIB_ID = MAVEN_OLD_JS_STDLIB_ID;
        MAVEN_COMMON_STDLIB_ID = MAVEN_COMMON_STDLIB_ID;
    }

    @NotNull
    public static final Collection<BinaryVersionedFile<JvmMetadataVersion>> getLibraryRootsWithAbiIncompatibleKotlinClasses(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return KotlinRuntimeLibraryUtilKt.getLibraryRootsWithAbiIncompatibleVersion(module, (BinaryVersion)JvmMetadataVersion.INSTANCE, KotlinJvmMetadataVersionIndex.INSTANCE);
    }

    @NotNull
    public static final Collection<BinaryVersionedFile<JsMetadataVersion>> getLibraryRootsWithAbiIncompatibleForKotlinJs(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return KotlinRuntimeLibraryUtilKt.getLibraryRootsWithAbiIncompatibleVersion(module, (BinaryVersion)JsMetadataVersion.INSTANCE, KotlinJsMetadataVersionIndex.INSTANCE);
    }

    public static final void updateLibraries(@NotNull Project project, @NotNull Collection<? extends Library> libraries) {
        boolean bl;
        block11: {
            boolean bl2;
            Iterable $receiver$iv;
            block10: {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull(libraries, (String)"libraries");
                $receiver$iv = ProjectStructureUtilKt.allModules(project);
                for (Object element$iv : $receiver$iv) {
                    Module module = (Module)element$iv;
                    if (!KotlinPluginUtil.isMavenModule(module)) continue;
                    bl2 = true;
                    break block10;
                }
                bl2 = false;
            }
            if (bl2) {
                Messages.showMessageDialog((Project)project, (String)"Automatic library version update for Maven projects is currently unsupported. Please update your pom.xml manually.", (String)"Update Kotlin Runtime Library", (Icon)Messages.getErrorIcon());
                return;
            }
            $receiver$iv = ProjectStructureUtilKt.allModules(project);
            for (Object element$iv : $receiver$iv) {
                Module module = (Module)element$iv;
                if (!KotlinPluginUtil.isGradleModule(module)) continue;
                bl = true;
                break block11;
            }
            bl = false;
        }
        if (bl) {
            Messages.showMessageDialog((Project)project, (String)"Automatic library version update for Gradle projects is currently unsupported. Please update your build.gradle manually.", (String)"Update Kotlin Runtime Library", (Icon)Messages.getErrorIcon());
            return;
        }
        KotlinJavaModuleConfigurator kotlinJavaModuleConfigurator = (KotlinJavaModuleConfigurator)ConfigureKotlinInProjectUtilsKt.getConfiguratorByName("java");
        if (kotlinJavaModuleConfigurator == null) {
            String string = "Configurator with given name doesn't exists: java";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        KotlinJavaModuleConfigurator kJvmConfigurator = kotlinJavaModuleConfigurator;
        KotlinJsModuleConfigurator kotlinJsModuleConfigurator = (KotlinJsModuleConfigurator)ConfigureKotlinInProjectUtilsKt.getConfiguratorByName("js");
        if (kotlinJsModuleConfigurator == null) {
            Object element$iv;
            element$iv = "Configurator with given name doesn't exists: js";
            throw (Throwable)new IllegalStateException(element$iv.toString());
        }
        KotlinJsModuleConfigurator kJsConfigurator = kotlinJsModuleConfigurator;
        NotificationMessageCollector collector2 = NotificationMessageCollectorKt.createConfigureKotlinNotificationCollector(project);
        for (Library library : libraries) {
            JavaRuntimePresentationProvider javaRuntimePresentationProvider = JavaRuntimePresentationProvider.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)javaRuntimePresentationProvider), (String)"JavaRuntimePresentationProvider.getInstance()");
            if (KotlinLibraryUtilKt.isDetected(javaRuntimePresentationProvider, library)) {
                KotlinRuntimeLibraryUtilKt.updateJar(project, KotlinLibraryUtilKt.getRuntimeJar(library), LibraryJarDescriptor.RUNTIME_JAR);
                KotlinRuntimeLibraryUtilKt.updateJar(project, KotlinLibraryUtilKt.getReflectJar(library), LibraryJarDescriptor.REFLECT_JAR);
                KotlinRuntimeLibraryUtilKt.updateJar(project, KotlinLibraryUtilKt.getTestJar(library), LibraryJarDescriptor.TEST_JAR);
                if (kJvmConfigurator.changeOldSourcesPathIfNeeded(library, collector2)) {
                    kJvmConfigurator.copySourcesToPathFromLibrary(library, collector2);
                    continue;
                }
                KotlinRuntimeLibraryUtilKt.updateJar(project, KotlinLibraryUtilKt.getRuntimeSrcJar(library), LibraryJarDescriptor.RUNTIME_SRC_JAR);
                continue;
            }
            JSLibraryStdPresentationProvider jSLibraryStdPresentationProvider = JSLibraryStdPresentationProvider.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)jSLibraryStdPresentationProvider), (String)"JSLibraryStdPresentationProvider.getInstance()");
            if (!KotlinLibraryUtilKt.isDetected(jSLibraryStdPresentationProvider, library)) continue;
            KotlinRuntimeLibraryUtilKt.updateJar(project, KotlinLibraryUtilKt.getJsStdLibJar(library), LibraryJarDescriptor.JS_STDLIB_JAR);
            if (kJsConfigurator.changeOldSourcesPathIfNeeded(library, collector2)) {
                kJsConfigurator.copySourcesToPathFromLibrary(library, collector2);
                continue;
            }
            KotlinRuntimeLibraryUtilKt.updateJar(project, KotlinLibraryUtilKt.getJsStdLibSrcJar(library), LibraryJarDescriptor.JS_STDLIB_SRC_JAR);
        }
        collector2.showNotification();
    }

    private static final void updateJar(Project project, VirtualFile fileToReplace, LibraryJarDescriptor libraryJarDescriptor) {
        File file2;
        if (fileToReplace == null && !libraryJarDescriptor.getShouldExist()) {
            return;
        }
        KotlinPaths paths = org.jetbrains.kotlin.utils.PathUtil.getKotlinPathsForIdeaPlugin();
        switch (KotlinRuntimeLibraryUtilKt$WhenMappings.$EnumSwitchMapping$0[libraryJarDescriptor.ordinal()]) {
            case 1: {
                File file3 = paths.getRuntimePath();
                file2 = file3;
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"paths.runtimePath");
                break;
            }
            case 2: {
                File file4 = paths.getReflectPath();
                file2 = file4;
                Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"paths.reflectPath");
                break;
            }
            case 3: {
                File file5 = paths.getScriptRuntimePath();
                file2 = file5;
                Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"paths.scriptRuntimePath");
                break;
            }
            case 4: {
                File file6 = paths.getKotlinTestPath();
                file2 = file6;
                Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"paths.kotlinTestPath");
                break;
            }
            case 5: {
                File file7 = paths.getRuntimeSourcesPath();
                file2 = file7;
                Intrinsics.checkExpressionValueIsNotNull((Object)file7, (String)"paths.runtimeSourcesPath");
                break;
            }
            case 6: {
                File file8 = paths.getJsStdLibJarPath();
                file2 = file8;
                Intrinsics.checkExpressionValueIsNotNull((Object)file8, (String)"paths.jsStdLibJarPath");
                break;
            }
            case 7: {
                File file9 = paths.getJsStdLibSrcJarPath();
                file2 = file9;
                Intrinsics.checkExpressionValueIsNotNull((Object)file9, (String)"paths.jsStdLibSrcJarPath");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        File jarPath = file2;
        if (!jarPath.exists()) {
            KotlinRuntimeLibraryUtilKt.showRuntimeJarNotFoundDialog(project, libraryJarDescriptor.getJarName());
            return;
        }
        VirtualFile virtualFile2 = KotlinRuntimeLibraryUtilKt.getLocalJar(fileToReplace);
        if (virtualFile2 == null) {
            Intrinsics.throwNpe();
        }
        KotlinRuntimeLibraryUtilKt.replaceFile(jarPath, virtualFile2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final MultiMap<Library, Module> findAllUsedLibraries(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        MultiMap libraries = new MultiMap();
        Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
        for (int i = 0; i < moduleArray.length; ++i) {
            void $receiver$iv$iv;
            Object[] $receiver$iv;
            Module module = moduleArray[i];
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            Object[] objectArray = $receiver$iv = (Object[])moduleRootManager.getOrderEntries();
            Collection destination$iv$iv = new ArrayList();
            for (int j = 0; j < ((void)$receiver$iv$iv).length; ++j) {
                void element$iv$iv = $receiver$iv$iv[j];
                if (!(element$iv$iv instanceof LibraryOrderEntry)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (LibraryOrderEntry entry : (List)destination$iv$iv) {
                Library library;
                if (entry.getLibrary() == null) {
                    continue;
                }
                libraries.putValue((Object)library, (Object)module);
            }
        }
        return libraries;
    }

    @NotNull
    public static final String bundledRuntimeVersion() {
        String string = KotlinRuntimeLibraryUtilKt.getBundledRuntimeBuildNumber();
        if (string == null) {
            String string2 = KotlinPluginUtil.getPluginVersion();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"KotlinPluginUtil.getPluginVersion()");
            string = KotlinRuntimeLibraryUtilKt.pluginRuntimeVersion(string2);
        }
        return string;
    }

    private static final String getBundledRuntimeBuildNumber() {
        Lazy lazy = bundledRuntimeBuildNumber$delegate;
        Object var1_1 = null;
        KProperty kProperty = $$delegatedProperties[0];
        return (String)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String pluginRuntimeVersion(@NotNull String pluginVersion) {
        String string;
        int separator2;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)pluginVersion, (String)"pluginVersion");
        int placeToSplit = -1;
        String[] stringArray = PLUGIN_VERSIONS_SEPARATORS;
        for (n = 0; n < stringArray.length; ++n) {
            String separator2 = stringArray[n];
            int ideaPatternIndex = StringUtil.indexOf((CharSequence)pluginVersion, (CharSequence)separator2);
            if (ideaPatternIndex < 2 || !Character.isDigit(pluginVersion.charAt(ideaPatternIndex - 2))) continue;
            placeToSplit = ideaPatternIndex - 1;
            break;
        }
        if (placeToSplit == -1 && (separator2 = 1) <= (n = pluginVersion.length() - 1)) {
            while (true) {
                void i;
                char ch;
                if (Character.isLetter(ch = pluginVersion.charAt((int)i)) && pluginVersion.charAt((int)(i - true)) == '.') {
                    placeToSplit = i - true;
                    break;
                }
                if (i == n) break;
                ++i;
            }
        }
        if (placeToSplit != -1) {
            String string2 = pluginVersion;
            n = 0;
            String string3 = string2.substring(n, placeToSplit);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = pluginVersion;
        }
        return string;
    }

    @Nullable
    public static final VirtualFile getLocalJar(@Nullable VirtualFile kotlinRuntimeJar) {
        if (kotlinRuntimeJar == null) {
            return null;
        }
        VirtualFile localJarFile = JarFileSystem.getInstance().getVirtualFileForJar(kotlinRuntimeJar);
        if (localJarFile != null) {
            return localJarFile;
        }
        return kotlinRuntimeJar;
    }

    public static final void replaceFile(@NotNull File updatedFile, @NotNull VirtualFile replacedJarFile) {
        Intrinsics.checkParameterIsNotNull((Object)updatedFile, (String)"updatedFile");
        Intrinsics.checkParameterIsNotNull((Object)replacedJarFile, (String)"replacedJarFile");
        try {
            VirtualFile replacedFile = PathUtil.getLocalFile((VirtualFile)replacedJarFile);
            String string = PathUtil.getLocalPath((VirtualFile)replacedFile);
            if (string == null) {
                String string2 = "Should be called for replacing valid root file: " + replacedJarFile;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            String localPath = string;
            File libraryJarPath = new File(localPath);
            if (FileUtil.filesEqual((File)updatedFile, (File)libraryJarPath)) {
                return;
            }
            FileUtil.copy((File)updatedFile, (File)libraryJarPath);
            replacedFile.refresh(false, true);
        }
        catch (IOException e) {
            throw (Throwable)((Object)new AssertionError((Object)e));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final <T extends BinaryVersion> Collection<BinaryVersionedFile<T>> getLibraryRootsWithAbiIncompatibleVersion(Module module, T supportedVersion, ScalarIndexExtension<T> index2) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        ID id = index2.getName();
        Set set = SetsKt.setOf((Object)module);
        List list2 = ModuleUtil.getAllDependentModules((Module)module);
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ModuleUtil.getAllDependentModules(module)");
        Set moduleWithAllDependencies = SetsKt.plus((Set)set, (Iterable)list2);
        Iterable iterable = $receiver$iv = (Iterable)moduleWithAllDependencies;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it;
            Module module2 = (Module)item$iv$iv;
            Collection collection = destination$iv$iv;
            GlobalSearchScope globalSearchScope = it.getModuleWithLibrariesScope();
            collection.add(globalSearchScope);
        }
        Iterable thisCollection$iv = $receiver$iv = (Collection)((List)destination$iv$iv);
        GlobalSearchScope[] globalSearchScopeArray = thisCollection$iv.toArray(new GlobalSearchScope[thisCollection$iv.size()]);
        if (globalSearchScopeArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        GlobalSearchScope moduleWithAllDependentLibraries = GlobalSearchScope.union((GlobalSearchScope[])globalSearchScopeArray);
        Collection allVersions = FileBasedIndex.getInstance().getAllKeys(id, module.getProject());
        Iterable $receiver$iv2 = allVersions;
        Iterable iterable2 = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            BinaryVersion p1 = (BinaryVersion)element$iv$iv;
            if (p1.isCompatible()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        HashSet badVersions = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv2));
        HashSet<BinaryVersionedFile<BinaryVersion>> badRoots = new HashSet<BinaryVersionedFile<BinaryVersion>>();
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)module.getProject());
        for (BinaryVersion version : badVersions) {
            Collection indexedFiles = FileBasedIndex.getInstance().getContainingFiles(id, (Object)version, moduleWithAllDependentLibraries);
            for (VirtualFile indexedFile : indexedFiles) {
                VirtualFile libraryRoot;
                if (fileIndex.getClassRootForFile(indexedFile) == null) {
                    String string = "Only library roots were requested, and only class files should be indexed with the " + id + " key. " + ("File: " + indexedFile.getPath());
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                VirtualFile virtualFile2 = PathUtil.getLocalFile((VirtualFile)libraryRoot);
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"getLocalFile(libraryRoot)");
                badRoots.add(new BinaryVersionedFile<BinaryVersion>(virtualFile2, version, supportedVersion));
            }
        }
        return badRoots;
    }

    public static final void showRuntimeJarNotFoundDialog(@NotNull Project project, @NotNull String jarName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)jarName, (String)"jarName");
        Messages.showErrorDialog((Project)project, (String)(jarName + " is not found. Make sure plugin is properly installed."), (String)"No Runtime Found");
    }

    @Nullable
    public static final PsiClass getKotlinJvmRuntimeMarkerClass(@NotNull Project project, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        return (PsiClass)ApplicationUtilsKt.runReadAction((Function0)new Function0<PsiClass>(project, scope2){
            final /* synthetic */ Project $project;
            final /* synthetic */ GlobalSearchScope $scope;

            @Nullable
            public final PsiClass invoke() {
                return (PsiClass)DumbUtilsKt.runWithAlternativeResolveEnabled(this.$project, (Function0)new Function0<PsiClass>(this){
                    final /* synthetic */ getKotlinJvmRuntimeMarkerClass.1 this$0;

                    @Nullable
                    public final PsiClass invoke() {
                        return JavaPsiFacade.getInstance((Project)this.this$0.$project).findClass(KotlinBuiltIns.FQ_NAMES.unit.asString(), this.this$0.$scope);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.$project = project;
                this.$scope = globalSearchScope;
                super(0);
            }
        });
    }

    public static final boolean hasKotlinJsKjsmFile(@NotNull Project project, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(project, scope2){
            final /* synthetic */ Project $project;
            final /* synthetic */ GlobalSearchScope $scope;

            public final boolean invoke() {
                return (Boolean)DumbUtilsKt.runWithAlternativeResolveEnabled(this.$project, (Function0)new Function0<Boolean>(this){
                    final /* synthetic */ hasKotlinJsKjsmFile.1 this$0;

                    public final boolean invoke() {
                        return FileIndexesKt.hasSomethingInPackage(KotlinJavaScriptMetaFileIndex.INSTANCE, KotlinRuntimeLibraryUtilKt.access$getKOTLIN_JS_FQ_NAME$p(), this.this$0.$scope);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.$project = project;
                this.$scope = globalSearchScope;
                super(0);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final String getStdlibArtifactId(@Nullable Sdk sdk, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        if (!KotlinRuntimeLibraryUtilKt.hasJreSpecificRuntime(version)) {
            return KotlinRuntimeLibraryUtilKt.MAVEN_STDLIB_ID;
        }
        v0 = sdk;
        if (v0 != null) {
            it = var3_2 = v0;
            v1 = JavaSdk.getInstance().getVersion(it);
        } else {
            v1 = null;
        }
        v2 = sdkVersion = v1;
        if (v2 == null) ** GOTO lbl-1000
        switch (KotlinRuntimeLibraryUtilKt$WhenMappings.$EnumSwitchMapping$1[v2.ordinal()]) {
            case 1: 
            case 2: {
                v3 = KotlinRuntimeLibraryUtilKt.MAVEN_STDLIB_ID_JRE8;
                break;
            }
            case 3: {
                v3 = KotlinRuntimeLibraryUtilKt.MAVEN_STDLIB_ID_JRE7;
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v3 = KotlinRuntimeLibraryUtilKt.MAVEN_STDLIB_ID;
            }
        }
        artifactId = v3;
        return artifactId;
    }

    public static final boolean hasJreSpecificRuntime(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return VersionComparatorUtil.compare((String)version, (String)"1.1.0") >= 0 || ConfigureKotlinInProjectUtilsKt.isSnapshot(version) || Intrinsics.areEqual((Object)version, (Object)"default_version");
    }

    @NotNull
    public static final String getMAVEN_STDLIB_ID() {
        return MAVEN_STDLIB_ID;
    }

    @NotNull
    public static final String getMAVEN_STDLIB_ID_JRE7() {
        return MAVEN_STDLIB_ID_JRE7;
    }

    @NotNull
    public static final String getMAVEN_STDLIB_ID_JRE8() {
        return MAVEN_STDLIB_ID_JRE8;
    }

    @NotNull
    public static final String getMAVEN_JS_STDLIB_ID() {
        return MAVEN_JS_STDLIB_ID;
    }

    @NotNull
    public static final String getMAVEN_OLD_JS_STDLIB_ID() {
        return MAVEN_OLD_JS_STDLIB_ID;
    }

    @NotNull
    public static final String getMAVEN_COMMON_STDLIB_ID() {
        return MAVEN_COMMON_STDLIB_ID;
    }

    @NotNull
    public static final /* synthetic */ FqName access$getKOTLIN_JS_FQ_NAME$p() {
        return KOTLIN_JS_FQ_NAME;
    }
}

