/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.intellij.framework.library.LibraryVersionProperties;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.framework.JSLibraryStdPresentationProvider;
import org.jetbrains.kotlin.idea.framework.JavaRuntimePresentationProvider;
import org.jetbrains.kotlin.idea.framework.KotlinLibraryUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.OutdatedKotlinRuntimeCheckerKt;
import org.jetbrains.kotlin.idea.versions.VersionedLibrary;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\u001a\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0005\u001a\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0002\u001a\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\r\u001a\u0018\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0017\u001a\u00020\u0001\u001a\u001c\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001a\u001a\u001e\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001aH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"OUTDATED_RUNTIME_GROUP_DISPLAY_ID", "", "SUPPRESSED_PROPERTY_NAME", "collectModulesWithOutdatedRuntime", "", "Lcom/intellij/openapi/module/Module;", "libraries", "Lorg/jetbrains/kotlin/idea/versions/VersionedLibrary;", "deleteKotlinJs", "", "project", "Lcom/intellij/openapi/project/Project;", "findKotlinRuntimeLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "module", "findOutdatedKotlinLibraries", "getKotlinLibraryVersionProperties", "Lcom/intellij/framework/library/LibraryVersionProperties;", "library", "getOutdatedRuntimeLibraryVersion", "isRuntimeOutdated", "", "libraryVersion", "runtimeVersion", "notifyOutdatedKotlinRuntime", "outdatedLibraries", "", "suggestDeleteKotlinJsIfNeeded", "idea"})
public final class OutdatedKotlinRuntimeCheckerKt {
    private static final String SUPPRESSED_PROPERTY_NAME = "oudtdated.runtime.suppressed.plugin.version";
    private static final String OUTDATED_RUNTIME_GROUP_DISPLAY_ID = "Outdated Kotlin Runtime";

    @NotNull
    public static final List<VersionedLibrary> findOutdatedKotlinLibraries(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String pluginVersion = KotlinPluginUtil.getPluginVersion();
        if (KotlinPluginUtil.isSnapshotVersion()) {
            return CollectionsKt.emptyList();
        }
        if (Intrinsics.areEqual((Object)pluginVersion, (Object)PropertiesComponent.getInstance((Project)project).getValue(SUPPRESSED_PROPERTY_NAME))) {
            return CollectionsKt.emptyList();
        }
        ArrayList<VersionedLibrary> outdatedLibraries = new ArrayList<VersionedLibrary>();
        for (Map.Entry entry : KotlinRuntimeLibraryUtilKt.findAllUsedLibraries(project).entrySet()) {
            Object object = entry;
            Library library = (Library)object.getKey();
            object = entry;
            Collection modules = (Collection)object.getValue();
            Library library2 = library;
            Intrinsics.checkExpressionValueIsNotNull((Object)library2, (String)"library");
            String string = OutdatedKotlinRuntimeCheckerKt.getOutdatedRuntimeLibraryVersion(library2);
            if (string == null) continue;
            Object version = object = string;
            Library library3 = library;
            Intrinsics.checkExpressionValueIsNotNull((Object)library3, (String)"library");
            Collection collection = modules;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"modules");
            outdatedLibraries.add(new VersionedLibrary(library3, (String)version, collection));
        }
        return outdatedLibraries;
    }

    @Nullable
    public static final String getOutdatedRuntimeLibraryVersion(@NotNull Library library) {
        Intrinsics.checkParameterIsNotNull((Object)library, (String)"library");
        LibraryVersionProperties libraryVersionProperties = OutdatedKotlinRuntimeCheckerKt.getKotlinLibraryVersionProperties(library);
        if (libraryVersionProperties == null) {
            return null;
        }
        LibraryVersionProperties libraryVersionProperties2 = libraryVersionProperties;
        String libraryVersion = libraryVersionProperties2.getVersionString();
        String runtimeVersion = KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion();
        return OutdatedKotlinRuntimeCheckerKt.isRuntimeOutdated(libraryVersion, runtimeVersion) ? libraryVersion : null;
    }

    private static final LibraryVersionProperties getKotlinLibraryVersionProperties(Library library) {
        JavaRuntimePresentationProvider javaRuntimePresentationProvider = JavaRuntimePresentationProvider.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)javaRuntimePresentationProvider), (String)"JavaRuntimePresentationProvider.getInstance()");
        LibraryVersionProperties libraryVersionProperties = (LibraryVersionProperties)KotlinLibraryUtilKt.getLibraryProperties(javaRuntimePresentationProvider, library);
        if (libraryVersionProperties == null) {
            JSLibraryStdPresentationProvider jSLibraryStdPresentationProvider = JSLibraryStdPresentationProvider.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)jSLibraryStdPresentationProvider), (String)"JSLibraryStdPresentationProvider.getInstance()");
            libraryVersionProperties = (LibraryVersionProperties)KotlinLibraryUtilKt.getLibraryProperties(jSLibraryStdPresentationProvider, library);
        }
        return libraryVersionProperties;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Library findKotlinRuntimeLibrary(@NotNull Module module) {
        Object v1;
        block2: {
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Sequence $receiver$iv = (Sequence)ModuleRootManager.getInstance((Module)module).getOrderEntries();
            Sequence sequence2 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                void element$iv$iv = $receiver$iv$iv[i];
                if (!(element$iv$iv instanceof LibraryOrderEntry)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List orderEntries = (List)destination$iv$iv;
            $receiver$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)orderEntries), (Function1)findKotlinRuntimeLibrary.1.INSTANCE);
            for (Object element$iv : $receiver$iv) {
                Library it;
                Library library = it = (Library)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)library, (String)"it");
                if (!(OutdatedKotlinRuntimeCheckerKt.getKotlinLibraryVersionProperties(library) != null)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Module> collectModulesWithOutdatedRuntime(@NotNull List<VersionedLibrary> libraries) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(libraries, (String)"libraries");
        Iterable iterable = $receiver$iv = (Iterable)libraries;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            VersionedLibrary it = (VersionedLibrary)element$iv$iv;
            Iterable list$iv$iv = it.getUsedInModules();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)var3_3;
    }

    public static final void notifyOutdatedKotlinRuntime(@NotNull Project project, @NotNull Collection<VersionedLibrary> outdatedLibraries) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(outdatedLibraries, (String)"outdatedLibraries");
        String pluginVersion = KotlinPluginUtil.getPluginVersion();
        if (outdatedLibraries.size() == 1) {
            VersionedLibrary versionedLibrary = (VersionedLibrary)CollectionsKt.first((Iterable)outdatedLibraries);
            String version = versionedLibrary.getVersion();
            String string2 = version;
            if (string2 == null) {
                string2 = "unknown";
            }
            String readableVersion = string2;
            String libraryName = versionedLibrary.getLibrary().getName();
            string = "<p>Your version of Kotlin runtime in '" + libraryName + "' library is " + readableVersion + ", while plugin version is " + pluginVersion + ".</p>" + "<p>Runtime library should be updated to avoid compatibility problems.</p>" + "<p><a href=\"update\">Update Runtime</a> <a href=\"ignore\">Ignore</a></p>";
        } else {
            String libraryNames2 = CollectionsKt.joinToString$default((Iterable)outdatedLibraries, null, null, null, (int)0, null, (Function1)notifyOutdatedKotlinRuntime.message.libraryNames.1.INSTANCE, (int)31, null);
            string = "<p>Version of Kotlin runtime is outdated in several libraries (" + libraryNames2 + "). Plugin version is " + pluginVersion + ".</p>" + "<p>Runtime libraries should be updated to avoid compatibility problems.</p>" + "<p><a href=\"update\">Update All</a> <a href=\"ignore\">Ignore</a></p>";
        }
        String message2 = string;
        Notifications.Bus.notify((Notification)new Notification(OUTDATED_RUNTIME_GROUP_DISPLAY_ID, OUTDATED_RUNTIME_GROUP_DISPLAY_ID, message2, NotificationType.WARNING, new NotificationListener(project, pluginVersion){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $pluginVersion;

            /*
             * WARNING - void declaration
             */
            public final void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)notification2, (String)"notification");
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                    if (Intrinsics.areEqual((Object)"update", (Object)event.getDescription())) {
                        void $receiver$iv$iv;
                        Iterable $receiver$iv;
                        Iterable iterable = $receiver$iv = (Iterable)OutdatedKotlinRuntimeCheckerKt.findOutdatedKotlinLibraries(this.$project);
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                        for (T item$iv$iv : $receiver$iv$iv) {
                            void it;
                            VersionedLibrary versionedLibrary = (VersionedLibrary)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            Library library = it.getLibrary();
                            collection.add(library);
                        }
                        List outdatedLibraries = (List)destination$iv$iv;
                        ApplicationManager.getApplication().invokeLater(new Runnable(this, outdatedLibraries){
                            final /* synthetic */ notifyOutdatedKotlinRuntime.1 this$0;
                            final /* synthetic */ List $outdatedLibraries;

                            public final void run() {
                                KotlinRuntimeLibraryUtilKt.updateLibraries(this.this$0.$project, this.$outdatedLibraries);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$outdatedLibraries = list2;
                            }
                        });
                        OutdatedKotlinRuntimeCheckerKt.access$suggestDeleteKotlinJsIfNeeded(this.$project, outdatedLibraries);
                    } else if (Intrinsics.areEqual((Object)"ignore", (Object)event.getDescription())) {
                        PropertiesComponent.getInstance((Project)this.$project).setValue(OutdatedKotlinRuntimeCheckerKt.access$getSUPPRESSED_PROPERTY_NAME$p(), this.$pluginVersion);
                    } else {
                        throw (Throwable)((Object)new AssertionError());
                    }
                    notification2.expire();
                }
            }
            {
                this.$project = project;
                this.$pluginVersion = string;
            }
        }), (Project)project);
    }

    public static final void deleteKotlinJs(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ApplicationManager.getApplication().invokeLater(new Runnable(project){
            final /* synthetic */ Project $project;

            public final void run() {
                ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(this){
                    final /* synthetic */ deleteKotlinJs.1 this$0;

                    public final void invoke() {
                        VirtualFile virtualFile2 = this.this$0.$project.getBaseDir().findFileByRelativePath("script/kotlin.js");
                        if (virtualFile2 == null) {
                            return;
                        }
                        VirtualFile kotlinJsFile = virtualFile2;
                        VirtualFile fileToDelete = PathUtil.getLocalFile((VirtualFile)kotlinJsFile);
                        try {
                            VirtualFile parent2 = fileToDelete.getParent();
                            fileToDelete.delete(null);
                            parent2.refresh(false, true);
                        }
                        catch (IOException ex) {
                            Notifications.Bus.notify((Notification)new Notification(OutdatedKotlinRuntimeCheckerKt.access$getOUTDATED_RUNTIME_GROUP_DISPLAY_ID$p(), "Error", "Could not delete 'script/kotlin.js': " + ex.getMessage(), NotificationType.ERROR));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.$project = project;
            }
        });
    }

    private static final void suggestDeleteKotlinJsIfNeeded(Project project, Collection<? extends Library> outdatedLibraries) {
        if (project.getBaseDir().findFileByRelativePath("script/kotlin.js") == null) {
            return;
        }
        boolean addNotification = false;
        for (Library library : outdatedLibraries) {
            boolean bl;
            JSLibraryStdPresentationProvider jSLibraryStdPresentationProvider = JSLibraryStdPresentationProvider.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)jSLibraryStdPresentationProvider), (String)"JSLibraryStdPresentationProvider.getInstance()");
            if (!KotlinLibraryUtilKt.isDetected(jSLibraryStdPresentationProvider, library)) continue;
            VirtualFile jsStdlibJar = KotlinLibraryUtilKt.getJsStdLibJar(library);
            boolean bl2 = bl = jsStdlibJar != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "jslibFile should not be null";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            VirtualFile virtualFile2 = jsStdlibJar;
            if (virtualFile2 == null) {
                Intrinsics.throwNpe();
            }
            if (virtualFile2.findFileByRelativePath("kotlin.js") != null) continue;
            addNotification = true;
            break;
        }
        if (!addNotification) {
            return;
        }
        String string = "<p>File 'script/kotlin.js' was probably created by an older version of the Kotlin plugin.</p><p>The new Kotlin plugin copies an up-to-date version of this file to the output directory automatically, so the old version of it can be deleted.</p><p><a href=\"delete\">Delete this file</a> <a href=\"ignore\">Ignore</a></p>";
        Notifications.Bus.notify((Notification)new Notification(OUTDATED_RUNTIME_GROUP_DISPLAY_ID, OUTDATED_RUNTIME_GROUP_DISPLAY_ID, string, NotificationType.WARNING, new NotificationListener(project){
            final /* synthetic */ Project $project;

            public final void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)notification2, (String)"notification");
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                    if (Intrinsics.areEqual((Object)"delete", (Object)event.getDescription())) {
                        OutdatedKotlinRuntimeCheckerKt.deleteKotlinJs(this.$project);
                    } else if (!Intrinsics.areEqual((Object)"ignore", (Object)event.getDescription())) {
                        throw (Throwable)((Object)new AssertionError());
                    }
                    notification2.expire();
                }
            }
            {
                this.$project = project;
            }
        }), (Project)project);
    }

    public static final boolean isRuntimeOutdated(@Nullable String libraryVersion, @NotNull String runtimeVersion) {
        Intrinsics.checkParameterIsNotNull((Object)runtimeVersion, (String)"runtimeVersion");
        return libraryVersion == null || StringsKt.startsWith$default((String)libraryVersion, (String)"internal-", (boolean)false, (int)2, null) != StringsKt.startsWith$default((String)runtimeVersion, (String)"internal-", (boolean)false, (int)2, null) || VersionComparatorUtil.compare((String)StringsKt.substringBefore$default((String)runtimeVersion, (String)"-release-", null, (int)2, null), (String)libraryVersion) > 0;
    }

    static {
        SUPPRESSED_PROPERTY_NAME = SUPPRESSED_PROPERTY_NAME;
        OUTDATED_RUNTIME_GROUP_DISPLAY_ID = OUTDATED_RUNTIME_GROUP_DISPLAY_ID;
    }

    public static final /* synthetic */ void access$suggestDeleteKotlinJsIfNeeded(@NotNull Project project, @NotNull Collection outdatedLibraries) {
        OutdatedKotlinRuntimeCheckerKt.suggestDeleteKotlinJsIfNeeded(project, outdatedLibraries);
    }

    @NotNull
    public static final /* synthetic */ String access$getSUPPRESSED_PROPERTY_NAME$p() {
        return SUPPRESSED_PROPERTY_NAME;
    }

    @NotNull
    public static final /* synthetic */ String access$getOUTDATED_RUNTIME_GROUP_DISPLAY_ID$p() {
        return OUTDATED_RUNTIME_GROUP_DISPLAY_ID;
    }
}

