/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.descriptorUtils;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0001\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\r\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"isCoroutineLambda", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z", "nameIfStandardType", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getNameIfStandardType", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/name/Name;", "getJetTypeFqName", "", "printTypeArguments", "hasPrimaryConstructor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "js.frontend"})
public final class DescriptorUtilsKt {
    @Nullable
    public static final Name getNameIfStandardType(@NotNull KotlinType $receiver) {
        ClassifierDescriptor classifierDescriptor;
        DeclarationDescriptor p1;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassifierDescriptor classifierDescriptor2 = $receiver.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor2 != null && (classifierDescriptor2 = KotlinBuiltIns.isBuiltIn(p1 = (DeclarationDescriptor)(classifierDescriptor = classifierDescriptor2)) ? classifierDescriptor : null) != null ? classifierDescriptor2.getName() : null;
    }

    @NotNull
    public static final String getJetTypeFqName(@NotNull KotlinType $receiver, boolean printTypeArguments) {
        String typeArgumentsAsString;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            String string = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ClassifierDescriptor declaration2 = classifierDescriptor;
        if (declaration2 instanceof TypeParameterDescriptor) {
            String string = StringUtil.join((Collection)((TypeParameterDescriptor)declaration2).getUpperBounds(), (Function)new Function<T, String>(printTypeArguments){
                final /* synthetic */ boolean $printTypeArguments;

                @NotNull
                public final String fun(KotlinType type2) {
                    return DescriptorUtilsKt.getJetTypeFqName(type2, this.$printTypeArguments);
                }
                {
                    this.$printTypeArguments = bl;
                }
            }, (String)"&");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.join(declarat\u2026intTypeArguments) }, \"&\")");
            return string;
        }
        List<TypeProjection> typeArguments = $receiver.getArguments();
        if (printTypeArguments && !typeArguments.isEmpty()) {
            String joinedTypeArguments2 = StringUtil.join((Collection)typeArguments, (Function)getJetTypeFqName.joinedTypeArguments.1.INSTANCE, (String)", ");
            typeArgumentsAsString = "<" + joinedTypeArguments2 + ">";
        } else {
            typeArgumentsAsString = "";
        }
        return DescriptorUtils.getFqName(declaration2).asString() + typeArgumentsAsString;
    }

    public static final boolean hasPrimaryConstructor(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getUnsubstitutedPrimaryConstructor() != null;
    }

    public static final boolean isCoroutineLambda(@NotNull DeclarationDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver instanceof AnonymousFunctionDescriptor && ((AnonymousFunctionDescriptor)$receiver).isSuspend();
    }
}

