/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalQuickFixAsIntentionAdapter
implements IntentionAction {
    private final LocalQuickFix myFix;
    @NotNull
    private final ProblemDescriptor myProblemDescriptor;

    public LocalQuickFixAsIntentionAdapter(@NotNull LocalQuickFix fix, @NotNull ProblemDescriptor problemDescriptor) {
        if (fix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "com/intellij/codeInspection/LocalQuickFixAsIntentionAdapter", "<init>"));
        }
        if (problemDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptor", "com/intellij/codeInspection/LocalQuickFixAsIntentionAdapter", "<init>"));
        }
        this.myFix = fix;
        this.myProblemDescriptor = problemDescriptor;
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myFix.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LocalQuickFixAsIntentionAdapter", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.myFix.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LocalQuickFixAsIntentionAdapter", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/LocalQuickFixAsIntentionAdapter", "isAvailable"));
        }
        return this.myProblemDescriptor.getStartElement() != null;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/LocalQuickFixAsIntentionAdapter", "invoke"));
        }
        this.myFix.applyFix(project, this.myProblemDescriptor);
    }

    @Override
    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentFile", "com/intellij/codeInspection/LocalQuickFixAsIntentionAdapter", "getElementToMakeWritable"));
        }
        return this.myFix.getElementToMakeWritable(currentFile);
    }

    @Override
    public boolean startInWriteAction() {
        return this.myFix.startInWriteAction();
    }
}

