/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.chains;

import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SimpleDiffRequestChain
extends UserDataHolderBase
implements DiffRequestChain {
    @NotNull
    private final List<DiffRequestProducerWrapper> myRequests;
    private int myIndex;

    public SimpleDiffRequestChain(@NotNull DiffRequest request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/chains/SimpleDiffRequestChain", "<init>"));
        }
        this(Collections.singletonList(request));
    }

    public SimpleDiffRequestChain(@NotNull List<? extends DiffRequest> requests) {
        if (requests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/diff/chains/SimpleDiffRequestChain", "<init>"));
        }
        this.myIndex = 0;
        this.myRequests = ContainerUtil.map(requests, request -> new DiffRequestProducerWrapper((DiffRequest)request));
    }

    @NotNull
    public List<DiffRequestProducerWrapper> getRequests() {
        List<DiffRequestProducerWrapper> list = this.myRequests;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/chains/SimpleDiffRequestChain", "getRequests"));
        }
        return list;
    }

    @Override
    public int getIndex() {
        return this.myIndex;
    }

    @Override
    public void setIndex(int index) {
        assert (index >= 0 && index < this.myRequests.size());
        this.myIndex = index;
    }

    public static class DiffRequestProducerWrapper
    implements DiffRequestProducer {
        @NotNull
        private final DiffRequest myRequest;

        public DiffRequestProducerWrapper(@NotNull DiffRequest request) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/chains/SimpleDiffRequestChain$DiffRequestProducerWrapper", "<init>"));
            }
            this.myRequest = request;
        }

        @NotNull
        public DiffRequest getRequest() {
            DiffRequest diffRequest = this.myRequest;
            if (diffRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/chains/SimpleDiffRequestChain$DiffRequestProducerWrapper", "getRequest"));
            }
            return diffRequest;
        }

        @Override
        @NotNull
        public String getName() {
            String string = StringUtil.notNullize((String)this.myRequest.getTitle(), (String)"Change");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/chains/SimpleDiffRequestChain$DiffRequestProducerWrapper", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/chains/SimpleDiffRequestChain$DiffRequestProducerWrapper", "process"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/chains/SimpleDiffRequestChain$DiffRequestProducerWrapper", "process"));
            }
            DiffRequest diffRequest = this.myRequest;
            if (diffRequest == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/chains/SimpleDiffRequestChain$DiffRequestProducerWrapper", "process"));
            }
            return diffRequest;
        }
    }
}

