/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.DashboardNode;
import com.intellij.execution.dashboard.DashboardRunConfigurationNode;
import com.intellij.execution.dashboard.DashboardRunConfigurationStatus;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.registry.Registry;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public abstract class RunDashboardContributor {
    public static final ExtensionPointName<RunDashboardContributor> EP_NAME = ExtensionPointName.create((String)"com.intellij.runDashboardContributor");
    private final ConfigurationType myType;

    protected RunDashboardContributor(ConfigurationType type) {
        this.myType = type;
    }

    public ConfigurationType getType() {
        return this.myType;
    }

    public void updatePresentation(PresentationData presentation, DashboardNode node) {
    }

    public DashboardRunConfigurationStatus getStatus(DashboardRunConfigurationNode node) {
        RunContentDescriptor descriptor = node.getDescriptor();
        if (descriptor == null) {
            return DashboardRunConfigurationStatus.STOPPED;
        }
        ProcessHandler processHandler = descriptor.getProcessHandler();
        if (processHandler == null) {
            return DashboardRunConfigurationStatus.STOPPED;
        }
        Integer exitCode = processHandler.getExitCode();
        if (exitCode == null) {
            return DashboardRunConfigurationStatus.STARTED;
        }
        Boolean terminationRequested = (Boolean)processHandler.getUserData(ProcessHandler.TERMINATION_REQUESTED);
        if (exitCode == 0 || terminationRequested != null && terminationRequested.booleanValue()) {
            return DashboardRunConfigurationStatus.STOPPED;
        }
        return DashboardRunConfigurationStatus.FAILED;
    }

    public static RunDashboardContributor getContributor(ConfigurationType type) {
        if (!Registry.is((String)"ide.run.dashboard")) {
            return null;
        }
        if (type != null) {
            for (RunDashboardContributor contributor : (RunDashboardContributor[])EP_NAME.getExtensions()) {
                if (!type.equals(contributor.getType())) continue;
                return contributor;
            }
        }
        return null;
    }

    public static boolean isShowInDashboard(ConfigurationType type) {
        return RunDashboardContributor.getContributor(type) != null;
    }
}

