/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.ModuleRunConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import java.util.Comparator;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RuntimeConfigurationProducer
implements Comparable,
Cloneable {
    public static final ExtensionPointName<RuntimeConfigurationProducer> RUNTIME_CONFIGURATION_PRODUCER = ExtensionPointName.create((String)"com.intellij.configurationProducer");
    public static final Comparator<RuntimeConfigurationProducer> COMPARATOR = new ProducerComparator();
    protected static final int PREFERED = -1;
    private final ConfigurationFactory myConfigurationFactory;
    private RunnerAndConfigurationSettings myConfiguration;
    protected boolean isClone;

    public RuntimeConfigurationProducer(ConfigurationType configurationType) {
        this(configurationType.getConfigurationFactories()[0]);
    }

    protected RuntimeConfigurationProducer(ConfigurationFactory configurationFactory) {
        this.myConfigurationFactory = configurationFactory;
    }

    public RuntimeConfigurationProducer createProducer(Location location, ConfigurationContext context) {
        PsiElement psiElement;
        Location<PsiElement> _location;
        RuntimeConfigurationProducer result = this.clone();
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = result.myConfiguration = location != null ? result.createConfigurationByElement(location, context) : null;
        if (result.myConfiguration != null && (_location = PsiLocation.fromPsiElement(psiElement = result.getSourceElement(), location.getModule())) != null) {
            RunManager runManager = RunManager.getInstance(context.getProject());
            ConfigurationType type = result.myConfiguration.getType();
            RunnerAndConfigurationSettings configuration = null;
            if (type != null) {
                configuration = result.findExistingByElement(_location, runManager.getConfigurationSettingsList(type), context);
            }
            if (configuration != null) {
                result.myConfiguration = configuration;
            } else {
                runManager.setUniqueNameIfNeed(result.myConfiguration);
            }
        }
        return result;
    }

    @Nullable
    public RunnerAndConfigurationSettings findExistingConfiguration(@NotNull Location location, ConfigurationContext context) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/execution/junit/RuntimeConfigurationProducer", "findExistingConfiguration"));
        }
        assert (this.isClone);
        RunManager runManager = RunManager.getInstance(location.getProject());
        List<RunnerAndConfigurationSettings> configurations = runManager.getConfigurationSettingsList(this.getConfigurationType());
        return this.findExistingByElement(location, configurations, context);
    }

    public abstract PsiElement getSourceElement();

    public RunnerAndConfigurationSettings getConfiguration() {
        assert (this.isClone);
        return this.myConfiguration;
    }

    public void setConfiguration(RunnerAndConfigurationSettings configuration) {
        assert (this.isClone);
        this.myConfiguration = configuration;
    }

    @Nullable
    protected abstract RunnerAndConfigurationSettings createConfigurationByElement(Location var1, ConfigurationContext var2);

    @Nullable
    protected RunnerAndConfigurationSettings findExistingByElement(Location location, @NotNull List<RunnerAndConfigurationSettings> existingConfigurations, ConfigurationContext context) {
        if (existingConfigurations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "existingConfigurations", "com/intellij/execution/junit/RuntimeConfigurationProducer", "findExistingByElement"));
        }
        assert (this.isClone);
        return null;
    }

    public RuntimeConfigurationProducer clone() {
        assert (!this.isClone);
        try {
            RuntimeConfigurationProducer clone = (RuntimeConfigurationProducer)super.clone();
            clone.isClone = true;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected RunnerAndConfigurationSettings cloneTemplateConfiguration(Project project, @Nullable ConfigurationContext context) {
        RunConfiguration original;
        if (context != null && (original = context.getOriginalConfiguration(this.myConfigurationFactory.getType())) != null) {
            RunConfiguration c = original instanceof DelegatingRuntimeConfiguration ? ((DelegatingRuntimeConfiguration)original).getPeer() : original;
            return RunManager.getInstance(project).createConfiguration(c.clone(), this.myConfigurationFactory);
        }
        return RunManager.getInstance(project).createRunConfiguration("", this.myConfigurationFactory);
    }

    protected ConfigurationFactory getConfigurationFactory() {
        return this.myConfigurationFactory;
    }

    public ConfigurationType getConfigurationType() {
        return this.myConfigurationFactory.getType();
    }

    public void perform(ConfigurationContext context, Runnable performRunnable) {
        performRunnable.run();
    }

    public static <T extends RuntimeConfigurationProducer> T getInstance(Class<T> aClass) {
        RuntimeConfigurationProducer[] configurationProducers;
        for (RuntimeConfigurationProducer configurationProducer : configurationProducers = (RuntimeConfigurationProducer[])Extensions.getExtensions(RUNTIME_CONFIGURATION_PRODUCER)) {
            if (configurationProducer.getClass() != aClass) continue;
            return (T)configurationProducer;
        }
        return null;
    }

    public static class DelegatingRuntimeConfiguration<T extends LocatableConfiguration>
    extends LocatableConfigurationBase
    implements ModuleRunConfiguration {
        private final T myConfig;

        public DelegatingRuntimeConfiguration(T config) {
            super(config.getProject(), config.getFactory(), config.getName());
            this.myConfig = config;
        }

        @Override
        @NotNull
        public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
            SettingsEditor<? extends RunConfiguration> settingsEditor = this.myConfig.getConfigurationEditor();
            if (settingsEditor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/RuntimeConfigurationProducer$DelegatingRuntimeConfiguration", "getConfigurationEditor"));
            }
            return settingsEditor;
        }

        @Override
        public DelegatingRuntimeConfiguration<T> clone() {
            return new DelegatingRuntimeConfiguration<LocatableConfiguration>((LocatableConfiguration)this.myConfig.clone());
        }

        @Override
        public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
            if (executor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/intellij/execution/junit/RuntimeConfigurationProducer$DelegatingRuntimeConfiguration", "getState"));
            }
            if (env == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/execution/junit/RuntimeConfigurationProducer$DelegatingRuntimeConfiguration", "getState"));
            }
            return this.myConfig.getState(executor, env);
        }

        @Override
        public void checkConfiguration() throws RuntimeConfigurationException {
            this.myConfig.checkConfiguration();
        }

        @Override
        public String suggestedName() {
            return this.myConfig.suggestedName();
        }

        @Override
        public void readExternal(Element element) throws InvalidDataException {
            this.myConfig.readExternal(element);
        }

        @Override
        public void writeExternal(Element element) throws WriteExternalException {
            this.myConfig.writeExternal(element);
        }

        public T getPeer() {
            return this.myConfig;
        }
    }

    private static class ProducerComparator
    implements Comparator<RuntimeConfigurationProducer> {
        private ProducerComparator() {
        }

        @Override
        public int compare(RuntimeConfigurationProducer producer1, RuntimeConfigurationProducer producer2) {
            PsiElement psiElement2;
            PsiElement psiElement1 = producer1.getSourceElement();
            if (ProducerComparator.doesContain(psiElement1, psiElement2 = producer2.getSourceElement())) {
                return 1;
            }
            if (ProducerComparator.doesContain(psiElement2, psiElement1)) {
                return -1;
            }
            return producer1.compareTo(producer2);
        }

        private static boolean doesContain(PsiElement container, PsiElement element) {
            while ((element = element.getParent()) != null) {
                if (!container.equals(element)) continue;
                return true;
            }
            return false;
        }
    }
}

