/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.util.List;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeRenderer
extends ColoredTreeCellRenderer {
    @Override
    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        PresentationData presentation;
        Color color;
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/util/treeView/NodeRenderer", "customizeCellRenderer"));
        }
        Object node = TreeUtil.getUserObject(value);
        if (node instanceof NodeDescriptor) {
            NodeDescriptor descriptor = (NodeDescriptor)node;
            color = descriptor.getColor();
            this.setIcon(descriptor.getIcon());
        }
        PresentationData presentationData = node instanceof PresentableNodeDescriptor ? ((PresentableNodeDescriptor)node).getPresentation() : (presentation = node instanceof NavigationItem ? (PresentationData)ObjectUtils.tryCast((Object)((NavigationItem)node).getPresentation(), PresentationData.class) : null);
        if (presentation != null) {
            color = node instanceof NodeDescriptor ? ((NodeDescriptor)node).getColor() : null;
            this.setIcon(presentation.getIcon(false));
            List<PresentableNodeDescriptor.ColoredFragment> coloredText = presentation.getColoredText();
            Color forcedForeground = presentation.getForcedTextForeground();
            if (coloredText.isEmpty()) {
                String text = tree.convertValueToText(value.toString(), selected, expanded, leaf, row, hasFocus);
                SimpleTextAttributes simpleTextAttributes = this.getSimpleTextAttributes(presentation, forcedForeground != null ? forcedForeground : color, node);
                this.append(text, simpleTextAttributes);
                String location = presentation.getLocationString();
                if (!StringUtil.isEmpty((String)location)) {
                    SimpleTextAttributes attributes = SimpleTextAttributes.merge(simpleTextAttributes, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    this.append(presentation.getLocationPrefix() + location + presentation.getLocationSuffix(), attributes, false);
                }
            } else {
                boolean first = true;
                for (PresentableNodeDescriptor.ColoredFragment each : coloredText) {
                    SimpleTextAttributes simpleTextAttributes = each.getAttributes();
                    if (each.getAttributes().getFgColor() == null && forcedForeground != null) {
                        simpleTextAttributes = NodeRenderer.addColorToSimpleTextAttributes(each.getAttributes(), forcedForeground);
                    }
                    if (first) {
                        TextAttributes forcedAttributes;
                        TextAttributesKey textAttributesKey = presentation.getTextAttributesKey();
                        if (textAttributesKey != null && (forcedAttributes = this.getColorsScheme().getAttributes(textAttributesKey)) != null) {
                            simpleTextAttributes = SimpleTextAttributes.merge(simpleTextAttributes, SimpleTextAttributes.fromTextAttributes(forcedAttributes));
                        }
                        first = false;
                    }
                    boolean isMain = simpleTextAttributes != SimpleTextAttributes.GRAYED_ATTRIBUTES;
                    this.append(each.getText(), simpleTextAttributes, isMain);
                }
                String location = presentation.getLocationString();
                if (!StringUtil.isEmpty((String)location)) {
                    this.append(presentation.getLocationPrefix() + location + presentation.getLocationSuffix(), SimpleTextAttributes.GRAY_ATTRIBUTES, false);
                }
            }
            this.setToolTipText(presentation.getTooltip());
        } else if (value != null) {
            String text = value.toString();
            if (node instanceof NodeDescriptor) {
                text = node.toString();
            }
            if ((text = tree.convertValueToText(text, selected, expanded, leaf, row, hasFocus)) == null) {
                text = "";
            }
            this.append(text);
            this.setToolTipText(null);
        }
        if (!AbstractTreeUi.isLoadingNode(value)) {
            SpeedSearchUtil.applySpeedSearchHighlighting(tree, this, true, selected);
        }
    }

    @NotNull
    protected EditorColorsScheme getColorsScheme() {
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/NodeRenderer", "getColorsScheme"));
        }
        return editorColorsScheme;
    }

    @NotNull
    protected SimpleTextAttributes getSimpleTextAttributes(@NotNull PresentationData presentation, Color color, @NotNull Object node) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/ide/util/treeView/NodeRenderer", "getSimpleTextAttributes"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ide/util/treeView/NodeRenderer", "getSimpleTextAttributes"));
        }
        SimpleTextAttributes simpleTextAttributes = NodeRenderer.getSimpleTextAttributes(presentation, this.getColorsScheme());
        SimpleTextAttributes simpleTextAttributes2 = NodeRenderer.addColorToSimpleTextAttributes(simpleTextAttributes, color);
        if (simpleTextAttributes2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/NodeRenderer", "getSimpleTextAttributes"));
        }
        return simpleTextAttributes2;
    }

    private static SimpleTextAttributes addColorToSimpleTextAttributes(SimpleTextAttributes simpleTextAttributes, Color color) {
        if (color != null) {
            TextAttributes textAttributes = simpleTextAttributes.toTextAttributes();
            textAttributes.setForegroundColor(color);
            simpleTextAttributes = SimpleTextAttributes.fromTextAttributes(textAttributes);
        }
        return simpleTextAttributes;
    }

    public static SimpleTextAttributes getSimpleTextAttributes(@Nullable ItemPresentation presentation) {
        return NodeRenderer.getSimpleTextAttributes(presentation, EditorColorsManager.getInstance().getGlobalScheme());
    }

    public static SimpleTextAttributes getSimpleTextAttributes(@Nullable ItemPresentation presentation, @NotNull EditorColorsScheme colorsScheme) {
        if (colorsScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsScheme", "com/intellij/ide/util/treeView/NodeRenderer", "getSimpleTextAttributes"));
        }
        if (presentation instanceof ColoredItemPresentation) {
            TextAttributesKey textAttributesKey = ((ColoredItemPresentation)presentation).getTextAttributesKey();
            if (textAttributesKey == null) {
                return SimpleTextAttributes.REGULAR_ATTRIBUTES;
            }
            TextAttributes textAttributes = colorsScheme.getAttributes(textAttributesKey);
            return textAttributes == null ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.fromTextAttributes(textAttributes);
        }
        return SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }
}

