/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptorProvidingKey;
import com.intellij.ide.util.treeView.TreeRunnable;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeState
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance(TreeState.class);
    public static final Key<WeakReference<ActionCallback>> CALLBACK = Key.create((String)"Callback");
    private static final String EXPAND_TAG = "expand";
    private static final String SELECT_TAG = "select";
    private static final String PATH_TAG = "path";
    private static final int NOT_MATCHED = 0;
    private static final int ID_MATCHED = 1;
    private static final int OBJECT_MATCHED = 2;
    private final List<List<PathElement>> myExpandedPaths;
    private final List<List<PathElement>> mySelectedPaths;
    private boolean myScrollToSelection;

    private TreeState(List<List<PathElement>> expandedPaths, List<List<PathElement>> selectedPaths) {
        this.myExpandedPaths = expandedPaths;
        this.mySelectedPaths = selectedPaths;
        this.myScrollToSelection = true;
    }

    public boolean isEmpty() {
        return this.myExpandedPaths.isEmpty() && this.mySelectedPaths.isEmpty();
    }

    public void readExternal(Element element) throws InvalidDataException {
        TreeState.readExternal(element, this.myExpandedPaths, EXPAND_TAG);
        TreeState.readExternal(element, this.mySelectedPaths, SELECT_TAG);
    }

    private static void readExternal(Element root, List<List<PathElement>> list, String name) throws InvalidDataException {
        list.clear();
        for (Element element : root.getChildren(name)) {
            for (Element child : element.getChildren(PATH_TAG)) {
                Object[] path2 = (PathElement[])XmlSerializer.deserialize((Element)child, PathElement[].class);
                list.add((List<PathElement>)ContainerUtil.immutableList((Object[])path2));
            }
        }
    }

    @NotNull
    public static TreeState createOn(JTree tree, DefaultMutableTreeNode treeNode) {
        TreeState treeState = new TreeState(TreeState.createPaths(tree, TreeUtil.collectExpandedPaths(tree, new TreePath(treeNode.getPath()))), TreeState.createPaths(tree, TreeUtil.collectSelectedPaths(tree, new TreePath(treeNode.getPath()))));
        if (treeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/TreeState", "createOn"));
        }
        return treeState;
    }

    @NotNull
    public static TreeState createOn(@NotNull JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/util/treeView/TreeState", "createOn"));
        }
        TreeState treeState = new TreeState(TreeState.createPaths(tree, TreeUtil.collectExpandedPaths(tree)), new ArrayList<List<PathElement>>());
        if (treeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/TreeState", "createOn"));
        }
        return treeState;
    }

    @NotNull
    public static TreeState createFrom(@Nullable Element element) {
        TreeState state = new TreeState(new ArrayList<List<PathElement>>(), new ArrayList<List<PathElement>>());
        try {
            if (element != null) {
                state.readExternal(element);
            }
        }
        catch (InvalidDataException e) {
            LOG.warn((Throwable)e);
        }
        TreeState treeState = state;
        if (treeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/TreeState", "createFrom"));
        }
        return treeState;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        TreeState.writeExternal(element, this.myExpandedPaths, EXPAND_TAG);
        TreeState.writeExternal(element, this.mySelectedPaths, SELECT_TAG);
    }

    private static void writeExternal(Element element, List<List<PathElement>> list, String name) throws WriteExternalException {
        Element root = new Element(name);
        for (List<PathElement> path2 : list) {
            Element e = XmlSerializer.serialize((Object)path2.toArray());
            e.setName(PATH_TAG);
            root.addContent(e);
        }
        element.addContent(root);
    }

    private static List<List<PathElement>> createPaths(JTree tree, List<TreePath> paths) {
        ArrayList<List<PathElement>> result = new ArrayList<List<PathElement>>();
        for (TreePath path2 : paths) {
            if (!tree.isRootVisible() && path2.getPathCount() <= 1) continue;
            ContainerUtil.addIfNotNull(result, TreeState.createPath(tree.getModel(), path2));
        }
        return result;
    }

    @NotNull
    private static List<PathElement> createPath(@NotNull TreeModel model, @NotNull TreePath treePath) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/util/treeView/TreeState", "createPath"));
        }
        if (treePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treePath", "com/intellij/ide/util/treeView/TreeState", "createPath"));
        }
        ArrayList<PathElement> result = new ArrayList<PathElement>();
        Object prev = null;
        for (int i2 = 0; i2 < treePath.getPathCount(); ++i2) {
            Object cur = treePath.getPathComponent(i2);
            Object userObject = TreeUtil.getUserObject(cur);
            int childIndex = prev == null ? 0 : model.getIndexOfChild(prev, cur);
            PathElement pe = new PathElement(TreeState.calcId(userObject), TreeState.calcType(userObject), childIndex, userObject);
            result.add(pe);
            prev = cur;
        }
        ArrayList<PathElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/TreeState", "createPath"));
        }
        return arrayList;
    }

    @NotNull
    private static String calcId(@Nullable Object userObject) {
        Object value;
        if (userObject == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/TreeState", "calcId"));
            }
            return "";
        }
        Object object = userObject instanceof NodeDescriptorProvidingKey ? ((NodeDescriptorProvidingKey)userObject).getKey() : (value = userObject instanceof AbstractTreeNode ? ((AbstractTreeNode)userObject).getValue() : userObject);
        if (value instanceof NavigationItem) {
            String string;
            try {
                String name = ((NavigationItem)value).getName();
                string = name != null ? name : StringUtil.notNullize((String)value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/TreeState", "calcId"));
            }
            return string;
        }
        String string = StringUtil.notNullize((String)userObject.toString());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/TreeState", "calcId"));
        }
        return string;
    }

    @NotNull
    private static String calcType(@Nullable Object userObject) {
        if (userObject == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/TreeState", "calcType"));
            }
            return "";
        }
        String name = userObject.getClass().getName();
        String string = Integer.toHexString(StringHash.murmur((String)name, (int)31)) + ":" + StringUtil.getShortName((String)name);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/TreeState", "calcType"));
        }
        return string;
    }

    public void applyTo(@NotNull JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/util/treeView/TreeState", "applyTo"));
        }
        this.applyTo(tree, tree.getModel().getRoot());
    }

    public void applyTo(final @NotNull JTree tree, final @Nullable Object root) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/util/treeView/TreeState", "applyTo"));
        }
        if (root == null) {
            return;
        }
        final TreeFacade facade = TreeFacade.getFacade(tree);
        ActionCallback callback = facade.getInitialized().doWhenDone(new TreeRunnable("TreeState.applyTo: on done facade init"){

            @Override
            public void perform() {
                facade.batch(indicator -> TreeState.this.applyExpandedTo(facade, new TreePath(root), indicator));
            }
        });
        if (tree.getSelectionCount() == 0) {
            callback.doWhenDone(new TreeRunnable("TreeState.applyTo: on done"){

                @Override
                public void perform() {
                    if (tree.getSelectionCount() == 0) {
                        TreeState.this.applySelectedTo(tree);
                    }
                }
            });
        }
    }

    private void applyExpandedTo(@NotNull TreeFacade tree, @NotNull TreePath rootPath, @NotNull ProgressIndicator indicator) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/util/treeView/TreeState", "applyExpandedTo"));
        }
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "com/intellij/ide/util/treeView/TreeState", "applyExpandedTo"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/util/treeView/TreeState", "applyExpandedTo"));
        }
        indicator.checkCanceled();
        if (rootPath.getPathCount() <= 0) {
            return;
        }
        for (List<PathElement> path2 : this.myExpandedPaths) {
            int index;
            if (path2.isEmpty() || TreeState.pathMatches(path2.get(index = rootPath.getPathCount() - 1), rootPath.getPathComponent(index)) == 0) continue;
            TreeState.expandImpl(0, path2, rootPath, tree, indicator);
        }
    }

    private void applySelectedTo(@NotNull JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/util/treeView/TreeState", "applySelectedTo"));
        }
        ArrayList selection = new ArrayList();
        for (List<PathElement> path2 : this.mySelectedPaths) {
            TreeModel model = tree.getModel();
            TreePath treePath = new TreePath(model.getRoot());
            for (int i2 = 1; treePath != null && i2 < path2.size(); ++i2) {
                treePath = TreeState.findMatchedChild(model, treePath, path2.get(i2));
            }
            ContainerUtil.addIfNotNull(selection, (Object)treePath);
        }
        if (selection.isEmpty()) {
            return;
        }
        for (TreePath treePath : selection) {
            tree.setSelectionPath(treePath);
        }
        if (this.myScrollToSelection) {
            TreeUtil.showRowCentered(tree, tree.getRowForPath((TreePath)selection.get(0)), true, true);
        }
    }

    @Nullable
    private static TreePath findMatchedChild(@NotNull TreeModel model, @NotNull TreePath treePath, @NotNull PathElement pathElement) {
        Object child;
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ide/util/treeView/TreeState", "findMatchedChild"));
        }
        if (treePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treePath", "com/intellij/ide/util/treeView/TreeState", "findMatchedChild"));
        }
        if (pathElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathElement", "com/intellij/ide/util/treeView/TreeState", "findMatchedChild"));
        }
        Object parent = treePath.getLastPathComponent();
        int childCount = model.getChildCount(parent);
        boolean idMatchedFound = false;
        Object idMatchedChild = null;
        for (int j = 0; j < childCount; ++j) {
            child = model.getChild(parent, j);
            int match = TreeState.pathMatches(pathElement, child);
            if (match == 2) {
                return treePath.pathByAddingChild(child);
            }
            if (match != 1 || idMatchedFound) continue;
            idMatchedChild = child;
            idMatchedFound = true;
        }
        if (idMatchedFound) {
            return treePath.pathByAddingChild(idMatchedChild);
        }
        if (childCount > 0) {
            int index = Math.max(0, Math.min(pathElement.index, childCount - 1));
            child = model.getChild(parent, index);
            return treePath.pathByAddingChild(child);
        }
        return null;
    }

    private static int pathMatches(@NotNull PathElement pe, Object child) {
        if (pe == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pe", "com/intellij/ide/util/treeView/TreeState", "pathMatches"));
        }
        Object userObject = TreeUtil.getUserObject(child);
        if (pe.userObject != null && pe.userObject.equals(userObject)) {
            return 2;
        }
        return Comparing.equal((String)pe.id, (String)TreeState.calcId(userObject)) && Comparing.equal((String)pe.type, (String)TreeState.calcType(userObject)) ? 1 : 0;
    }

    private static void expandImpl(final int positionInPath, final List<PathElement> path2, final TreePath treePath, final TreeFacade tree, final ProgressIndicator indicator) {
        tree.expand(treePath).doWhenDone(new TreeRunnable("TreeState.applyTo"){

            @Override
            public void perform() {
                PathElement next;
                indicator.checkCanceled();
                PathElement pathElement = next = positionInPath == path2.size() - 1 ? null : (PathElement)path2.get(positionInPath + 1);
                if (next == null) {
                    return;
                }
                Object parent = treePath.getLastPathComponent();
                TreeModel model = tree.tree.getModel();
                int childCount = model.getChildCount(parent);
                for (int j = 0; j < childCount; ++j) {
                    Object child = tree.tree.getModel().getChild(parent, j);
                    if (TreeState.pathMatches(next, child) == 0) continue;
                    TreeState.expandImpl(positionInPath + 1, path2, treePath.pathByAddingChild(child), tree, indicator);
                    break;
                }
            }
        });
    }

    public void setScrollToSelection(boolean scrollToSelection) {
        this.myScrollToSelection = scrollToSelection;
    }

    public String toString() {
        String content;
        Element st = new Element("TreeState");
        try {
            this.writeExternal(st);
            content = JDOMUtil.writeChildren((Element)st, (String)"\n");
        }
        catch (IOException e) {
            content = ExceptionUtil.getThrowableText((Throwable)e);
        }
        return "TreeState(" + this.myScrollToSelection + ")\n" + content;
    }

    static class BuilderFacade
    extends TreeFacade {
        private final AbstractTreeBuilder myBuilder;

        BuilderFacade(AbstractTreeBuilder builder) {
            super((JTree)ObjectUtils.notNull((Object)builder.getTree()));
            this.myBuilder = builder;
        }

        @Override
        public ActionCallback getInitialized() {
            return this.myBuilder.getReady(this);
        }

        @Override
        public void batch(Progressive progressive) {
            this.myBuilder.batch(progressive);
        }

        @Override
        public ActionCallback expand(TreePath treePath) {
            Object userObject = TreeUtil.getUserObject(treePath.getLastPathComponent());
            if (!(userObject instanceof NodeDescriptor)) {
                return ActionCallback.REJECTED;
            }
            NodeDescriptor desc = (NodeDescriptor)userObject;
            Object element = this.myBuilder.getTreeStructureElement(desc);
            ActionCallback result = new ActionCallback();
            this.myBuilder.expand(element, result.createSetDoneRunnable());
            return result;
        }
    }

    static class JTreeFacade
    extends TreeFacade {
        JTreeFacade(JTree tree) {
            super(tree);
        }

        @Override
        public ActionCallback expand(@NotNull TreePath treePath) {
            if (treePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treePath", "com/intellij/ide/util/treeView/TreeState$JTreeFacade", TreeState.EXPAND_TAG));
            }
            this.tree.expandPath(treePath);
            return ActionCallback.DONE;
        }

        @Override
        public ActionCallback getInitialized() {
            WeakReference ref = (WeakReference)UIUtil.getClientProperty((Object)this.tree, CALLBACK);
            ActionCallback callback = (ActionCallback)SoftReference.dereference((Reference)ref);
            if (callback != null) {
                return callback;
            }
            return ActionCallback.DONE;
        }

        @Override
        public void batch(Progressive progressive) {
            progressive.run(new EmptyProgressIndicator());
        }
    }

    static abstract class TreeFacade {
        final JTree tree;

        TreeFacade(@NotNull JTree tree) {
            if (tree == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/util/treeView/TreeState$TreeFacade", "<init>"));
            }
            this.tree = tree;
        }

        abstract ActionCallback getInitialized();

        abstract ActionCallback expand(TreePath var1);

        abstract void batch(Progressive var1);

        static TreeFacade getFacade(JTree tree) {
            AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor(tree);
            return builder != null ? new BuilderFacade(builder) : new JTreeFacade(tree);
        }
    }

    @Tag(value="item")
    static class PathElement {
        @Attribute(value="name")
        public String id;
        @Attribute(value="type")
        public String type;
        @Attribute(value="user")
        public String userStr;
        Object userObject;
        final int index;

        PathElement() {
            this(null, null, -1, null);
        }

        PathElement(String itemId, String itemType, int itemIndex, Object userObject) {
            this.id = itemId;
            this.type = itemType;
            this.index = itemIndex;
            this.userStr = userObject instanceof String ? (String)userObject : null;
            this.userObject = userObject;
        }

        public String toString() {
            return this.id + ": " + this.type;
        }
    }
}

