/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.reflect;

import com.intellij.jam.JamElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamChildrenQuery;
import com.intellij.jam.reflect.JamFieldMeta;
import com.intellij.jam.reflect.JamMemberArchetype;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiPackage;
import com.intellij.semantic.SemKey;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JamPackageMeta<Jam extends JamElement>
extends JamMemberMeta<PsiPackage, Jam> {
    public JamPackageMeta(@Nullable JamMemberArchetype<? super PsiPackage, ? super Jam> parent, Class<Jam> jamClass) {
        super(parent, jamClass);
    }

    public JamPackageMeta(Class<Jam> jamClass) {
        super(jamClass);
    }

    public JamPackageMeta(@Nullable JamMemberArchetype<? super PsiPackage, ? super Jam> parent, Class<? extends Jam> jamClass, SemKey<Jam> jamKey) {
        super(parent, jamClass, jamKey);
    }

    public JamPackageMeta<Jam> addChildrenQuery(JamChildrenQuery<?> childrenQuery) {
        super.addChildrenQuery(childrenQuery);
        return this;
    }

    public JamPackageMeta<Jam> addPomTargetProducer(@NotNull PairConsumer<Jam, Consumer<PomTarget>> producer) {
        if (producer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producer", "com/intellij/jam/reflect/JamPackageMeta", "addPomTargetProducer"));
        }
        super.addPomTargetProducer((PairConsumer)producer);
        return this;
    }

    public <T extends JamElement> JamChildrenQuery<T> addAnnotatedMethodsQuery(JamAnnotationMeta anno, Class<T> jamClass) {
        return this.addAnnotatedMethodsQuery(anno, new JamMethodMeta<T>(jamClass));
    }

    public <T extends JamElement> JamChildrenQuery<T> addAnnotatedMethodsQuery(JamAnnotationMeta anno, JamMethodMeta<T> methodMeta) {
        JamChildrenQuery query = JamChildrenQuery.annotatedMethods(anno, methodMeta.addAnnotation(anno));
        this.addChildrenQuery(query);
        return query;
    }

    public <T extends JamElement> JamChildrenQuery<T> addAnnotatedFieldsQuery(JamAnnotationMeta anno, Class<T> jamClass) {
        return this.addAnnotatedFieldsQuery(anno, new JamFieldMeta<T>(jamClass));
    }

    public <T extends JamElement> JamChildrenQuery<T> addAnnotatedFieldsQuery(JamAnnotationMeta anno, JamFieldMeta<T> fieldMeta) {
        JamChildrenQuery query = JamChildrenQuery.annotatedFields(anno, fieldMeta.addAnnotation(anno));
        this.addChildrenQuery(query);
        return query;
    }

    @Override
    public JamPackageMeta<Jam> addAnnotation(JamAnnotationMeta meta) {
        super.addAnnotation(meta);
        return this;
    }

    public JamPackageMeta<Jam> addRootAnnotation(JamAnnotationMeta meta) {
        super.addRootAnnotation(meta);
        return this;
    }
}

