/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.LegacyCodeStyleSettingsManager;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectCodeStyleSettingsManager", storages={@Storage(value="codeStyleSettings.xml")})
public class ProjectCodeStyleSettingsManager
extends CodeStyleSettingsManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + ProjectCodeStyleSettingsManager.class));
    private volatile boolean myIsLoaded;
    private static final Object LEGACY_SETTINGS_IMPORT_LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importLegacySettings(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/codeStyle/ProjectCodeStyleSettingsManager", "importLegacySettings"));
        }
        if (!this.myIsLoaded) {
            Object object = LEGACY_SETTINGS_IMPORT_LOCK;
            synchronized (object) {
                LegacyCodeStyleSettingsManager legacySettingsManager;
                if (!this.myIsLoaded && (legacySettingsManager = ServiceManager.getService(project, LegacyCodeStyleSettingsManager.class)) != null && legacySettingsManager.getState() != null) {
                    this.loadState(legacySettingsManager.getState());
                    LOG.info("Imported old project code style settings.");
                }
            }
        }
    }

    @Override
    public void loadState(Element state) {
        super.loadState(state);
        this.myIsLoaded = true;
    }
}

