/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.compiler.CompilerTestUtil;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.TempDirTestFixtureImpl;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class CompilerTester {
    private Project myProject;
    private List<Module> myModules;
    private TempDirTestFixture myMainOutput;

    public CompilerTester(Module module) throws Exception {
        this(module.getProject(), Collections.singletonList(module));
    }

    public CompilerTester(Project project, List<Module> modules) throws Exception {
        this.myProject = project;
        this.myModules = modules;
        this.myMainOutput = new TempDirTestFixtureImpl();
        this.myMainOutput.setUp();
        CompilerTestUtil.enableExternalCompiler();
        new WriteCommandAction(this.getProject(), new PsiFile[0]){

            @Override
            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/CompilerTester$1", "run"));
                }
                CompilerProjectExtension.getInstance(this.getProject()).setCompilerOutputUrl(CompilerTester.this.myMainOutput.findOrCreateDir("out").getUrl());
                for (Module module : CompilerTester.this.myModules) {
                    ModuleRootModificationUtil.setModuleSdk(module, JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk());
                }
            }
        }.execute();
    }

    public void tearDown() {
        CompilerTestUtil.disableExternalCompiler(this.getProject());
        try {
            this.myMainOutput.tearDown();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.myMainOutput = null;
            this.myModules = null;
        }
    }

    private Project getProject() {
        return this.myProject;
    }

    public void deleteClassFile(String className) throws IOException {
        WriteAction.run(() -> this.touch(JavaPsiFacade.getInstance(this.getProject()).findClass(className, GlobalSearchScope.allScope(this.getProject())).getContainingFile().getVirtualFile()));
    }

    @Nullable
    public VirtualFile findClassFile(String className, Module module) {
        VirtualFile path2 = ModuleRootManager.getInstance(module).getModuleExtension(CompilerModuleExtension.class).getCompilerOutputPath();
        assert (path2 != null);
        path2.getChildren();
        path2.refresh(false, true);
        return path2.findFileByRelativePath(className.replace('.', '/') + ".class");
    }

    public void touch(final VirtualFile file) throws IOException {
        new WriteAction(){

            @Override
            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/CompilerTester$2", "run"));
                }
                file.setBinaryContent(file.contentsToByteArray(), -1L, file.getTimeStamp() + 1L);
                File ioFile = VfsUtilCore.virtualToIoFile(file);
                assert (ioFile.setLastModified(ioFile.lastModified() - 100000L));
                file.refresh(false, false);
            }
        }.execute().throwException();
    }

    public void setFileText(final PsiFile file, final String text) throws IOException {
        new WriteAction(){

            @Override
            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/CompilerTester$3", "run"));
                }
                VirtualFile virtualFile2 = file.getVirtualFile();
                VfsUtil.saveText((VirtualFile)ObjectUtils.assertNotNull((Object)virtualFile2), text);
            }
        }.execute().throwException();
        this.touch(file.getVirtualFile());
    }

    public void setFileName(final PsiFile file, final String name) {
        new WriteCommandAction(this.getProject(), new PsiFile[0]){

            @Override
            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/CompilerTester$4", "run"));
                }
                file.setName(name);
            }
        }.execute();
    }

    public List<CompilerMessage> make() {
        return this.runCompiler((Consumer<CompileStatusNotification>)((Consumer)callback -> CompilerManager.getInstance(this.getProject()).make((CompileStatusNotification)callback)));
    }

    public List<CompilerMessage> rebuild() {
        return this.runCompiler((Consumer<CompileStatusNotification>)((Consumer)callback -> CompilerManager.getInstance(this.getProject()).rebuild((CompileStatusNotification)callback)));
    }

    public List<CompilerMessage> compileModule(Module module) {
        return this.runCompiler((Consumer<CompileStatusNotification>)((Consumer)callback -> CompilerManager.getInstance(this.getProject()).compile(module, (CompileStatusNotification)callback)));
    }

    public List<CompilerMessage> make(CompileScope scope) {
        return this.runCompiler((Consumer<CompileStatusNotification>)((Consumer)callback -> CompilerManager.getInstance(this.getProject()).make(scope, (CompileStatusNotification)callback)));
    }

    public List<CompilerMessage> compileFiles(VirtualFile ... files) {
        return this.runCompiler((Consumer<CompileStatusNotification>)((Consumer)callback -> CompilerManager.getInstance(this.getProject()).compile(files, (CompileStatusNotification)callback)));
    }

    public List<CompilerMessage> runCompiler(Consumer<CompileStatusNotification> runnable) {
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        ErrorReportingCallback callback = new ErrorReportingCallback(semaphore);
        EdtTestUtil.runInEdtAndWait(() -> {
            CompilerTester.refreshVfs(this.getProject().getProjectFilePath());
            for (Module module : this.myModules) {
                CompilerTester.refreshVfs(module.getModuleFilePath());
            }
            PlatformTestUtil.saveProject((Project)this.getProject());
            CompilerTestUtil.saveApplicationSettings();
            for (Module module : this.myModules) {
                Path ioFile = Paths.get(module.getModuleFilePath(), new String[0]);
                if (Files.exists(ioFile, new LinkOption[0])) continue;
                this.getProject().save();
                assert (Files.exists(ioFile, new LinkOption[0])) : "File does not exist: " + ioFile.toString();
            }
            runnable.consume((Object)callback);
        });
        while (!semaphore.waitFor(100L)) {
            if (!SwingUtilities.isEventDispatchThread()) continue;
            UIUtil.dispatchAllInvocationEvents();
        }
        callback.throwException();
        return callback.getMessages();
    }

    private static void refreshVfs(String path2) {
        VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(path2));
        if (vFile != null) {
            vFile.refresh(false, false);
        }
    }

    private static class ErrorReportingCallback
    implements CompileStatusNotification {
        private final Semaphore mySemaphore;
        private Throwable myError;
        private final List<CompilerMessage> myMessages = new ArrayList<CompilerMessage>();

        public ErrorReportingCallback(Semaphore semaphore) {
            this.mySemaphore = semaphore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
            try {
                for (CompilerMessageCategory category : CompilerMessageCategory.values()) {
                    CompilerMessage[] messages;
                    for (CompilerMessage message : messages = compileContext.getMessages(category)) {
                        String text = message.getMessage();
                        if (category == CompilerMessageCategory.INFORMATION && (text.contains("Compilation completed successfully") || text.contains("used to compile") || text.startsWith("Using Groovy-Eclipse"))) continue;
                        this.myMessages.add(message);
                    }
                }
                Assert.assertFalse((String)"Code did not compile!", (boolean)aborted);
            }
            catch (Throwable t) {
                this.myError = t;
            }
            finally {
                this.mySemaphore.up();
            }
        }

        void throwException() {
            if (this.myError != null) {
                throw new RuntimeException(this.myError);
            }
        }

        public List<CompilerMessage> getMessages() {
            return this.myMessages;
        }
    }
}

